/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.utility;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class IndexDoclet
extends Doclet {
    private static PrintWriter out;

    public static boolean start(RootDoc rootDoc) {
        try {
            ClassDoc[] classDocArray = rootDoc.classes();
            IndexDoclet.setupPrint();
            System.out.println("Started " + rootDoc);
            int n = 0;
            while (n < classDocArray.length) {
                ClassDoc classDoc = classDocArray[n];
                if (classDoc.tags("deprecated").length < 1 && classDoc.isPublic()) {
                    String string = classDoc.isInterface() ? "interface" : "class";
                    out.println("  <p><em>" + classDoc.containingPackage() + "</em> ");
                    out.println("  <p><i>" + string + "</i> " + classDoc.name());
                    out.println("  <p> extends " + IndexDoclet.superclasses(classDoc));
                    out.println("  <p> implements " + IndexDoclet.interfaces(classDoc));
                    IndexDoclet.printConstructors(classDoc.constructors());
                    IndexDoclet.printMethods(classDoc.methods());
                    out.println("  </" + string + ">\n\n");
                }
                ++n;
            }
            IndexDoclet.closePrint();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    static String superclasses(ClassDoc classDoc) {
        ClassDoc classDoc2 = classDoc.superclass();
        if (classDoc2 == null) {
            return "";
        }
        if (classDoc2.typeName().equals("Object")) {
            return "Object";
        }
        return IndexDoclet.superclasses(classDoc2) + " - " + classDoc2.typeName();
    }

    static String interfaces(ClassDoc classDoc) {
        String string = "";
        ClassDoc[] classDocArray = classDoc.interfaces();
        int n = 0;
        while (n < classDocArray.length) {
            string = string + (string.equals("") ? "" : ", ") + classDocArray[n].typeName();
            ++n;
        }
        return string;
    }

    static void setupPrint() throws IOException {
        out = new PrintWriter(new FileOutputStream("/home/rcm/tmp/api.html"));
        out.println("<html>");
        out.println("<title>API</title>");
        out.println("<body>");
    }

    static void closePrint() throws IOException {
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    static void printExceptions(ExecutableMemberDoc executableMemberDoc) {
        ClassDoc[] classDocArray = executableMemberDoc.thrownExceptions();
        if (classDocArray.length > 0) {
            out.print(" throws ");
        }
        int n = 0;
        while (n < classDocArray.length) {
            if (n > 0) {
                out.print(", ");
            }
            out.print("<b>" + classDocArray[n].name() + "</b>");
            ++n;
        }
    }

    static void printParameters(ExecutableMemberDoc executableMemberDoc) {
        Parameter[] parameterArray = executableMemberDoc.parameters();
        int n = 0;
        while (n < parameterArray.length) {
            out.print("<b>" + parameterArray[n].type().typeName() + "</b> " + parameterArray[n].name());
            ++n;
        }
    }

    static void printConstructors(ConstructorDoc[] constructorDocArray) {
        int n = 0;
        while (n < constructorDocArray.length) {
            if (constructorDocArray[n].tags("deprecated").length < 1 && (constructorDocArray[n].isPublic() || constructorDocArray[n].isProtected())) {
                out.print("    <p><i>" + constructorDocArray[n].modifiers() + "</i> " + " <b>" + constructorDocArray[n].name() + "</b>( ");
                IndexDoclet.printParameters((ExecutableMemberDoc)constructorDocArray[n]);
                out.println(" )");
                IndexDoclet.printExceptions((ExecutableMemberDoc)constructorDocArray[n]);
                out.println(" ;");
            }
            ++n;
        }
    }

    static void printMethods(MethodDoc[] methodDocArray) {
        int n = 0;
        while (n < methodDocArray.length) {
            if (methodDocArray[n].tags("deprecated").length < 1 && (methodDocArray[n].isPublic() || methodDocArray[n].isProtected())) {
                out.print("    <p><i>" + methodDocArray[n].modifiers() + "</i> " + methodDocArray[n].returnType().typeName() + " <b>" + methodDocArray[n].name() + "</b>( ");
                IndexDoclet.printParameters((ExecutableMemberDoc)methodDocArray[n]);
                out.println(" )");
                IndexDoclet.printExceptions((ExecutableMemberDoc)methodDocArray[n]);
                out.println(" ;");
            }
            ++n;
        }
    }
}

