/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.utility;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.log4j.Category;

public final class ConfigurationParameters {
    private static Category LOG = Category.getInstance((Class)(class$org$nakedobjects$utility$ConfigurationParameters == null ? (class$org$nakedobjects$utility$ConfigurationParameters = ConfigurationParameters.class$("org.nakedobjects.utility.ConfigurationParameters")) : class$org$nakedobjects$utility$ConfigurationParameters));
    private static ConfigurationParameters instance = new ConfigurationParameters();
    private Properties p = new Properties();
    private String resource;
    static /* synthetic */ Class class$org$nakedobjects$utility$ConfigurationParameters;

    public Color getColor(String string) {
        return this.getColor(string, null);
    }

    public Color getColor(String string, Color color) {
        String string2 = this.p.getProperty(string);
        if (string2 == null) {
            return color;
        }
        return Color.decode(string2);
    }

    public Font getFont(String string) {
        return this.getFont(string, null);
    }

    public Font getFont(String string, Font font) {
        String string2 = this.p.getProperty(string);
        if (string2 == null) {
            return font;
        }
        return Font.decode(string2);
    }

    public static final ConfigurationParameters getInstance() {
        return instance;
    }

    public int getInteger(String string, int n) {
        String string2 = this.p.getProperty(string);
        if (string2 == null) {
            return n;
        }
        return Integer.valueOf(string2);
    }

    public Properties getProperties() {
        return this.p;
    }

    public String getResource() {
        return this.resource;
    }

    public String getString(String string) {
        return this.p.getProperty(string);
    }

    public String getString(String string, String string2) {
        return this.p.getProperty(string, string2);
    }

    public boolean hasProperty(String string) {
        return ((Hashtable)this.p).containsKey(string);
    }

    private void load(InputStream inputStream) {
        try {
            if (inputStream != null) {
                this.p.load(inputStream);
            }
        }
        catch (IOException iOException) {
            LOG.error((Object)("Error reading properties" + iOException.getMessage()));
        }
    }

    public void load(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL = new URL("file:///" + new File(string).getAbsolutePath());
            }
            catch (MalformedURLException malformedURLException2) {
                throw new IllegalArgumentException("Invalid resource " + string);
            }
        }
        this.load(uRL);
    }

    public void load(URL uRL) {
        try {
            this.load(uRL.openConnection().getInputStream());
            this.resource = uRL.toExternalForm();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to load configuration detail from " + iOException.getMessage());
        }
    }

    public void load(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ((Hashtable)this.p).put(string, properties.getProperty(string));
        }
    }

    public String toString() {
        return "ConfigurationParameters [file=" + this.resource + ",p=" + this.p + "]";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

