/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.value;

import java.text.NumberFormat;
import java.text.ParseException;
import org.nakedobjects.object.Naked;
import org.nakedobjects.object.Title;
import org.nakedobjects.object.ValueParseException;
import org.nakedobjects.object.value.Magnitude;

public class Percentage
extends Magnitude {
    private static final NumberFormat FORMAT = NumberFormat.getPercentInstance();
    private float value;
    private boolean isNull;

    public Percentage() {
        this(0.0f);
        this.isNull = false;
    }

    public Percentage(float f) {
        this.value = f;
        this.isNull = false;
    }

    public Percentage(String string) {
        try {
            this.parse(string);
            this.isNull = false;
        }
        catch (ValueParseException valueParseException) {
            throw new IllegalArgumentException("Could not parse value: " + string);
        }
    }

    public Percentage(Percentage percentage) {
        this.isNull = percentage.isNull;
        this.value = percentage.value;
    }

    public void add(double d) {
        this.checkCanOperate();
        this.value = (float)((double)this.value + d);
    }

    public void clear() {
        this.isNull = true;
    }

    public void copyObject(Naked naked) {
        if (!(naked instanceof Percentage)) {
            throw new IllegalArgumentException("Can only copy the value of  a Percentage object");
        }
        this.isNull = ((Percentage)naked).isNull;
        this.value = ((Percentage)naked).value;
    }

    public void divide(double d) {
        this.checkCanOperate();
        this.value = (float)((double)this.value / d);
    }

    public double doubleValue() {
        this.checkCanOperate();
        return this.value;
    }

    public float floatValue() {
        this.checkCanOperate();
        return this.value;
    }

    public String getObjectHelpText() {
        return "A floating point number object.";
    }

    public double getValue() {
        this.checkCanOperate();
        return this.value;
    }

    public int intValue() {
        this.checkCanOperate();
        return (int)this.value;
    }

    public boolean isEmpty() {
        return this.isNull;
    }

    public boolean isEqualTo(Magnitude magnitude) {
        if (magnitude instanceof Percentage) {
            if (this.isNull) {
                return magnitude.isEmpty();
            }
            return ((Percentage)magnitude).value == this.value;
        }
        throw new IllegalArgumentException("Parameter must be of type WholeNumber");
    }

    public boolean isLessThan(Magnitude magnitude) {
        if (magnitude instanceof Percentage) {
            return !this.isEmpty() && !magnitude.isEmpty() && this.value < ((Percentage)magnitude).value;
        }
        throw new IllegalArgumentException("Parameter must be of type WholeNumber");
    }

    public long longValue() {
        this.checkCanOperate();
        return (long)this.value;
    }

    public void multiply(double d) {
        this.checkCanOperate();
        this.value = (float)((double)this.value * d);
    }

    public void parse(String string) throws ValueParseException {
        if (string.trim().equals("")) {
            this.clear();
        } else {
            try {
                this.value = FORMAT.parse(string).floatValue();
            }
            catch (ParseException parseException) {
                throw new ValueParseException(parseException, "Invalid number");
            }
        }
    }

    public void reset() {
        this.value = 0.0f;
        this.isNull = false;
    }

    public void setValue(float f) {
        this.value = f;
        this.isNull = false;
    }

    public void setValue(Percentage percentage) {
        this.value = percentage.value;
        this.isNull = percentage.isNull;
    }

    public short shortValue() {
        this.checkCanOperate();
        return (short)this.value;
    }

    public void subtract(double d) {
        this.checkCanOperate();
        this.add(-d);
    }

    public Title title() {
        return new Title(this.isEmpty() ? "" : FORMAT.format(this.value));
    }

    public void restoreString(String string) {
        this.setValue(Float.valueOf(string).floatValue());
    }

    public String saveString() {
        return String.valueOf(this.floatValue());
    }
}

