/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.value;

import org.nakedobjects.object.Naked;
import org.nakedobjects.object.Title;
import org.nakedobjects.object.ValueParseException;
import org.nakedobjects.object.value.AbstractNakedValue;

public class Logical
extends AbstractNakedValue {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private boolean flag;
    private boolean isNull;

    public Logical() {
        this(false);
        this.isNull = false;
    }

    public Logical(boolean bl) {
        this.flag = bl;
        this.isNull = false;
    }

    public boolean booleanValue() {
        return this.flag;
    }

    public void clear() {
        this.isNull = true;
    }

    public void copyObject(Naked naked) {
        if (!(naked instanceof Logical)) {
            throw new IllegalArgumentException("Can only copy the value of  a Logical object");
        }
        this.isNull = ((Logical)naked).isNull;
        this.flag = ((Logical)naked).flag;
    }

    public String getObjectHelpText() {
        return "A Logical object containing either True or False.";
    }

    public boolean isEmpty() {
        return this.isNull;
    }

    public boolean isSameAs(Naked naked) {
        if (naked instanceof Logical) {
            return ((Logical)naked).flag == this.flag;
        }
        return false;
    }

    public boolean isSet() {
        this.checkCanOperate();
        return this.flag;
    }

    public void parse(String string) throws ValueParseException {
        if (string.trim().equals("")) {
            this.clear();
        } else {
            if (TRUE.startsWith(string.toLowerCase())) {
                this.set();
            } else {
                this.reset();
            }
            this.isNull = false;
        }
    }

    public void reset() {
        this.flag = false;
    }

    public void set() {
        this.flag = true;
    }

    public void setValue(boolean bl) {
        this.flag = bl;
    }

    public void setValue(Logical logical) {
        this.flag = logical.flag;
    }

    public Title title() {
        return new Title(this.isEmpty() ? "" : (this.flag ? "TRUE" : "FALSE"));
    }

    public void restoreString(String string) {
        if (string.equals("NULL")) {
            this.clear();
        } else {
            this.setValue(string.equals(TRUE));
        }
    }

    public String saveString() {
        if (this.isEmpty()) {
            return "NULL";
        }
        return this.isSet() ? TRUE : FALSE;
    }
}

