/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.control.About;
import org.nakedobjects.object.distribution.AssociateRequest;
import org.nakedobjects.object.distribution.DissociateRequest;
import org.nakedobjects.object.reflect.Association;
import org.nakedobjects.object.reflect.Field;

public class OneToManyAssociation
extends Association {
    public OneToManyAssociation(String string, Class clazz, Method method, Method method2, Method method3, Method method4, Method method5) {
        super(string, clazz, method, method2, method3, method4, method5);
    }

    public String getLabel(NakedObject nakedObject) {
        About about = this.getAbout(nakedObject);
        return this.getLabel(about);
    }

    public void init(NakedObject nakedObject, Object object) {
        Field.LOG.debug((Object)("MultiRole.init() " + nakedObject + "/" + object));
        try {
            NakedCollection nakedCollection = (NakedCollection)this.getMemberMethod().invoke((Object)nakedObject, new Object[0]);
            if (nakedCollection.getOid() == null) {
                NakedCollection nakedCollection2 = (NakedCollection)object;
                nakedCollection.setOid(nakedCollection2.getOid());
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Field.LOG.error((Object)("Exception executing " + this.getMemberMethod()), invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            Field.LOG.error((Object)("Illegal access of " + this.getMemberMethod()), (Throwable)illegalAccessException);
        }
    }

    public boolean isAggregate() {
        return true;
    }

    public void remove(NakedObject nakedObject, NakedObject nakedObject2) {
        if (nakedObject2 == null) {
            throw new NullPointerException("element should not be null");
        }
        Field.LOG.debug((Object)("remove() " + nakedObject + "/" + nakedObject2));
        if (this.isDistributed(nakedObject)) {
            try {
                new DissociateRequest(nakedObject, this, nakedObject2).execute();
            }
            catch (ObjectStoreException objectStoreException) {
                Field.LOG.error((Object)"Problem with distribution ", objectStoreException.getException());
                throw (RuntimeException)objectStoreException.getException();
            }
        }
        if (this.removeMethod == null) {
            ((NakedCollection)this.get(nakedObject)).remove(nakedObject2);
        } else {
            try {
                this.removeMethod.invoke((Object)nakedObject, nakedObject2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("remove method expects a " + this.getType().getName() + " object; not a " + nakedObject2.getClass().getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                Field.LOG.error((Object)("Exception executing " + this.setMethod), invocationTargetException.getTargetException());
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
            catch (IllegalAccessException illegalAccessException) {
                Field.LOG.error((Object)("Illegal access of " + this.setMethod), (Throwable)illegalAccessException);
                throw new RuntimeException(illegalAccessException.getMessage());
            }
        }
    }

    public void set(NakedObject nakedObject, Object object) {
        if (object == null) {
            throw new NullPointerException("Can't use null to add an item to a collection");
        }
        if (this.isDistributed(nakedObject)) {
            try {
                new AssociateRequest(nakedObject, this, (NakedObject)object).execute();
            }
            catch (ObjectStoreException objectStoreException) {
                Field.LOG.error((Object)("Problem with distribution " + this.setMethod), objectStoreException.getException());
                throw (RuntimeException)objectStoreException.getException();
            }
        }
        Field.LOG.debug((Object)("set multirole " + this.getName() + " in " + nakedObject + " with " + object));
        if (this.addMethod == null) {
            ((NakedCollection)this.get(nakedObject)).add((NakedObject)object);
        } else {
            try {
                this.addMethod.invoke((Object)nakedObject, object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("set method expects a " + this.getType().getName() + " object; not a " + object.getClass().getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                Field.LOG.error((Object)("Exception executing " + this.setMethod), invocationTargetException.getTargetException());
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
            catch (IllegalAccessException illegalAccessException) {
                Field.LOG.error((Object)("Illegal access of " + this.setMethod), (Throwable)illegalAccessException);
                throw new RuntimeException(illegalAccessException.getMessage());
            }
        }
    }

    public String toString() {
        String string = (this.getMemberMethod() == null ? "" : "GET") + (this.setMethod == null ? "" : " SET") + (this.addMethod == null ? "" : " ADD") + (this.removeMethod == null ? "" : " REMOVE");
        return "OneToManyAssociation [name=\"" + this.getName() + "\", method=" + this.getMemberMethod() + ",about=" + this.getAboutMethod() + ", methods=" + string + ", type=" + this.getType() + " ]";
    }
}

