/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Category;
import org.nakedobjects.object.NakedClass;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.PersistenceType;
import org.nakedobjects.object.UpdateNotifier;
import org.nakedobjects.object.collection.InternalCollection;
import org.nakedobjects.object.distribution.AddElementRequest;
import org.nakedobjects.object.distribution.ContainsElementRequest;
import org.nakedobjects.object.distribution.CreateInstanceRequest;
import org.nakedobjects.object.distribution.DataForObjectRequest;
import org.nakedobjects.object.distribution.DestroyObjectRequest;
import org.nakedobjects.object.distribution.GetObjectRequest;
import org.nakedobjects.object.distribution.HasInstancesRequest;
import org.nakedobjects.object.distribution.IsFirstElementRequest;
import org.nakedobjects.object.distribution.IsFirstInstanceRequest;
import org.nakedobjects.object.distribution.IsLastElementRequest;
import org.nakedobjects.object.distribution.IsLastInstanceRequest;
import org.nakedobjects.object.distribution.MakePersistentRequest;
import org.nakedobjects.object.distribution.NextElementsRequest;
import org.nakedobjects.object.distribution.NextInstancesRequest;
import org.nakedobjects.object.distribution.NumberOfElementsRequest;
import org.nakedobjects.object.distribution.NumberOfInstancesRequest;
import org.nakedobjects.object.distribution.PreviousElementsRequest;
import org.nakedobjects.object.distribution.PreviousInstancesRequest;
import org.nakedobjects.object.distribution.ProxyRequester;
import org.nakedobjects.object.distribution.RemoveElementRequest;
import org.nakedobjects.object.distribution.Request;
import org.nakedobjects.object.distribution.SerialNumberRequest;
import org.nakedobjects.object.distribution.UpdateMessageException;
import org.nakedobjects.object.distribution.UpdateReceiver;
import org.nakedobjects.object.distribution.UpdateReceiverThread;
import org.nakedobjects.utility.ConfigurationParameters;
import org.nakedobjects.utility.Log;

public final class ProxyObjectStore
implements NakedObjectStore {
    static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$object$distribution$ProxyObjectStore == null ? (class$org$nakedobjects$object$distribution$ProxyObjectStore = ProxyObjectStore.class$("org.nakedobjects.object.distribution.ProxyObjectStore")) : class$org$nakedobjects$object$distribution$ProxyObjectStore));
    public static final String REPLICATION_TYPE = "nakedobjects.proxy-object-store.replication";
    public static final PersistenceType DEFAULT_TYPE = PersistenceType.DATA;
    private PersistenceType persistenceType;
    private Hashtable objectCache = new Hashtable();
    private Log log;
    private UpdateNotifier notifier;
    private UpdateReceiverThread receiver;
    private ProxyRequester requester;
    static /* synthetic */ Class class$org$nakedobjects$object$distribution$ProxyObjectStore;

    public ProxyObjectStore(UpdateNotifier updateNotifier, UpdateReceiver updateReceiver, ProxyRequester proxyRequester) {
        String string = ConfigurationParameters.getInstance().getString(REPLICATION_TYPE);
        if (string == null) {
            this.persistenceType = DEFAULT_TYPE;
        } else if (string.equals(PersistenceType.PROXY.toString())) {
            this.persistenceType = PersistenceType.PROXY;
        } else if (string.equals(PersistenceType.DATA.toString())) {
            this.persistenceType = PersistenceType.DATA;
        } else {
            throw new RuntimeException("In the configuration file, nakedobjects.proxy-object-store.replication must be either proxy or data");
        }
        this.notifier = updateNotifier;
        this.receiver = new UpdateReceiverThread(this);
        this.receiver.setReceiver(updateReceiver);
        this.receiver.start();
        this.requester = proxyRequester;
        proxyRequester.init();
    }

    public void addElement(NakedCollection nakedCollection, NakedObject nakedObject) throws ObjectStoreException {
        new AddElementRequest(nakedCollection, nakedObject).execute();
    }

    public boolean areObjectsDistributed() {
        return this.persistenceType() == PersistenceType.PROXY || this.persistenceType() == PersistenceType.DATA;
    }

    public boolean areObjectsProxied() {
        return this.persistenceType() == PersistenceType.PROXY;
    }

    protected void broadcastAddUpdate(NakedCollection nakedCollection, NakedObject nakedObject) {
        this.notifier.broadcastAdd(nakedCollection, nakedObject);
    }

    protected void broadcastObjectUpdate(NakedObject nakedObject) {
        this.notifier.broadcastObject(nakedObject);
    }

    protected void broadcastRemoveUpdate(NakedCollection nakedCollection, NakedObject nakedObject) {
        this.notifier.broadcastRemove(nakedCollection, nakedObject);
    }

    public Enumeration cache() {
        return this.objectCache.elements();
    }

    public void cache(NakedObject nakedObject) {
        this.objectCache.put(nakedObject.getOid(), nakedObject);
    }

    public Enumeration classes() {
        throw new IllegalStateException("Proxy object store cannot list classes");
    }

    public void clearCache() {
        this.objectCache = new Hashtable();
    }

    public void clearCache(NakedObject nakedObject) {
        this.objectCache.remove(nakedObject.getOid());
    }

    public boolean containsElement(NakedCollection nakedCollection, NakedObject nakedObject) throws ObjectStoreException {
        return new ContainsElementRequest(nakedCollection, nakedObject).contains();
    }

    public void destroyObject(NakedObject nakedObject) throws ObjectStoreException {
        new DestroyObjectRequest(nakedObject).execute();
        this.objectCache.remove(nakedObject.getOid());
    }

    public void endTransaction() throws ObjectStoreException {
    }

    public Vector getNextElements(NakedCollection nakedCollection, NakedObject nakedObject, int n) throws ObjectStoreException {
        return new NextElementsRequest(nakedCollection, nakedObject, n).getElements(this);
    }

    public Vector getNextInstances(NakedObject nakedObject, NakedObject nakedObject2, int n) throws ObjectStoreException {
        return new NextInstancesRequest(nakedObject, nakedObject2, n).getElements(this);
    }

    public NakedObject getObject(Object object) throws ObjectStoreException {
        if (this.objectCache.containsKey(object)) {
            LOG.debug((Object)("Object for " + object + " retrieved from cache"));
            return (NakedObject)this.objectCache.get(object);
        }
        return this.getRemoteObject(object);
    }

    public Vector getPreviousElements(NakedCollection nakedCollection, NakedObject nakedObject, int n) throws ObjectStoreException {
        return new PreviousElementsRequest(nakedCollection, nakedObject, n).getElements(this);
    }

    public Vector getPreviousInstances(NakedObject nakedObject, NakedObject nakedObject2, int n) throws ObjectStoreException {
        return new PreviousInstancesRequest(nakedObject, nakedObject2, n).getElements(this);
    }

    public NakedObject getRemoteObject(Object object) throws ObjectStoreException {
        NakedObject nakedObject = new GetObjectRequest(object).getObject();
        this.cache(nakedObject);
        return nakedObject;
    }

    public boolean hasInstances(NakedClass nakedClass) throws ObjectStoreException {
        return new HasInstancesRequest(nakedClass).hasInstances();
    }

    public boolean isFirstElement(NakedCollection nakedCollection, NakedObject nakedObject) throws ObjectStoreException {
        return new IsFirstElementRequest(nakedCollection, nakedObject).isFirst();
    }

    public boolean isFirstInstance(NakedObject nakedObject, NakedObject nakedObject2) throws ObjectStoreException {
        return new IsFirstInstanceRequest(nakedObject, nakedObject2).isFirst();
    }

    public boolean isLastElement(NakedCollection nakedCollection, NakedObject nakedObject) throws ObjectStoreException {
        return new IsLastElementRequest(nakedCollection, nakedObject).isFirst();
    }

    public boolean isLastInstance(NakedObject nakedObject, NakedObject nakedObject2) throws ObjectStoreException {
        return new IsLastInstanceRequest(nakedObject, nakedObject2).isFirst();
    }

    public boolean isObjectCached(Object object) {
        return this.objectCache.containsKey(object);
    }

    protected void log() {
        this.log.log();
    }

    protected void log(String string) {
        this.log.log(string);
    }

    public void makePersistent(NakedObject nakedObject) throws ObjectStoreException {
        new MakePersistentRequest(nakedObject).makePersistent();
        this.cache(nakedObject);
    }

    public String name() {
        return "Proxy Object Store";
    }

    public int numberOfElements(NakedCollection nakedCollection) throws ObjectStoreException {
        return new NumberOfElementsRequest(nakedCollection).size();
    }

    public int numberOfInstances(NakedObject nakedObject) throws ObjectStoreException {
        return new NumberOfInstancesRequest(nakedObject).size();
    }

    public PersistenceType persistenceType() {
        return this.persistenceType;
    }

    public void removeElement(NakedCollection nakedCollection, NakedObject nakedObject) throws ObjectStoreException {
        new RemoveElementRequest(nakedCollection, nakedObject).execute();
    }

    public void resolve(NakedObject nakedObject) throws ObjectStoreException {
        if (nakedObject.isResolved()) {
            return;
        }
        try {
            if (!(nakedObject instanceof InternalCollection)) {
                new DataForObjectRequest(nakedObject).update(this);
            }
            nakedObject.setResolved();
        }
        catch (UpdateMessageException updateMessageException) {
            LOG.error((Object)("Failed to resolve " + nakedObject), (Throwable)updateMessageException);
        }
    }

    public void save(NakedObject nakedObject) {
    }

    Serializable send(Request request) throws ObjectStoreException {
        return this.requester.send(request);
    }

    public long serialNumber(String string) throws ObjectStoreException {
        return new SerialNumberRequest(string).getSerialNumber();
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setUpdateNotifier(UpdateNotifier updateNotifier) {
        this.notifier = updateNotifier;
        String string = ConfigurationParameters.getInstance().getString(REPLICATION_TYPE);
        if (string == null) {
            this.persistenceType = DEFAULT_TYPE;
        } else if (string.equals(PersistenceType.PROXY.toString())) {
            this.persistenceType = PersistenceType.PROXY;
        } else if (string.equals(PersistenceType.DATA.toString())) {
            this.persistenceType = PersistenceType.DATA;
        } else {
            throw new RuntimeException("In the configuration file, nakedobjects.proxy-object-store.replication must be either proxy or data");
        }
    }

    public void shutdown() {
        this.receiver.shutdown();
        this.requester.shutdown();
    }

    public void startTransaction() throws ObjectStoreException {
    }

    public void init() throws ObjectStoreException {
    }

    public NakedObject createInstance(NakedClass nakedClass) throws ObjectStoreException {
        NakedObject nakedObject = new CreateInstanceRequest(nakedClass).getNewInstance();
        this.cache(nakedObject);
        return nakedObject;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

