/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.distribution.simple;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.log4j.Category;
import org.nakedobjects.distribution.simple.CounterOutputStream;
import org.nakedobjects.distribution.simple.SocketedObjectServer;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.distribution.Request;
import org.nakedobjects.object.distribution.RequestResponse;
import org.nakedobjects.object.distribution.ServerRequestException;

public class SocketedRequestConnection
implements Runnable {
    static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$distribution$simple$SocketedRequestConnection == null ? (class$org$nakedobjects$distribution$simple$SocketedRequestConnection = SocketedRequestConnection.class$("org.nakedobjects.distribution.simple.SocketedRequestConnection")) : class$org$nakedobjects$distribution$simple$SocketedRequestConnection));
    private Socket clientSocket;
    private RequestResponse requestResponse;
    private ObjectInputStream in = null;
    private ObjectOutputStream out = null;
    private SocketedObjectServer server;
    static /* synthetic */ Class class$org$nakedobjects$distribution$simple$SocketedRequestConnection;

    public SocketedRequestConnection(Socket socket, SocketedObjectServer socketedObjectServer) {
        this.clientSocket = socket;
        this.server = socketedObjectServer;
        this.requestResponse = new RequestResponse(socketedObjectServer);
    }

    private void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                LOG.error((Object)"Error while closing socket input stream", (Throwable)iOException);
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                LOG.error((Object)"Error while closing socket output stream", (Throwable)iOException);
            }
        }
    }

    protected String getClient() {
        return this.clientSocket.getInetAddress().getHostName();
    }

    protected Request receiveRequest() throws ServerRequestException {
        try {
            this.in = new ObjectInputStream(this.clientSocket.getInputStream());
            return (Request)this.in.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.close();
            throw new ServerRequestException(classNotFoundException);
        }
        catch (IOException iOException) {
            this.close();
            throw new ServerRequestException(iOException);
        }
    }

    protected void returnResponse(Object object) {
        try {
            try {
                OutputStream outputStream = this.clientSocket.getOutputStream();
                CounterOutputStream counterOutputStream = new CounterOutputStream(outputStream);
                this.out = new ObjectOutputStream(counterOutputStream);
                this.out.writeObject(object);
                LOG.debug((Object)(counterOutputStream.getSize() + " bytes sent in response"));
            }
            catch (IOException iOException) {
                LOG.error((Object)"Failed to return response to caller", (Throwable)iOException);
                Object var5_6 = null;
                this.close();
            }
            Object var5_5 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.close();
            throw throwable;
        }
    }

    public void run() {
        try {
            try {
                this.returnResponse(this.requestResponse.generateResponse(this.receiveRequest(), this.getClient()));
            }
            catch (ObjectStoreException objectStoreException) {
                this.returnResponse(objectStoreException);
                Object var3_2 = null;
                this.close();
            }
            Object var3_1 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.close();
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

