/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import org.nakedobjects.basicgui.view.Display;
import org.nakedobjects.basicgui.view.TableRow;
import org.nakedobjects.basicgui.view.View;
import org.nakedobjects.basicgui.view.border.RowBorder;

public class TableLayout
implements LayoutManager {
    private RowBorder rowBorder;
    private int hgap;
    private int vgap;
    private int noCells;
    private int[] cellWidth;
    private int rowLabelWidth;

    public TableLayout(RowBorder rowBorder) {
        this(rowBorder, 0, 0);
    }

    public TableLayout(RowBorder rowBorder, int n, int n2) {
        this.rowBorder = rowBorder;
        this.hgap = n;
        this.vgap = n2;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public int getColumnWidth(int n) {
        if (this.cellWidth == null) {
            return 0;
        }
        return this.cellWidth[n];
    }

    public int getHeaderWidth() {
        return this.rowLabelWidth;
    }

    private boolean isTableRow(Container container) {
        Display display = (Display)((Object)container);
        View view = display.getViewer().getView();
        return view instanceof TableRow;
    }

    public void layoutContainer(Container container) {
        if (this.isTableRow(container)) {
            Insets insets = container.getInsets();
            int n = insets.top;
            int n2 = this.rowLabelWidth;
            Component[] componentArray = container.getComponents();
            int n3 = 0;
            while (n3 < componentArray.length) {
                Dimension dimension = componentArray[n3].getMinimumSize();
                componentArray[n3].setBounds(n2, n, this.cellWidth[n3] - this.hgap, dimension.height);
                n2 += this.cellWidth[n3];
                ++n3;
            }
        } else {
            Insets insets = container.getInsets();
            int n = insets.top;
            int n4 = container.getSize().height - insets.bottom;
            int n5 = insets.left;
            int n6 = container.getSize().width - insets.right;
            int n7 = container.getSize().width - insets.right - insets.left;
            Component[] componentArray = container.getComponents();
            int n8 = 0;
            while (n8 < componentArray.length) {
                Dimension dimension = componentArray[n8].getMinimumSize();
                if (dimension.height + this.vgap + n > n4) {
                    n = insets.top;
                    if ((n5 += n7 + this.hgap) >= n6) break;
                }
                componentArray[n8].setBounds(n5, n, n7, dimension.height);
                n += dimension.height + this.vgap;
                ++n8;
            }
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        if (this.isTableRow(container)) {
            Component[] componentArray = container.getComponents();
            this.noCells = componentArray.length;
            if (this.cellWidth == null) {
                this.cellWidth = new int[this.noCells];
            }
            Display display = (Display)((Object)container);
            this.rowLabelWidth = Math.max(this.rowLabelWidth, this.rowBorder.getHeaderWidth(display.getViewer().getObject()));
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < componentArray.length) {
                this.cellWidth[n3] = Math.max(this.cellWidth[n3], componentArray[n3].getMinimumSize().width);
                n2 = Math.max(n2, componentArray[n3].getMinimumSize().height);
                n += this.cellWidth[n3];
                ++n3;
            }
            return new Dimension(this.rowLabelWidth + n, n2);
        }
        Dimension dimension = new Dimension(0, 0);
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Dimension dimension2 = componentArray[n].getMinimumSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height += dimension2.height + this.vgap;
            ++n;
        }
        Insets insets = container.getInsets();
        dimension.height += insets.top + insets.bottom;
        dimension.width += insets.left + insets.right;
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public void removeLayoutComponent(Component component) {
    }

    public String toString() {
        return "TableLayout [columns=" + this.noCells + ",labelWidth=" + this.rowLabelWidth + "]";
    }
}

