/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import org.nakedobjects.basicgui.view.AssociationViewer;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.StatusColor;
import org.nakedobjects.basicgui.view.TextStyle;
import org.nakedobjects.basicgui.view.ViewColor;
import org.nakedobjects.basicgui.view.ViewContent;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.utility.Debug;

public abstract class SmallIconContent
extends ViewContent {
    protected static final int IMAGE_LABEL_GAP = 6;
    protected TextStyle style;

    public SmallIconContent() {
        this(TextStyle.getStyle(1));
    }

    public SmallIconContent(TextStyle textStyle) {
        this.style = textStyle;
    }

    public Dimension getMinimumSize(NakedObject nakedObject) {
        int n;
        int n2;
        FontMetrics fontMetrics = this.style.getMetrics();
        if (nakedObject == null) {
            n2 = 72;
            n = fontMetrics.getAscent() + fontMetrics.getDescent() * 2;
            n = Math.max(n, 16);
        } else {
            Image image = nakedObject.iconImage(16);
            int n3 = 0;
            if (this.title(nakedObject) != null) {
                n3 = fontMetrics.stringWidth(this.title(nakedObject));
            }
            int n4 = fontMetrics.getHeight() + fontMetrics.getDescent();
            int n5 = image == null ? 16 : image.getWidth(null);
            int n6 = image == null ? 16 : image.getHeight(null);
            n2 = n5 + 6 + n3;
            n = Math.max(n4, n6);
        }
        return new Dimension(n2, n + 1);
    }

    public void paint(Graphics graphics, Rectangle rectangle, ObjectViewer objectViewer) {
        NakedObject nakedObject = objectViewer.getObject();
        Color color = StatusColor.colorFor(objectViewer.getDisplayState(), ViewColor.textNormal);
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.height;
        graphics.setFont(this.style.getFont());
        if (nakedObject == null) {
            if (color == ViewColor.objectCanDrop || color == ViewColor.objectCantDrop) {
                graphics.setColor(color);
            } else {
                graphics.setColor(ViewColor.outlineNormal);
            }
            graphics.fillOval(n + 2, 0, 12, 12);
            FontMetrics fontMetrics = this.style.getMetrics();
            String string = objectViewer instanceof AssociationViewer ? objectViewer.typeName() : "Object";
            graphics.drawString(string, n + 16 + 6, fontMetrics.getAscent());
        } else {
            String string = this.title(nakedObject) == null ? "" : this.title(nakedObject);
            Image image = nakedObject.iconImage(16);
            int n4 = 0;
            if (image == null) {
                n4 = 16;
                graphics.setColor(Color.red);
                graphics.drawOval(n, (n3 - 16) / 2, n4, 16);
                graphics.drawString(nakedObject.getNakedClass().getShortName().substring(0, 2), n + 4, 16);
            } else {
                n4 = image.getWidth(null);
                graphics.drawImage(image, n, 0, null);
            }
            graphics.setColor(color);
            FontMetrics fontMetrics = this.style.getMetrics();
            int n5 = n2 + n3 / 2;
            graphics.drawString(string, n + n4 + 6, fontMetrics.getAscent());
            if (Debug.DISPLAY_OID) {
                graphics.setColor(ViewColor.debugLabel);
                graphics.setFont(TextStyle.getStyle(6).getFont());
                graphics.drawString(String.valueOf(objectViewer.getObject().getOid()), 5 + n + n4 + 6 + this.style.getMetrics().stringWidth(string), n5);
            }
            if (objectViewer.getDisplayState().isActive()) {
                graphics.setColor(Color.red);
                graphics.fillRect(0, 0, 10, 10);
            }
        }
    }

    public String title(NakedObject nakedObject) {
        return nakedObject.title().toString();
    }
}

