/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.StatusColor;
import org.nakedobjects.basicgui.view.TextStyle;
import org.nakedobjects.basicgui.view.ViewColor;
import org.nakedobjects.basicgui.view.ViewContent;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.utility.Debug;

public class NormalIconContent
extends ViewContent {
    private static final int imageLabelGap = 6;
    private boolean labelContextually = true;
    private TextStyle style;

    public NormalIconContent() {
        this(TextStyle.getStyle(1));
    }

    public NormalIconContent(TextStyle textStyle) {
        this.style = textStyle;
    }

    public NormalIconContent(TextStyle textStyle, boolean bl) {
        this.style = textStyle;
        this.labelContextually = bl;
    }

    public Dimension getMinimumSize(NakedObject nakedObject) {
        Image image = nakedObject.iconImage(32);
        FontMetrics fontMetrics = this.style.getMetrics();
        int n = 0;
        String string = this.labelContextually ? nakedObject.contextualTitle() : nakedObject.title().toString();
        n = string == null ? 0 : fontMetrics.stringWidth(string);
        int n2 = image == null ? 32 : image.getWidth(null);
        n2 = Math.max(n, n2);
        int n3 = image == null ? 32 : image.getHeight(null);
        n3 = n3 + 6 + fontMetrics.getHeight();
        return new Dimension(n2, n3);
    }

    public void paint(Graphics graphics, Rectangle rectangle, ObjectViewer objectViewer) {
        String string;
        NakedObject nakedObject = objectViewer.getObject();
        Color color = StatusColor.colorFor(objectViewer.getDisplayState(), ViewColor.textNormal);
        int n = rectangle.y;
        int n2 = rectangle.x + rectangle.width / 2;
        Image image = nakedObject.iconImage(32);
        if (image == null) {
            graphics.setColor(Color.red);
            graphics.drawOval(n2 - 16, n, 32, 32);
        } else {
            graphics.drawImage(image, n2 - image.getWidth(null) / 2, n, null);
        }
        if (Debug.GRAPHIC_BORDER) {
            graphics.drawOval(n2 - image.getWidth(null) / 2, n, image.getWidth(null), image.getHeight(null));
        }
        if ((string = this.labelContextually ? nakedObject.contextualTitle() : nakedObject.title().toString()) == null) {
            return;
        }
        graphics.setFont(this.style.getFont());
        graphics.setColor(color);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n += image == null ? 32 : image.getHeight(null);
        graphics.drawString(string, n2 - fontMetrics.stringWidth(string) / 2, n += 6 + fontMetrics.getAscent());
        if (Debug.GRAPHIC_BORDER) {
            graphics.drawRect(n2 - fontMetrics.stringWidth(string) / 2, n + fontMetrics.getAscent(), fontMetrics.stringWidth(string), fontMetrics.getHeight());
        }
        if (Debug.DISPLAY_OID) {
            graphics.setColor(ViewColor.debugLabel);
            graphics.setFont(TextStyle.getStyle(6).getFont());
            graphics.drawString(String.valueOf(objectViewer.getObject().getOid()), n2, n - 9);
        }
        if (objectViewer.getDisplayState().isActive()) {
            graphics.setColor(Color.red);
            graphics.fillRect(0, 0, 10, 10);
        }
    }
}

