/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import org.nakedobjects.basicgui.application.ClassList;
import org.nakedobjects.basicgui.application.CollectionViewHandler;
import org.nakedobjects.basicgui.application.NewCollectionInspectorOpt;
import org.nakedobjects.basicgui.application.NewObjectInspectorOption;
import org.nakedobjects.basicgui.application.ObjectViewHandler;
import org.nakedobjects.basicgui.event.popup.MenuOption;
import org.nakedobjects.basicgui.view.DisplayFrame;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.RealObjectViewer;
import org.nakedobjects.basicgui.view.StandardViewerFactory;
import org.nakedobjects.basicgui.view.TableLayout;
import org.nakedobjects.basicgui.view.View;
import org.nakedobjects.basicgui.view.ViewActionListener;
import org.nakedobjects.object.NakedClassList;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.reflect.Association;
import org.nakedobjects.object.reflect.OneToManyAssociation;

public class ApplicationViewerFactory
extends StandardViewerFactory {
    public static final MenuOption newObjectInspectorOption = new NewObjectInspectorOption();
    public static final MenuOption newCollectionInspectorOption = new NewCollectionInspectorOpt();
    public static final ViewActionListener objectViewHandler = new ObjectViewHandler();
    public static final ViewActionListener collectionViewHandler = new CollectionViewHandler();

    public void addCollectionOptions(ObjectViewer objectViewer) {
        objectViewer.addOption(newCollectionInspectorOption);
        objectViewer.addViewActionListener(collectionViewHandler);
    }

    public void addObjectOptions(ObjectViewer objectViewer) {
        objectViewer.addOption(newObjectInspectorOption);
        objectViewer.addViewActionListener(objectViewHandler);
    }

    public ObjectViewer createCollectionAttributeViewer(NakedObject nakedObject, OneToManyAssociation oneToManyAssociation) {
        ObjectViewer objectViewer = super.createCollectionAttributeViewer(nakedObject, oneToManyAssociation);
        this.addCollectionOptions(objectViewer);
        int n = ((NakedCollection)oneToManyAssociation.get(nakedObject)).size();
        if (n >= 0 && n < 6) {
            objectViewer.flipView();
        }
        return objectViewer;
    }

    public ObjectViewer createCollectionElementViewer(NakedObject nakedObject) {
        ObjectViewer objectViewer = super.createCollectionElementViewer(nakedObject);
        this.addCollectionOptions(objectViewer);
        return objectViewer;
    }

    public ObjectViewer createCollectionViewer(NakedObject nakedObject) {
        ObjectViewer objectViewer = super.createCollectionViewer(nakedObject);
        this.addCollectionOptions(objectViewer);
        return objectViewer;
    }

    public ObjectViewer createElementViewer(NakedObject nakedObject) {
        ObjectViewer objectViewer = super.createElementViewer(nakedObject);
        return objectViewer;
    }

    public ObjectViewer createInstanceElementViewer(NakedObject nakedObject) {
        ObjectViewer objectViewer = super.createInstanceElementViewer(nakedObject);
        this.addObjectOptions(objectViewer);
        return objectViewer;
    }

    public ObjectViewer createObjectAttributeViewer(NakedObject nakedObject, Association association) {
        ObjectViewer objectViewer = super.createObjectAttributeViewer(nakedObject, association);
        this.addObjectOptions(objectViewer);
        return objectViewer;
    }

    public ObjectViewer createObjectCellViewer(NakedObject nakedObject) {
        ObjectViewer objectViewer = super.createObjectCellViewer(nakedObject);
        if (nakedObject instanceof NakedCollection) {
            this.addCollectionOptions(objectViewer);
        } else {
            this.addObjectOptions(objectViewer);
        }
        return objectViewer;
    }

    public ObjectViewer createObjectElementViewer(NakedObject nakedObject) {
        ObjectViewer objectViewer = super.createObjectElementViewer(nakedObject);
        this.addObjectOptions(objectViewer);
        return objectViewer;
    }

    public ObjectViewer createObjectRowViewer(NakedObject nakedObject, TableLayout tableLayout) {
        ObjectViewer objectViewer = super.createObjectRowViewer(nakedObject, tableLayout);
        objectViewer.addOption(newObjectInspectorOption);
        objectViewer.addViewActionListener(objectViewHandler);
        return objectViewer;
    }

    public ObjectViewer createObjectViewer(NakedObject nakedObject) {
        ObjectViewer objectViewer = super.createObjectViewer(nakedObject);
        this.addObjectOptions(objectViewer);
        return objectViewer;
    }

    public DisplayFrame showClassWindow(NakedClassList nakedClassList, Point point) {
        DisplayFrame displayFrame = new DisplayFrame(new RealObjectViewer(nakedClassList, (View)new ClassList()));
        displayFrame.setTitle("Classes");
        ((Component)displayFrame).setLocation(point);
        displayFrame.setBorder(5);
        ((Component)displayFrame).setBackground(Color.blue.brighter());
        displayFrame.pack();
        displayFrame.show();
        return displayFrame;
    }
}

