program hash_bang_perl_2 ;

{ Version 2, 17/APRIL/1994.

  This program is intended to provide an MS-DOS substitute for the #!perl
  technique used for running perl scripts under UNIX.  Techniques that
  make perl scripts into batch files which run perl and pass themselves
  are unsatisfactory, as they can't be written cleanly under pure DOS
  (4DOS overcomes this problem) and don't handle i/o redirection cleanly.

  This program is intended to be renamed to the same name as a perl script,
  but retaining the .EXE extension.  When run, it searches out its own
  name, then looks for <own_name>.PL and an executable Perl interpreter.
  It then runs Perl as a child process, passing <own_name>.pl and its own
  command line as the perl command line.

  Written in Turbo Pascal to be awkward, and because this program
  will never be useful on an operating system other than MS-DOS.

  Version 2 incorporates suggestions and code by Niclas Borlin, of the
  Computer Science departmentt, University. of Umea, SWEDEN,
  (niclas@cs.umu.se). The changes he made were:

* The function do_search used to return 'C:\CURRENT\DIR\' if name
  couldn't be found. This produces errors in the main program, which
  appear to be expecting do_search to return '' on failure.
* An environment variable PERLSCRIPTS was added to the search pattern.
  Reason: Niclas finds %PERL% to be the dir where you keep your perl
  executables and %PERLLIB% to be the dir where you keep the .pl files
  shipped with perl (as well as other downloaded useful packages).
  I find neither of those to be the place to keep your 'executable'
  scripts, and instead of adding yet another dir to PATH (where I'm
  running out of chars :-( ), I think PERLSCRIPTS is an acceptable
  extension to the PERL* variables. It has the added benefit (compared
  to adding a dir to PATH) of speed; it gets searched first WHEN
  YOU'RE LOOKING FOR PERL SCRIPTS, and doesn't interfere with DOS
  normal path search.
* #!perl now accepts environment variables to be of unix style (e.g.
  C:/foo/bar).
* #!perl searches both for a script named 'FOO.' and 'FOO.PL'. This is
  because I write perl scripts that will run under BOTH unix and DOS,
  and would therefore like to be able to use the same file names on
  both systems (easier updating etc.).

}

{ Set up stack/heap limits, so that there is free memory to run Perl }

{$S+}   { Stack checking is worth the 32 bytes it adds }
{$V-}   { Relax type-checking of var string params }
{$M 4096, 0, 0 }

uses dos ;

type
 sptr = ^string ;
var
 { Variables have been cut down to reduce memory usage;
   they get recycled a bit }

 psp_string : sptr ;   { Pointer to command line string in PSP. }
 our_fname : NameStr ;  { Our filename, with no dir or extension. }

 search_dirs : string ;  { Places to search }
 scratch : string ;   { temporary string buffer }
 perl_name : PathStr ;  { Pathname of perl.exe }
 script_name : PathStr ;  { Pahtname of the script }

 scratch_file : text ;   { Utility file variable }

{ Simple error handler }

procedure die( m: string) ;
begin
 Writeln( '#!PERL.EXE: ', m ) ;
 Halt( 255) ;
end ;

{ Procedure to DOSify a string, i.e. change '/' to '\' and
  convert to uppercase.  Credited to Niclas Borlin.
}

procedure dosify( var s: string);
var i : word;
begin
 for i:=1 to length(s) do
  if (s[i]='/') then
   s[i]:='\'
  else
   s[i]:=UpCase(s[i]);
end;

{ Function to automate all the FExpand(FSearch())'s required
  Bugfix by Niclas Borlin }

function do_search( name, paths: string) : string ;
begin
 name:=FSearch(name,paths);
 if (name<>'') then
  name:= FExpand( name );
 do_search:=name;
end ;

{ procedure to tidy up a dirlist, i.e. remove ';;' and make sure dirlist
 ends with ';'. Credit to Niclas Borlin }

procedure tidy(var s : string);
var i : word;
begin
 { append ';' if necessary }
 if (length(s)>0) and (s[length(s)]<>';') then
  s:=s+';';

 { remove all occurences of ';;' }
 i:=Pos(';;',s);
 while (i>0) do begin
  delete(s,i,1);
  i:=Pos(';;',s);
 end
end;

{ Procedure to append list of dirs to list of dirs, keeping the resulting
 list as short as possible, i.e. removing duplicate dirs and ';;'.
 Uses global scratch. Credit to Niclas Borlin }

procedure append_dirs(var dirs : string; new_dirs : string);
var i : word;
begin
 tidy(dirs);
 tidy(new_dirs);

 { Find first dir in new_dirs. Remember, each dir is trailed by a ';' }
 i:=Pos(';',new_dirs);
 while (i>0) do begin
  { extract dir }
  scratch:=Copy(new_dirs,1,i);
  delete(new_dirs,1,i);

  { check if already in dirs, otherwise append it }
  if (Pos(scratch,dirs)=0) then begin
   if (length(dirs)+length(scratch)>255) then
    WriteLn('Warning: dir list exceed 255 chars');
   dirs:=dirs+scratch;
  end;

  { Find next dir }
  i:=Pos(';',new_dirs);
 end;

end;

{ Procedure to add an env var to a string. Does not use global scratch
  Enhancements credit to Niclas Borlin}

procedure add_env_var( var output: string; env_name: string) ;
begin
 { Re-use env_name in order to save space (and leave scratch untouched) }
 env_name:= GetEnv( env_name) ;
 if (env_name<> '') then begin
  dosify(env_name);
  append_dirs(output,env_name);
 end;
end;

{ function to return the character position of the first whitespace
  (or End of string) in a string }

function find_white( var s: string) : integer ;
var i : word ;
begin
 i := 1 ;
 While( (length(s) >= i) and
   (not( (s[i] = ' ') or (s[i] = #9 ) or (s[i] = #10) or (s[i] = #13))) ) do
  i := i + 1 ;
 find_white := i ;
end;

begin
 { Retrive this process's command line.  This will be passed directly
   to the script; we retrive it from the PSP, rather than using Turbo
   Pascal's ParamCount and ParamStr mechanisms, so that they don't
   destroy spaces in the command line.  As the string in the PSP *is*
   a Pascal string, we can reference it directly later on.
 }

 psp_string := Ptr( PrefixSeg, $80) ;

 { Get this process's current name. This is the name of the Perl
   script that it should run.  We use FExpand, as DOS doesn't
   povide a directory name if it didn't have to use the PATH to
   find this program.
 }

 scratch := FExpand( ParamStr(0)) ;

 if (scratch = '') then
  die( 'DOS 3 needed') ;

 { Build the list of places to search:
  1) Our own directory
  2) The directories in %PERLSCRIPTS%
  3) The directories in %PERLLIB%
  4) The directory in %PERL%
  5) The directories in %PATH%
 }

 FSplit( scratch, search_dirs, our_fname, scratch) ;

 { Remove the trailing '\' from search_dirs, as we aren't going to want it }

 Delete( search_dirs, integer(search_dirs[0]), 1) ;

 { Build the search pattern. If there are PERLSCRIPTS, PERLLIB and/or PERL
  environment variable, use them }

 add_env_var( search_dirs, 'PERLSCRIPTS') ; { Added by Niclas Borlin }
 add_env_var( search_dirs, 'PERLLIB') ;
 add_env_var( search_dirs, 'PERL') ;
 add_env_var( search_dirs, 'PATH') ;

 { OK, we have got started, now we need to do the work }

 { First, search for 'FOO.' only. Added by Niclas Borlin }
 script_name := do_search( our_fname, search_dirs) ;

 { If 'FOO.' was not found, look for 'FOO.PL'. Added by Niclas Borlin }
 if (script_name='') then
  script_name := do_search( (our_fname + '.PL'), search_dirs) ;

 if( script_name = '') then  { script not found: mod by Niclas Borlin }
  die( 'Can''t find ' + our_fname + '.PL' + ' or ' + our_fname) ;

 { The script exists! Let's look at its first line }

 Assign( scratch_file, script_name) ; { and we want to open it! }
 Reset( scratch_file) ;     { We know it exists }
 Read( scratch_file, scratch) ;   { This reads to first CR or buffer }
 Close( scratch_file) ;

 if( (scratch[1] = '#') and (scratch[2] = '!'))  { we have a #! line...}
 then
 begin
  { Delete the !# }

  Delete( scratch, 1, 2) ;

  { Break out the interpreter name }

  perl_name := copy( scratch, 1, find_white(scratch)-1) ;

  { delete up to the first '-' }

  While( (length(scratch) > 0) and (scratch[1] <> '-')) do
   Delete( scratch, 1, 1) ;

  { Kill anything after space, tab, or linefeed }

  { kill the tail, if any }

  Delete( scratch, find_white( scratch), 254) ;
 end
 else
 begin
   scratch := '' ;
   perl_name := '' ;
 end;

 if( perl_name <> '') then  { candidate interpreter }
 begin
{  Writeln( 'perl_name = ', perl_name) ;}
{  Writeln( 'Scratch = ', scratch ) ;}

  Exec( perl_name, (scratch + ' ' + script_name + ' ' + psp_string^));
  If (DosError = 0) then  { exec was successful }
   Halt( DosExitCode);
 end;

{ Writeln( 'Failed to exec ', perl_name ) ;}

 { Didn't get a workable interpreter out of the script, so... }
 { we need to find PERL.EXE.  It must be in our search pattern... }

 perl_name := do_search( 'PERL.EXE', search_dirs);

 If (perl_name = '') then
  die( 'Can''t locate PERL.EXE') ;

 { Finally, we can exec perl }

 Exec( perl_name, (scratch + ' ' + script_name + ' ' + psp_string^));

 if (DosError <> 0) then
 begin
  case DosError of
  { 2:  scratch := 'File not found' ;  we've found it already }
  8:  scratch := 'Out of memory' ;
  10:     scratch := 'Bad environment' ;
  11:     scratch := 'Bad format' ;
  else
   begin
    Str( DosError, scratch) ;
    Insert( 'DOS error code ', scratch, 1) ;
   end ;
  end;
  Insert( 'Error EXECing PERL: ', scratch, 0) ;
  die( scratch) ;
 end ;

 { all successful - pass Perl's exit code out }

Halt( DosExitCode) ;
end.

