{$G+,S-,R-,I-}
Unit XMM;

{
  Copyright (c) 1988, Microsoft Corporation

  Rewritten from EMS-XMM.ZIP.

  XMM version 1.00
  File XMM.PAS, Eugeni Bobrov 02-1993. BP7 & TP7.
  See XMM.ASM for description and documentation
  See EMS-XMM.ZIP for more documentation
}

Interface

Type
  { Extended Memory Move Structure Definition: }
  ExtMemMoveRec = Record
    Length       : LongInt;     { 32-bit number of bytes to transfer }
    SourceHandle : Word;        { Handle of source block }
    SourceOffset : LongInt;     { 32-bit offset into source }
    DestHandle   : Word;        { Handle of destination block }
    DestOffset   : LongInt;     { 32-bit offset into destination block }
  End;
  HandleInfo = Record
    Handle :      Word;
    Length :      Word;
    Filler :      Word;
    RealAddress : LongInt;
  End;


Var
  XMSHandle  : HandleInfo;

Function XMSError(Error : LongInt) : LongInt;
Function XMM_Installed : Boolean;
Function XMM_Version : LongInt;
Function XMM_RequestHMA(Space_Needed: Word) : LongInt;
Function XMM_ReleaseHMA : LongInt;
Function XMM_GlobalEnableA20 : LongInt;
Function XMM_GlobalDisableA20 : LongInt;
Function XMM_EnableA20 : LongInt;
Function XMM_DisableA20 : LongInt;
Function XMM_QueryA20 : LongInt;
Function XMM_QueryLargestFree : LongInt;
Function XMM_QueryTotalFree : LongInt;
Function XMM_AllocateExtended(SizeK : Word) : LongInt;
Function XMM_FreeExtended(Handle : Word) : LongInt;
Function XMM_LockExtended(Handle : Word) : LongInt;
Function XMM_UnLockExtended(Handle : Word) : LongInt;
Function XMM_MoveExtended(Var ExtMem) : LongInt;
Function XMM_GetHandleLength(Handle : Word) : LongInt;
Function XMM_GetHandleInfo(Handle : Word) : LongInt;
Function XMM_ReallocateExtended(Handle, NewSize : Word) : LongInt;
Function XMM_RequestUMB(UMBSize : Word) : LongInt;
Function XMM_ReleaseUMB(UMBSegment : Word) : LongInt;
Function MoveCon2Xmm(SourcePtr:Pointer; DestOfs:LongInt; Count:LongInt) : LongInt;
Function MoveXmm2Con(SourceOfs:LongInt; DestPtr:Pointer; Count:LongInt) : LongInt;

Implementation

Const
  ConvenMem = 0;

Var
  XmmRec : ExtMemMoveRec;

{$L XMM.OBJ}

Function XMSError(Error : LongInt) : LongInt;
  External;
Function XMM_Installed : Boolean;
  External;
Function XMM_Version : LongInt;
  External;
Function XMM_RequestHMA(Space_Needed: Word) : LongInt;
  External;
Function XMM_ReleaseHMA : LongInt;
  External;
Function XMM_GlobalEnableA20 : LongInt;
  External;
Function XMM_GlobalDisableA20 : LongInt;
  External;
Function XMM_EnableA20 : LongInt;
  External;
Function XMM_DisableA20 : LongInt;
  External;
Function XMM_QueryA20 : LongInt;
  External;
Function XMM_QueryLargestFree : LongInt;
  External;
Function XMM_QueryTotalFree : LongInt;
  External;
Function XMM_AllocateExtended(SizeK : Word) : LongInt;
  External;
Function XMM_FreeExtended(Handle : Word) : LongInt;
  External;
Function XMM_LockExtended(Handle : Word) : LongInt;
  External;
Function XMM_UnLockExtended(Handle : Word) : LongInt;
  External;
Function XMM_MoveExtended(Var ExtMem) : LongInt;
  External;
Function XMM_GetHandleLength(Handle : Word) : LongInt;
  External;
Function XMM_GetHandleInfo(Handle : Word) : LongInt;
  External;
Function XMM_ReallocateExtended(Handle, NewSize : Word) : LongInt;
  External;
Function XMM_RequestUMB(UMBSize : Word) : LongInt;
  External;
Function XMM_ReleaseUMB(UMBSegment : Word) : LongInt;
  External;


Function MoveCon2Xmm(SourcePtr:Pointer; DestOfs:LongInt; Count:LongInt): Longint;
Begin
  XmmRec.Length := Count;
  XmmRec.SourceHandle := ConvenMem;
  XmmRec.SourceOffset := LongInt( SourcePtr );
  XmmRec.DestHandle := XMSHandle.Handle;
  XmmRec.DestOffset := DestOfs;
  MoveCon2Xmm := XMM_MoveExtended( XmmRec );
End;

Function MoveXmm2Con(SourceOfs:LongInt; DestPtr:Pointer; Count:LongInt): Longint;
Begin
  XmmRec.Length := Count;
  XmmRec.SourceHandle := XMSHandle.Handle;
  XmmRec.SourceOffset := SourceOfs;
  XmmRec.DestHandle := ConvenMem;
  XmmRec.DestOffset := LongInt( DestPtr );
  MoveXmm2Con := XMM_MoveExtended( XmmRec );
End;

End.
