.MODEL  TPASCAL
; File XMM.ASM,   Low level interface to XMM.PAS
; Rewritten to Pascal calling convention by Eugeni Bobrov, 02-1993


	PUBLIC  XMSError
	PUBLIC  XMM_Installed, XMM_Version, XMM_RequestHMA
	PUBLIC  XMM_RequestHMA, XMM_ReleaseHMA, XMM_GlobalEnableA20
	PUBLIC  XMM_GlobalDisableA20, XMM_EnableA20, XMM_DisableA20
	PUBLIC  XMM_QueryA20, XMM_QueryLargestFree, XMM_QueryTotalFree
	PUBLIC  XMM_AllocateExtended, XMM_FreeExtended, XMM_LockExtended
	PUBLIC  XMM_UnLockExtended, XMM_MoveExtended, XMM_GetHandleLength
	PUBLIC  XMM_GetHandleInfo, XMM_ReallocateExtended, XMM_RequestUMB
	PUBLIC  XMM_ReleaseUMB

.CODE

XMM_Control     DD ?                            ; Pointer to HIMEM.SYS

SuccessFail     MACRO
		LOCAL   Success
		XOR     DX, DX
		DEC     AX
		JZ      Success
		MOV     DH, BL
Success:
ENDM

; Macro to convert from XMS return value in AX
; a form more acceptable for C.  IE.
;
; AX != 0 becomes DX:AX = AX
; AX == 0 becomes DX:AX = BL << 24 | AX
;
; Since Error Codes returned in BL have the top bit
; set, C will interpret the return as negative.
; XMS returns of this type return BL == 0 on success.
;
SuccessFailAX   MACRO
		LOCAL   Success
		XOR     DX, DX
		OR      AX, AX
		JNZ     Success
		MOV     DH, BL
Success:
ENDM

;
; Macro to convert from XMS return value in DX
; a form more acceptable for C.  IE.
;
; AX != 0 becomes DX:AX = DX
; AX == 0 becomes DX:AX = BL << 24 | DX
;
; Since Error Codes returned in BL have the top bit
; set, C will interpret the return as negative.
; XMS returns of this type return BL == 0 on success.
;
SuccessFailDX   MACRO
		LOCAL   Success
		OR      AX, AX
		MOV     AX, DX
		MOV     DX, 0                           ; Preserves Flags
		JNZ     Success
		MOV     DH, BL
Success:
ENDM

XMSError        PROC    FAR Error : DWORD
		LES     AX, Error 
		MOV     DX, ES
		XCHG    DH, DL                          ; ROR DX:AX, 18h
		XCHG    DL, AH
		XCHG    AH, AL
		CBW
		CWD
		RET
XMSError        ENDP

XMM_Installed   PROC    FAR
		LES     AX, XMM_Control
		MOV     BX, ES
		OR      BX, AX
		JNZ     Already_Initialised
		MOV     AX, 4300h                       ; Test for XMM
		INT     2Fh
		CMP     AL, 80h
		JNE     NoDriver

		MOV     AX, 4310h                       ; Get Control Function
		INT     2Fh
		MOV     WORD PTR XMM_Control, BX
		MOV     WORD PTR XMM_Control+2, ES

Already_Initialised:
		MOV     AX, 1
		JMP     SHORT Exit

NoDriver:       MOV     AX, 0

Exit:           RET
XMM_Installed   ENDP

; Get XMS Version Number (Function 00h):
;    ARGS:   AH = 00h
;    RETS:   AX = XMS version number
;            BX = Driver internal revision number
;            DX = 0001h if the HMA exists, 0000h otherwise
;    ERRS:   None

; Function XMM_Installed : Boolean;
XMM_Version     PROC    FAR
		XOR     AH, AH                          ; Function 0
		CALL    [XMM_Control]
		MOV     DX, BX                          ; Return a long
		RET
XMM_Version     ENDP

; Request High Memory Area (Function 01h):

;    ARGS:  AH = 01h
;           If the caller is a TSR or device driver,
;                DX = Space needed in the HMA by the caller in bytes
;           If the caller is an application program,
;                DX = FFFFh
;    RETS:  AX = 0001h if the HMA is assigned to the caller, 0000h otherwise
;    ERRS:  BL = 80h if the function is not implemented
;           BL = 81h if a VDISK device is detected
;           BL = 90h if the HMA does not exist
;           BL = 91h if the HMA is already in use
;           BL = 92h if DX is less than the /HMAMIN= parameter

; Function XMM_RequestHMA(Space_Needed: Word) : LongInt;
XMM_RequestHMA  PROC    FAR Space_Needed : WORD
		MOV     AH, 1
		MOV     DX, Space_Needed
		CALL    [XMM_Control]
		SuccessFail
		RET
XMM_RequestHMA  ENDP


; Release High Memory Area (Function 02h):

;   ARGS:   AH = 02h
;   RETS:   AX = 0001h if the HMA is successfully released, 0000h otherwise
;   ERRS:   BL = 80h if the function is not implemented
;           BL = 81h if a VDISK device is detected
;           BL = 90h if the HMA does not exist
;           BL = 93h if the HMA was not allocated

; Function XMM_ReleaseHMA : LongInt;
XMM_ReleaseHMA  PROC    FAR Space_Needed : WORD
		MOV     AH, 2
		CALL    [XMM_Control]
		SuccessFail
		RET
XMM_ReleaseHMA  ENDP


;Global Enable A20 (Function 03h):

;    ARGS:  AH = 03h
;    RETS:  AX = 0001h if the A20 line is enabled, 0000h otherwise
;    ERRS:  BL = 80h if the function is not implemented
;           BL = 81h if a VDISK device is detected
;           BL = 82h if an A20 error occurs
; Function XMM_GlobalEnableA20 : LongInt;
XMM_GlobalEnableA20 PROC FAR                            ; Global Enable A20
		MOV     AH, 3
		CALL    [XMM_Control]
		SuccessFail
		RET
XMM_GlobalEnableA20 ENDP


;Global Disable A20 (Function 04h):

;    ARGS:  AH = 04h
;    RETS:  AX = 0001h if the A20 line is disabled, 0000h otherwise
;    ERRS:  BL = 80h if the function is not implemented
;           BL = 81h if a VDISK device is detected
;           BL = 82h if an A20 error occurs
;           BL = 94h if the A20 line is still enabled

; Function XMM_GlobalDisableA20 : LongInt;
XMM_GlobalDisableA20 PROC FAR                           ; Global Disable A20
		MOV     AH, 4
		CALL    [XMM_Control]
		SuccessFail
		RET
XMM_GlobalDisableA20 ENDP


;Local Enable A20 (Function 05h):
;    ARGS:  AH = 05h
;    RETS:  AX = 0001h if the A20 line is enabled, 0000h otherwise
;    ERRS:  BL = 80h if the function is not implemented
;           BL = 81h if a VDISK device is detected
;           BL = 82h if an A20 error occurs

; Function XMM_EnableA20 : LongInt;
XMM_EnableA20   PROC    FAR                             ; Local Enable A20
		MOV     AH, 5
		CALL    [XMM_Control]
		SuccessFail
		RET
XMM_EnableA20   ENDP


;Local Disable A20 (Function 06h):
;
;    ARGS:  AH = 06h
;    RETS:  AX = 0001h if the function succeeds, 0000h otherwise
;    ERRS:  BL = 80h if the function is not implemented
;           BL = 81h if a VDISK device is detected
;           BL = 82h if an A20 error occurs
;           BL = 94h if the A20 line is still enabled
; Function XMM_DisableA20 : LongInt;
XMM_DisableA20  PROC    FAR                             ; Local Disable A20
		MOV     AH, 6
		CALL    [XMM_Control]
		SuccessFail
		RET
XMM_DisableA20  ENDP


;Query A20 (Function 07h):
;
;    ARGS:  AH = 07h
;    RETS:  AX = 0001h if the A20 line is physically enabled, 0000h otherwise
;    ERRS:  BL = 00h if the function succeeds
;           BL = 80h if the function is not implemented
;           BL = 81h if a VDISK device is detected
; Function XMM_QueryA20 : LongInt;
XMM_QueryA20    PROC    FAR
		MOV     AH, 7
		CALL    [XMM_Control]
		SuccessFailAX
		RET
XMM_QueryA20    ENDP



;Query Free Extended Memory (Function 08h):
;
;    ARGS:  AH = 08h
;    RETS:  AX = Size of the largest free extended memory block in K-bytes
;           DX = Total amount of free extended memory in K-bytes
;    ERRS:  BL = 80h if the function is not implemented
;           BL = 81h if a VDISK device is detected
;           BL = A0h if all extended memory is allocated

;Function XMM_QueryLargestFree : LongInt;
XMM_QueryLargestFree PROC FAR
		MOV     AH, 8
		CALL    [XMM_Control]
		SuccessFailAX
		RET
XMM_QueryLargestFree ENDP

XMM_QueryTotalFree PROC FAR
		MOV     AH, 8
		CALL    [XMM_Control]
		SuccessFailDX
		RET
XMM_QueryTotalFree ENDP

; Allocate Extended Memory Block (Function 09h):

;    ARGS:  AH = 09h
;           DX = Amount of extended memory being requested in K-bytes
;    RETS:  AX = 0001h if the block is allocated, 0000h otherwise
;           DX = 16-bit handle to the allocated block
;    ERRS:  BL = 80h if the function is not implemented
;           BL = 81h if a VDISK device is detected
;           BL = A0h if all available extended memory is allocated
;           BL = A1h if all available extended memory handles are in use

; Function XMM_AllocateExtended(SizeK : Word) : LongInt;
XMM_AllocateExtended PROC FAR SizeK : WORD
		MOV     AH, 9
		MOV     DX, SizeK
		CALL    [XMM_Control]
		SuccessFailDX
		RET
XMM_AllocateExtended ENDP

;Free Extended Memory Block (Function 0Ah):

;    ARGS:  AH = 0Ah
;           DX = Handle to the allocated block which should be freed
;    RETS:  AX = 0001h if the block is successfully freed, 0000h otherwise
;    ERRS:  BL = 80h if the function is not implemented
;           BL = 81h if a VDISK device is detected
;           BL = A2h if the handle is invalid
;           BL = ABh if the handle is locked

; Function XMM_FreeExtended(Handle : Word) : LongInt;
XMM_FreeExtended PROC FAR Handle : WORD
		MOV     AH, 0Ah
		MOV     DX, Handle
		CALL    [XMM_Control]
		SuccessFail
		RET
XMM_FreeExtended ENDP

; Move Extended Memory Block (Function 0Bh):

;    ARGS:  AH = 0Bh
;           DS:SI = Pointer to an Extended Memory Move Structure (see below)
;    RETS:  AX = 0001h if the move is successful, 0000h otherwise
;    ERRS:  BL = 80h if the function is not implemented
;           BL = 81h if a VDISK device is detected
;           BL = 82h if an A20 error occurs
;           BL = A3h if the SourceHandle is invalid
;           BL = A4h if the SourceOffset is invalid
;           BL = A5h if the DestHandle is invalid
;           BL = A6h if the DestOffset is invalid
;           BL = A7h if the Length is invalid
;           BL = A8h if the move has an invalid overlap
;           BL = A9h if a parity error occurs

; Function XMM_MoveExtended(Var ExtMem) : LongInt;
XMM_MoveExtended PROC FAR pInfo : DWORD
		PUSH    DS
		MOV     AH, 0Bh
		LDS     SI, pInfo                       ; DS:SI => Description
		CALL    [XMM_Control]
		SuccessFail
		POP     DS
		RET
XMM_MoveExtended ENDP


; Lock Extended Memory Block (Function 0Ch):

;    ARGS:  AH = 0Ch
;           DX = Extended memory block handle to lock
;    RETS:  AX = 0001h if the block is locked, 0000h otherwise
;           DX:BX = 32-bit linear address of the locked block
;    ERRS:  BL = 80h if the function is not implemented
;           BL = 81h if a VDISK device is detected
;           BL = A2h if the handle is invalid
;           BL = ACh if the block's lock count overflows
;           BL = ADh if the lock fails

; Function XMM_LockExtended(Handle : Word) : LongInt;
XMM_LockExtended PROC FAR Handle : WORD
		MOV     AH, 0Ch
		MOV     DX, Handle
		CALL    [XMM_Control]
		XCHG    AX, BX
		DEC     BX
		JZ      XMML_Success
		MOV     DH, AL
XMML_Success:
		RET
XMM_LockExtended ENDP


; Unlock Extended Memory Block (Function 0Dh):

;    ARGS:  AH = 0Dh
;           DX = Extended memory block handle to unlock
;    RETS:  AX = 0001h if the block is unlocked, 0000h otherwise
;    ERRS:  BL = 80h if the function is not implemented
;           BL = 81h if a VDISK device is detected
;           BL = A2h if the handle is invalid
;           BL = AAh if the block is not locked

; Function XMM_UnLockExtended(Handle : Word) : LongInt;
XMM_UnLockExtended PROC FAR Handle : WORD
		MOV     AH, 0Dh
		MOV     DX, Handle
		CALL    [XMM_Control]
		SuccessFail
		RET
XMM_UnLockExtended ENDP

;Get EMB Handle Information (Function 0Eh):

;    ARGS:  AH = 0Eh
;           DX = Extended memory block handle
;    RETS:  AX = 0001h if the block's information is found, 0000h otherwise
;           BH = The block's lock count
;           BL = Number of free EMB handles in the system
;           DX = The block's length in K-bytes
;    ERRS:  BL = 80h if the function is not implemented
;           BL = 81h if a VDISK device is detected
;           BL = A2h if the handle is invalid

; Function XMM_GetHandleLength(Handle : Word) : LongInt;
XMM_GetHandleLength PROC FAR Handle : WORD
		MOV     AH, 0Eh
		MOV     DX, Handle
		CALL    [XMM_Control]
		SuccessFailDX
		RET
XMM_GetHandleLength ENDP

; Function XMM_GetHandleInfo(Handle : Word) : LongInt;
XMM_GetHandleInfo PROC FAR Handle : WORD
		MOV     AH, 0Eh
		MOV     DX, Handle
		CALL    [XMM_Control]
		SuccessFailDX
                JZ      RGHI
		MOV     DX, BX
RGHI:		RET
XMM_GetHandleInfo ENDP
; Reallocate Extended Memory Block (Function 0Fh):

;    ARGS:  AH = 0Fh
;           BX = New size for the extended memory block in K-bytes
;           DX = Unlocked extended memory block handle to reallocate
;    RETS:  AX = 0001h if the block is reallocated, 0000h otherwise
;    ERRS:  BL = 80h if the function is not implemented
;           BL = 81h if a VDISK device is detected
;           BL = A0h if all available extended memory is allocated
;           BL = A1h if all available extended memory handles are in use
;           BL = A2h if the handle is invalid
;           BL = ABh if the block is locked

; Function XMM_ReallocateExtended(Handle, NewSize : Word) : LongInt;
XMM_ReallocateExtended PROC FAR Handle : WORD,  NewSize : WORD
		MOV     AH, 0Fh
		MOV     DX, Handle
		MOV     BX, NewSize
		CALL    [XMM_Control]
		SuccessFail
		RET
XMM_ReallocateExtended ENDP
; Request Upper Memory Block (Function 10h):

;    ARGS:  AH = 10h
;           DX = Size of requested memory block in paragraphs
;    RETS:  AX = 0001h if the request is granted, 0000h otherwise
;           BX = Segment number of the upper memory block
;           If the request is granted,
;               DX = Actual size of the allocated block in paragraphs
;           otherwise,
;               DX = Size of the largest available UMB in paragraphs
;    ERRS:  BL = 80h if the function is not implemented
;           BL = B0h if a smaller UMB is available
;           BL = B1h if no UMBs are available

; Function XMM_RequestUMB(UMBSize : Word) : LongInt;
XMM_RequestUMB PROC FAR UMBSize : WORD
		MOV     AH, 10h
		MOV     DX, UMBSize
		CALL    [XMM_Control]
		XCHG    BX, AX                  ; Segment in AX, Size in DX
		DEC     BX
		JZ      RUMB_Success
		XCHG    AX, DX                  ; Largest available size in AX
		MOV     DH, DL                  ; Error code now in DH
RUMB_Success:   RET
XMM_RequestUMB  ENDP

;Release Upper Memory Block (Function 11h):
;
;    ARGS:  AH = 11h
;           DX = Segment number of the upper memory block
;    RETS:  AX = 0001h if the block was released, 0000h otherwise
;    ERRS:  BL = 80h if the function is not implemented
;           BL = B2h if the UMB segment number is invalid

; Function XMM_ReleaseUMB(UMBSegment : Word) : LongInt;
XMM_ReleaseUMB  PROC FAR UMBSegment : WORD
		MOV     AH, 11h
		MOV     DX, UMBSegment
		CALL    [XMM_Control]
		SuccessFail
XMM_ReleaseUMB  ENDP

END
