{$G+,S-,R-,I-}
Unit Mou;
{$DEFINE HARDWCURSOR}
{-$DEFINE NOTEGAVGA}
{-$DEFINE TEST}
{
 *****************************************************************************
 * PROJECT:  Mouse routines with 'real' graphic cursor in text mode.
 *****************************************************************************
 * MODULE:  MOU.PAS
 *****************************************************************************
 * DESCRIPTION:
 *   Main file for the Mouse routines.
 *
 *****************************************************************************
 * MODifICATION NOTES:
 *    Date     Author Comment
 * 26-Oct-1990   dk   Initial file.
 * 07-Jan-1991   dk   Fixed bugs and set up for release to Usenet.
 * 13-oct-1993   eb/hs Ported to Turbo Pascal 6.0
 * 08-Mar-1994   eb   addet routines for saving egavga fonts
 *****************************************************************************
 *
 * DISCLAIMER:
 *
 * Programmers may incorporate any or all code into their programs,
 * giving proper credit within the source. Publication of the
 * source routines is permitted so long as proper credit is given
 * to Dave Kirsch.
 *
 * Copyright (C) 1990, 1991 by Dave Kirsch.  You may use this program, or
 * code or tables extracted from it, as desired without restriction.
 * I can not and will not be held responsible for any damage caused from
 * the use of this software.
 *
 *****************************************************************************
 * This source works with Turbo Pascal 6.0 and above.
 ****************************************************************************
}

Interface

Uses xCrt;

Type
  Minforectype = Record		{ Mouse information record }
    buttonstat : Word;
    cx, cy     : Integer;
    shiftstate : Byte;
  End;
  TMouInfoRec  = MInfoRecType;

Const
  MouseInstalled : Boolean = False;  { Is the Mouse installed? }
  { Bit defines for Mouse driver function 12 -- define handler. }
  MouseMove     = 1;
  LeftBPress    = 2;
  LeftBRelease  = 4;
  RightBPress   = 8;
  RightBRelease =16;

  LEFTBDOWN  = 1;
  RIGHTBDOWN = 2;


Var
  Mousex, Mousey : Word;                { Character position of Mouse }
  Mousepx, Mousepy : Word ;              { Mouse pixel coordinates }

{ Initialize the Mouse routines -- must be called. }
Procedure MouseInit;

{ Deinitialize the Mouse routines -- must be called on shutdown.
   Failure to call it will most likely result in a system crash If the Mouse
   is moved. }
Procedure MouseDeinit;

{ Hide the Mouse cursor }
Procedure MouseHide;

{ Hide the Mouse cursor If it moves or is in a specific rectangular region
  of the screen. }
Procedure MouseConditionalhide(x1, y1, x2, y2:Integer);

{ Show the Mouse cursor }
Procedure MouseShow;

{ return True If there are events waiting in the buffer. }
Function MouseCheck : Boolean;

{ look at the next event in the buffer, but don't pull it out. }
Procedure Mousepreview(Var MouInfoRec :TMouInfoRec);

{ get and remove next event from the buffer. }
Procedure Mouseget(Var MouInfoRec : TMouInfoRec);

{ return the current status of the Mouse buttons (see defines above). }
Function Mousebuttonstatus : Word;

Implementation

Type
  PZeroByte = ^ZeroByte;
  ZeroByte = Array[0..0] Of Byte;
Const
  DefChar : Array[0..8] Of Char = (
    #$D0, #$D1, #$D2, #$D3, #$D4,
    #$D5, #$D6, #$D7, #$D8);
  Height = 16;
  MouseBufferSize = 16;              { Size of Mouse "click" ahead buffer. }
  Mousehidden : Boolean = False;            { Is the Mouse on? Additive flag }
  conditionalhideMouse : boolean = False;
  MouseCursorMask : Array[0..Pred(Height)] Of LongInt = (
    $00000000,  { 0000000000000000 }
    $40000000,  { 0100000000000000 }
    $60000000,  { 0110000000000000 }
    $70000000,  { 0111000000000000 }
    $78000000,  { 0111100000000000 }
    $7c000000,  { 0111110000000000 }
    $7e000000,  { 0111111000000000 }
    $7f000000,  { 0111111100000000 }
    $7f800000,  { 0111111110000000 }
    $7f000000,  { 0111111100000000 }
    $7c000000,  { 0111110000000000 }
    $46000000,  { 0100011000000000 }
    $06000000,  { 0000011000000000 }
    $03000000,  { 0000001100000000 }
    $03000000,  { 0000001100000000 }
    $00000000); { 0000000000000000 }
  MouseScreenMask : Array[0..Pred(Height)] Of LongInt = (
    $3fffffff,  { 0011111111111111 }
    $1fffffff,  { 0001111111111111 }
    $0fffffff,  { 0000111111111111 }
    $07ffffff,  { 0000011111111111 }
    $03ffffff,  { 0000001111111111 }
    $01ffffff,  { 0000000111111111 }
    $00ffffff,  { 0000000011111111 }
    $007fffff,  { 0000000001111111 }
    $003fffff,  { 0000000000111111 }
    $007fffff,  { 0000000001111111 }
    $01ffffff,  { 0000000111111111 }
    $10ffffff,  { 0001000011111111 }
    $b0ffffff,  { 1011000011111111 }
    $f87fffff,  { 1111100001111111 }
    $f87fffff,  { 1111100001111111 }
    $fcffffff); { 1111110011111111 }

                                        { Save information for EGA/VGA displays }
  SaveChars : Array[0..2, 0..2] Of Char = ((#0,#0,#0),(#0,#0,#0),(#0,#0,#0));
                                        { The saved characters we overwrote }
  EgaVga : Boolean  = False;            { Do we have an EGA/VGA adapter? }

                                        { Save information for non EGA/VGA }
  oldword : Word = 0;
  newword : Word = 0;
  saved   : Boolean = False;

  oldmx	  : Word = 0;
  oldmy	  : Word = 0;
  mbufin  : Byte = 0;                   { Mouse buffer pointers }
  mbufout : Byte = 0;
  Mousefreeze : Word = 0;               { Is Mouse frozen in place? }
  desqview  : Boolean = False;
  MSWindowsEnh : Boolean = False;
  ScreenSizeTable : Array[0..9] Of Word =
    (40*(25-1),  80*(25-1),  80*(43-1),  80*(50-1),  80*(60-1),
    100*(40-1), 132*(44-1) ,132*(25-1), 132*(28-1), 132*(60-1));
  FontTypeTable   : Array[0..9] Of Byte = (6,6,3,3,3,6,3,6,6,3);
  MouseForegroundColor : Byte = Brown Shl 4;

Var
  mbuf   : Array[0..Pred(MouseBufferSize)] Of MInfoRecType;  { Mouse buffer }
  vseg   : Word;                        { Segment of video ram. }
  Rows   : Byte Absolute $0040:$0084;
  Points : Byte Absolute $0040:$0085; { word }
  Cols   : Byte Absolute $0040:$004A;
  mcols, mrows :  Byte;
  mpoints : Word;
  savevmode : Byte;
  maxx, maxy : Integer;
  conx1, cony1, conx2, cony2 : Word;
  chardefs : Array[0..32*9-1] Of Byte;     { 9 character definitons. }
  FontType : Byte;
  FontPtr : Pointer;
  ScanLines, Rows1 : Word;
  OldExitProc : Pointer;

{*******************************************************************}
{  08-Mar-1994 - EB                                                 }
{                                                                   }
{  Saves current EgaVga font                                        }
{                                                                   }
{*******************************************************************}
Procedure SaveFont;
Var
  i : Byte;
Begin;
  i := 0;
  While ScreenSizeTable[i] <> MCols*(MRows-1) Do Inc(i);
  FontType := FontTypeTable[i];
  Asm
    PUSH BP
    MOV AX, 1130h
    MOV BH, FontType
    INT 10h
    MOV Word Ptr FontPtr+2, ES
    MOV Word Ptr FontPtr, BP
    MOV ScanLines, CX
    MOV DH, 0
    MOV Rows1, DX
    POP BP
  End;
  If ScanLines < 10 Then
    ScanLines := 8
  Else
    ScanLines := 16;
End;

{*******************************************************************}
{  08-Mar-1994 - EB                                                 }
{                                                                   }
{  Restore current EgaVga font                                      }
{                                                                   }
{*******************************************************************}
Procedure RestoreFont; Assembler; { #EB }
Asm
  PUSH BP
  MOV  ES, Word Ptr FontPtr+2
  MOV  BP, Word Ptr FontPtr
  MOV  BX, ScanLines
  XCHG BH, BL
  MOV  DL, 0h
  MOV  BL, 0
  MOV  CX, 256
  MOV  AX, 1100h
  INT  10h
  POP  BP
End;


Procedure PokeAttrib(x, y, a:Word);
Begin
  Mem[vseg: y*mcols*2 + ((x) Shl 1) + 1] := a;
End;

Function PEEKATTRIB(x, y: Word) : Word;
Begin
  PeekAttrib := Mem[vseg: y*mcols*2 + ((x) Shl 1) + 1];
End;

{*******************************************************************}
{ Mon 07-Jan-1991 - dk                                              }
{                                                                   }
{  Plot the cursor on the screen, save background, draw grid, etc.  }
{                                                                   }
{*******************************************************************}
Procedure PlotEgaVgaCursor(Func:Integer);
Const
  lsavex : Integer = 0;
  lsavey : Integer = 0;
  savedcur : Boolean = False;
Var
  off, width, lheight, i, j, disp, x, y :Word;

Begin
  Case Func Of
    0 : Begin  { erase grid, put back save info }
{$IFDEF TEST}
          If Not savedcur Then
            WriteLn('Request to erase the cursor that wasn''t saved!!');
{$ENDIF}
          savedcur := False;
          x := lsavex;
          y := lsavey;
        End;
    1 : Begin { draw grid }
          x := Mousex;
          y := Mousey;
{$IFDEF TEST}
          If (x <> lsavex) Or (y <> lsavey) Then
            WriteLn('Request to draw cursor where we didn''t save it!!!');
{$ENDIF}
        End;
    2 : Begin { save grid }
{$IFDEF TEST}
          If savedcur Then
            WriteLn('Request to save grid when is wasn''t erased!!');
          savedcur := True;
{$ENDIF}
          x := Mousex;
          lsavex := x;
          y := Mousey;
          lsavey := y;
        End;
  End;
  width := mcols - x;
  If (width > 3) Then
    width := 3;
  lheight := mrows - y;
  If (lheight > 3) Then
    lheight := 3;
  off := y * (mcols * 2) + x * 2;
  disp := (mcols * 2) - width * 2;
  Case func Of
    0 : Asm { erase grid, put back save info }
          CLD
          MOV AX, Vseg
          MOV ES, AX
          MOV DI, off
          MOV CX, 0                      {For i := 0 To Pred(Height) Do Begin }
          MOV SI, Offset SaveChars
        @For_i:
          MOV DX, 0                      {For j := 0 To Pred(width) Do Begin }
        @For_j:
          LODSB                          {Mem[vseg:off] := SaveChars[i][j];}
          STOSB
          INC DI
          INC DX
          CMP DX, Width
          JB  @For_j
          ADD DI, disp                   { Inc(off, disp); }
          INC CX
          CMP CX, lHeight
          JB  @For_i
        End;
    1 : Asm        { draw grid. }
          CLD
          MOV AX, Vseg
          MOV ES, AX
          MOV DI, off
          MOV CX, 0                      {For i := 0 To Pred(Height) Do Begin }
          MOV SI, Offset DefChar
        @For_i:
          MOV DX, 0                      {For j := 0 To Pred(width) Do Begin }
        @For_j:
          LODSB                          {Mem[vseg:off] := DefChar[i*3]+j;}
          STOSB
          INC DI
          INC DX
          CMP DX, Width
          JB  @For_j
          ADD DI, disp                   { Inc(off, disp); }
          INC CX
          CMP CX, lHeight
          JB  @For_i
        End;
    2 : Asm { save grid. }
          CLD
          PUSH DS
          MOV AX, Vseg
          MOV DS, AX
          POP ES
          PUSH ES
          MOV DI, Offset SaveChars
          MOV CX, 0                      {For i := 0 To Pred(Height) Do Begin }
          MOV SI, off
        @For_i:
          MOV DX, 0                      {For j := 0 To Pred(width) Do Begin }
        @For_j:
          LODSB                          {savechars[i][j] := Mem[vseg : off];}
          STOSB
          INC SI
          INC DX
          CMP DX, Width
          JB  @For_j
          ADD SI, disp                   { Inc(off, disp); }
          INC CX
          CMP CX, lHeight
          JB  @For_i
          POP DS
        End;
  End;
End;


Procedure DrawEgaVgaCursor;
Type
  OneDimArray = Array[0..8] Of Byte;
  ZeroLong = Array[0..0] Of LongInt;
  PZeroLong = ^ZeroLong;
Var
  i : Byte;
  defs, masks : PZeroLong;
  Shift : Word;
  addMask : LongInt;
Begin
  plotEgaVgacursor(2);               { Save current grid that is there. }
  { Time for some assembler.  Program the EGA/VGA Sequencer and Graphics
     Controller for direct access to the character definition tables.
     Then read in the definitions for the characters we are changing, AND
     the screen mask, then OR the cursor mask to them.  Then copy those
     defintions into the location of the Mouse cursor defintions
     and set the Sequencer and Graphics Controller back to normal <whew!>.
  }
  { Program the Sequencer }
  asm
    pushf;
    cli;                             { Disable interrupts }
    mov dx, 3c4h;                    { Sequencer port address }
    mov ax, 0704h;                   { Sequential addressing }
    out dx, ax;
                                     { Program the Graphics Controller }
    mov dx, 3ceh;                    { Graphics Controller port address }
    mov ax, 0204h;                   { Select map 2 for CPU reads }
    out dx, ax;
    mov ax, 0005h;                   { Disable odd-even addressing }
    out dx, ax;
    mov ax, 0406h;                   { Map starts at A000:0000 (64K mode) }
    out dx, ax;
    popf;
  End;
  { Ok, now we have direct access to the character defintion tables, copy
     over the defintions for the characters we are changing }
  Asm
    CLD
    MOV  CX, 0                      { i }
    MOV  SI, OFFSET SaveChars       { DS:SI Ptr to SaveChars }
    MOV  DI, OFFSET CharDefs        { ES:DI Ptr to CharDefs }
@For_i:                             { For i := 0 To 9 step 3 Do Begin }
    PUSH CX
    MOV  CL, 5
    LODSB
    MOV  AH, 0
    SHL  AX, CL                     {   s1 := OneDimArray(savechars)[SI] * 32 }
    MOV  BX, AX
    LODSB
    MOV  AH, 0
    SHL  AX, CL                     {   s2 := OneDimArray(savechars)[SI] * 32 }
    MOV  DX, AX
    LODSB
    MOV  AH, 0
    SHL  AX, CL                     {   s3 := OneDimArray(savechars)[SI] * 32 }
    MOV  CX, mpoints
    PUSH DS
    POP  ES
    PUSH DS
    PUSH SI
    MOV  SI, 0A000h
    MOV  DS, SI
@For_j:                             {   For j := lPoints DownTo 0 Do Begin }
    INC  DI                         {   off }
    MOV  SI, AX
    LODSB                           {     CharDefs[DI] := Mem[$A000: s3]; }
    STOSB
    XCHG DX, SI                     {   s3+1 -> DX  s2 -> SI }
    LODSB                           {     CharDefs[off] := Mem[$A000: s2]; }
    STOSB
    XCHG BX, SI                     {   s2+1 -> BX  s1 -> SI }
    LODSB                           {     CharDefs[off] := Mem[$A000: s1]; }
    STOSB
    XCHG AX, SI                     {   s1+1 -> AX }
    XCHG AX, DX                     {   s3   -> AX  s1 -> DX }
    XCHG BX, DX                     {   s1   -> BX  s2 -> DX }
    LOOP @For_j                     {   End; }
    POP  SI
    POP  DS
    POP  CX
    ADD  CX, 3
    CMP  CX, 9
    JB   @For_i                     { End; }
  End;

  { Ok, we've got the defintions for the characters that we are drawing the
     cursor on.  AND the screen mask and OR the cursor mask to them, thereby
     'drawing' the cursor.  Since the cursor is 16 pixels wide and 16 pixels
     high, we have to save a 3 by 3 character grid where the Mouse cursor is
     going.  We use dwords (32 bits) to do the bit AND and OR.  This could
     be made alot faster on a 386 by using 32 bit registers. }

  shift := Mousepx Mod 8;
  addmask := $ff000000 Shl (8 - shift);
  masks := @MouseScreenMask;
  defs := @chardefs; Inc(LongInt(defs), (Mousepy Mod mpoints)*SizeOf(defs^[0]));
  For i := 0 To Pred(height) Do
    defs^[i] := defs^[i] And ((masks^[i] Shr shift) Or addmask);
  masks := @MouseCursorMask;
  defs := @chardefs; Inc(LongInt(defs), (Mousepy Mod mpoints)*SizeOf(defs^[0]));
  For i := 0 To Pred(Height) Do
    defs^[i] := defs^[i] Or (masks^[i] Shr shift);

  { Ok, Everything is setup, now copy the modifed character definitions
     to their new location. }

  Asm
    mov dx, 3c4h; { Sequencer port address }
    mov ax, 0402h; { CPU writes only to map 2 }
    out dx, ax;
  End;

  Asm
    CLD
    MOV  CX, 0              { i }
    MOV  SI, OFFSET CharDefs{ DS:SI Ptr to CharDefs  (SI = off ) }
    MOV  DI, 0A000h
    MOV  ES, DI
@For_i:                     { For i := 0 To 9 Step 3 Do Begin  ( Grid is three characters high. ) }
    PUSH CX
    PUSH SI
    MOV  SI, OFFSET DefChar
    ADD  SI, CX
    MOV  CL, 5
    MOV  AH, 0
    LODSB
    SHL  AX, CL             {   s1 (BX) := (Byte(DefChar) + DI    ) * 32 }
    MOV  BX, AX
    MOV  AH, 0
    LODSB
    SHL  AX, CL             {   s2 (DX) := (Byte(DefChar) + DI + 1) * 32 }
    MOV  DX, AX
    MOV  AH, 0
    LODSB
    SHL  AX, CL             {   s3 (AX) := (Byte(DefChar) + DI + 2) * 32 }
    POP  SI
    MOV  CX, mpoints
@For_j:                     {   For j := lpoints DownTo 0 Do Begin }
    INC  SI                 {     Inc(off), 4th Byte, that we don't need. }
    MOV  DI, AX             { s3 }
    LODSB
    STOSB                   {     Mem[$A000: s3] := chardefs[off] }
    XCHG DX, DI             { s3+1 -> DX  s2 -> DI }
    LODSB
    STOSB                   {     Mem[$A000: s2] := chardefs[off] }
    XCHG BX, DI             { s2+1 -> BX  s1 -> DI }
    LODSB
    STOSB                   {     Mem[$A000: s1] := chardefs[off] }
    XCHG AX, DI             { s1+1 -> AX }
    XCHG AX, DX             { s3   -> AX  s1 -> DX }
    XCHG BX, DX             { s1   -> BX  s2 -> DX }
    LOOP @For_j             {   End; }
    POP  CX
    ADD  CX, 3
    CMP  CX, 9
    JB   @For_i             { End  }
  End;
  { Ok, put the Sequencer and Graphics Controller back to normal }
  Asm                                   { Program the Sequencer }
    pushf;                              { Disable interrupts }
    cli;
    mov dx, 3c4h;                       { Sequencer port address }
    mov ax, 0302h;                      { CPU writes to maps 0 and 1 }
    out dx, ax;
    mov ax, 0304h;                      { Odd-even addressing }
    out dx, ax;
    { Program the Graphics Controller }
    mov dx, 3ceh;                       { Graphics Controller port address }
    mov ax, 0004h;                      { Select map 0 for CPU reads }
    out dx, ax;
    mov ax, 1005h;                      { Enable odd-even addressing }
    out dx, ax;
    sub ax, ax;
    mov es, ax;                         { Segment 0 }
    mov ax, 0e06h;                      { Map starts at B800:0000 }
    mov bl, 7;
    cmp es:[49h], bl;                   { Get current video mode }
    jne @notmono;
    mov ax, 0806h;                      { Map starts at B000:0000 }
@notmono:
    out dx, ax;
    popf;
  End;
  { Ok, now put the Bytes on the screen }
  plotEgaVgacursor(1); { Plot the new grid on the screen. }
End;

{***********************************************************}
{ 27-Oct-1990 - dk                                          }
{                                                           }
{  Returns True If there is something in the Mouse buffer.  }
{                                                           }
{***********************************************************}
Function MouseCheck : Boolean; Assembler;
Asm
  MOV AL, mBufIn        { MouCheck := Boolean(mBufIn-mBufOut); }
  SUB AL, mBufOut
End;
{**********************************************}
{ 26-Oct-1990 - dk                             }
{                                              }
{  Mouse handler -- called from Mouse driver.  }
{                                              }
{**********************************************}
{$F+}
Procedure MouseHandler;
{ This function is called whenever a button is pressed.  Do not call this
   function directly!! }
Var conditionmask : Byte;
Begin
  { Get our data segment }
  Asm
    push ds
    push ax
    MOV  AX, SEG @DATA
    MOV  DS, AX
    POP  AX
    mov  conditionmask,al        { conditionmask }
  End;
  If Not Boolean(MouseFreeze) Then Begin
    Asm
      mov Mousex, cx               { save Mouse info passed to us from driver }
      mov Mousey, dx
      mov Mousepx, cx
      mov Mousepy, dx
    End;
    Mousex := MouseX Div 8;        { Characters are 8 pixels wide }
    Mousey := MouseY Div mPoints;   { Scale Mousey down }
    { See If the Mouse has moved. }
    If (conditionmask And MouseMove = MouseMove) Then Begin
      If saved Then Begin
        If EgaVga Then
          plotEgaVgacursor(0)
        else
{$IFNDEF HARDWCURSOR}
          PokeAttrib(oldmx, oldmy, oldword);
{$ENDIF}
        saved := False;
      End;
      { Check to see If we need to hide }
      If (Not Mousehidden) And conditionalhideMouse Then Begin
        If (Mousex >= conx1) And (Mousex <= conx2) And
              (Mousey >= cony1) And (Mousey <= cony2) Then Begin
            MouseHidden := True;
            conditionalhideMouse := False;
        End;
      End;
      If Not Mousehidden Then Begin
        If EgaVga Then
          drawEgaVgacursor
        else Begin
{$IFNDEF HARDWCURSOR}
          oldword := PeekAttrib(Mousex, Mousey);
          Asm
            MOV AX, oldword       { Prepare to rotate attrib Byte }
            mov cl, 4             { We want to rotate 4 bits }
            rol al, cl            { Rotate it }
            and al, 00fh          { Clear high bit and foreground color }
            Or  al, MouseForeGroundColor   { Set mouse foreground color }
            mov newword,AX
          End;
          PokeAttrib(Mousex, Mousey, newword); { Write out new Mouse cursor }
{$ENDIF}
        End;
        oldmx := Mousex;
        oldmy := Mousey;
        saved := True;
      End;
    End;
  End;
  { Now, see If a Mouse button was whacked }
  If Boolean(conditionmask And Not MouseMove) Then Begin
    If Succ(mbufin) Mod MouseBufferSize = mbufout Then Begin { Buffer full? }
      Sound(1760); { Make some noise. }
      Delay(10);
      NoSound;
    End
    Else Begin
      With mbuf[mbufin] Do Begin
        buttonstat := conditionmask And Not MouseMove;
        cx := Mousex;
        cy := Mousey;
        shiftstate := Mem[$0040: $0017]; { Get shift Byte }
      End;
      mbufin := Succ(mbufin) Mod MouseBufferSize;
    End;
  End;
  Asm pop ds End;
End;
{$F-}


{*****************************************************}
{ 27-Oct-1990 - dk                                    }
{                                                     }
{  This function checks for the presense of EGA/VGA.  }
{                                                     }
{*****************************************************}
Function IsEgaVga : Boolean; Assembler;
Asm
   mov ax, 1a00h   { ROM BIOS video function 1ah -- Read Display Code }
   int 10h
   cmp ah, 1ah     { Is this call supported? }
   je  @checkega   { Not supported }
   cmp bl, 7       { VGA w/monochrome display? }
   je  @isvga      { Yup. }
   cmp bl, 8       { VGA w/color display? }
   jne @checkega   { Nope }
@isvga:
   mov al, True    { EGA/VGA is installed }
   jmp @Done       { #EB }
@checkega:
   mov ah, 12h     { EGA BIOS function }
   mov bl, 10h
   int 10h
   cmp bl, 10h     { Is EGA BIOS present? }
   jne @isvga      { There is an EGA in the system. }
   mov al, False   { Not EGA or VGA in system. }
@Done:
End;

{**************************}
{ 26-Oct-1990 - dk         }
{                          }
{  Show the Mouse cursor.  }
{                          }
{**************************}
Procedure MouseShow;
Begin
  If MouseInstalled Then Begin
    Inc(Mousefreeze);       { don't have the handler doing weird things }
    { Just in case we were in a conditionalhide }
    If conditionalhideMouse Then Begin
      { We were about to conditional hide, but we didn't, don't reactive
         Mouse cursor. }
      conditionalhideMouse := False;
    End
    Else Begin
      If Mousehidden Then Begin
        Mousehidden := False;
        { Draw Mouse cursor }
        If EgaVga Then
          DrawEgaVgaCursor
        Else Begin
{$IFDEF HARDWCURSOR}
          Asm
            MOV	AX, 1
	    INT	33h
          End;
{$ELSE}
          oldword := PeekAttrib(Mousex, Mousey);
          Asm
            MOV AX, oldword;      { Prepare to rotate attrib Byte }
            mov cl, 4             { We want to rotate 4 bits }
            rol al, cl            { Rotate it }
            and al, 00fh          { Clear high bit }
            Or  al, MouseForeGroundColor   { Set mouse foreground color }
            mov newword,AX;
          End;
          PokeAttrib(Mousex, Mousey, newword); { Write out new Mouse cursor }
{$ENDIF}
        End;
        oldmx := Mousex;
        oldmy := Mousey;
        saved := True;
      End;
    End;
    Dec(Mousefreeze); 	    { Reactivate handler }
  End;
End;

{**********************************}
{ 26-Oct-1990 - dk                 }
{                                  }
{  Initialize the Mouse routines.  }
{                                  }
{**********************************}
Procedure MouseInit;
Begin
  Asm
    sub ax,ax;              { Mouse driver function 0 -- reset and detect }
    int 33h
    mov MouseInstalled, al;
  End;
  If MouseInstalled Then Begin
    Asm
      { Check to see If we are running in DESQview.  If so, don't try to
         use the 'True' EGA/VGA cursor (DV doesn't like it at ALL). }
      mov ax, 2b01h
      mov cx, 4445h
      mov dx, 5351h
      int 21h
      cmp al, 0ffh
      je @notdv
      mov desqview, True
@notdv:
      { Check to see If we are running in Windows Enhanced.  If so, don't try to
         use the 'True' EGA/VGA cursor  }
      mov ax, 1600h
      int 2fh
      cmp al, 00h
      je  @NotEnhWin
      cmp al, 80h
      je  @NotEnhWin
      cmp al, 01h
      je  @NotEnhWin
      cmp al, 0FFh
      je  @NotEnhWin
      mov MSWindowsEnh,True
@NotEnhWin:

      mov ax,0F00h;
      int 10h;
      mov vseg, 0B800h        { Assume color display  #EB }
      cmp al, 7
      jne @color
      mov vseg, 0B000h        { oh, no.. it's mono }
      mov MouseForegroundColor, LightGray Shl 4
@color:
      MOV AX, 0040h
      MOV ES, AX
      CMP Byte Ptr ES:[84h], 0          { No value, assume 80x25. }
      JNE @1
      MOV AL, 25
      MOV AH, 80
      MOV BL, 8
      JMP @2
@1:
      MOV AL, Byte Ptr ES:[84h]         { Rows }
      INC AL
      MOV AH, Byte Ptr ES:[4Ah]         { Cols }
      MOV BL, Byte Ptr ES:[85h]         { Points }
@2:
      MOV MRows, AL
      MOV MCols, AH
      MOV BYTE PTR mPoints, BL
    End;
    { Do we have an EGA or VGA?  If so, and we are not in monochrome mode
       and we are not in DESQview then setup to draw a 'True' Mouse cursor
       on an EGA/VGA }
    EgaVga := IsEgaVga And (vseg <> $B000) And Not Desqview And Not MSWindowsEnh;
{$IFDEF NOTEGAVGA}
    EgaVga := False;
{$ENDIF}
    Asm
      CMP EgaVga, 0
      JE  @NotEgaVga
      { We are going to use our 'True' Mouse cursor and we need pixel
         resolution, not character resolution from the Mouse driver
         (In text mode, the Mouse driver only returns coordinates in multiples
         of 8, which we don't want.  We want multiples of 1, i.e. pixel
         resolution).  To get the Mouse driver to return coordinates in pixel
         resolution, we 'trick' it into thinking it's in graphics mode by
         setting the low memory Byte indicating mode to mode 6 (CGA 640x200x2).
         Then we reset the Mouse driver.  The Mouse driver will get the video
         mode then act as If it was in graphics mode, not text mode. }
      MOV AX, 40h                {Savevmode := Mem[$0040: $0049] }
      MOV ES, AX
      MOV AL, ES:[0049h]
      MOV Savevmode, AL
      MOV BYTE PTR ES:[0049h], 6        { Mem[$0040: $0049] := 6 }
      { Reset driver for change in video mode to take effect. }
      XOR AX ,AX
      INT 33h
      { Now that we've tricked the Mouse driver into a grapics mode thereby
         causing it to give us pixel resolutions, put the old mode back. }
      MOV AL, savevmode
      MOV BYTE PTR ES:[0049h], AL       { Mem[$0040: $0049] := savevmode }
      { CALL SaveFont}
      JMP @EgaVga
@NotEgaVga:
      MOV mPoints, 8
      { Set up max x and y ranges. }
@EgaVga:
      MOV AL, mcols   { maxx := mcols * 8 - 1;  Pixels horizontally }
      XOR AH, AH
      SHL AX, 03
      DEC AX
      MOV maxx, AX
      MOV AL, mrows   { maxy := mrows * mpoints - 1;  Pixels vertically }
      XOR AH, AH
      MUL WORD PTR mpoints
      DEC AX
      MOV maxy, AX
      mov dx,maxx     { Pixels horizontally }
      mov ax,7        { Mouse driver function 7 -- set max x range }
      sub cx,cx       { Minimum range }
      int 33h
      mov dx,maxy     { Pixels veritcally }
      mov ax,8        { Mouse driver function 8 -- set max y range }
      sub cx,cx       { Minimum range }
      int 33h
    { Now install user routine }
      mov ax,cs
      mov es,ax
      Inc Mousefreeze         { Make sure handler doesn't do things, yet }
      mov dx, offset Mousehandler
    { Setup up bits for calling routine }
      mov cx,LeftBPress + LeftBRelease + RightBPress + RightBRelease + MouseMove
      mov ax,12       { Function 12 -- set user routine }
      int 33h
      mov cx, 0       { xcoord }
      mov dx, 0       { ycoord }
      mov ax,4        { Mouse driver function 4 -- set Mouse position }
      int 33h
      call MouseShow    { Call it twice just to make sure }

      DEC Mousefreeze { Handler can get into business, now }
    End;
  End;
End;


{************************************************************}
{ 26-Oct-1990 - dk                                           }
{                                                            }
{  Take a copy of the Mouse event at the head of the queue.  }
{                                                            }
{************************************************************}
Procedure Mousepreview(Var MouInfoRec : TMouInfoRec);
Begin
  If MouseInstalled Then Begin
    If (mbufin <> mbufout) Then      { If something is in buffer }
      MouInfoRec := mbuf[mbufout]
    Else                        { Nothing to pull, just report Mouse position }
      With MouInfoRec Do Begin
        cx := Mousex;
        cy := Mousey;
        buttonstat := 0;
        shiftstate := Mem[$0040: $0017];
      End;
  End;
End;

{**************************}
{ 26-Oct-1990 - dk         }
{  Hide the Mouse cursor.  }
{                          }
{**************************}
Procedure MouseHide;
{ This function turns off the Mouse cursor, the Mouse still responds to button presses }
Begin
  If MouseInstalled Then Begin
    Inc(MouseFreeze); 		{ don't have the handler doing weird things }
    MouseHidden := True; 		{ indicate it's hidden now }
    If Saved Then Begin
      If EgaVga Then
        PlotEgaVgaCursor(0)
      Else
{$IFDEF HARDWCURSOR}
        Asm
          MOV  AX, 2
          INT  33h
        End;
{$ELSE}
        PokeAttrib(oldmx, oldmy, oldword);
{$ENDIF}
      Saved := False;
    End;
    Dec(MouseFreeze); 		{ reactivate handler }
  End;
End;

{**********************************************************************}
{ 26-Oct-1990 - dk                                                     }
{                                                                      }
{  Hide the Mouse *if* it enters a certain screen area, automatically. }
{                                                                      }
{**********************************************************************}
Procedure MouseConditionalhide(x1, y1, x2, y2 : Integer);
Begin
  If MouseInstalled Then Begin
    Inc(MouseFreeze);                     	{ hold the handler }
    If Not Mousehidden Then Begin
      ConditionalhideMouse := True;
      Dec(x1, 2);
      If (x1 < 0) Then x1 := 0;
      Dec(y1, 2);
      If (y1 < 0) Then y1 := 0;
      Inc(x2, 2);
      Inc(y2, 2);
      conx1 := x1;
      cony1 := y1;
      conx2 := x2;
      cony2 := y2;
      If (Mousex >= conx1) And (Mousex <= conx2) And
          (Mousey >= cony1) And (Mousey <= cony2) Then Begin
        conditionalhideMouse := False;            { We've already hidden it }
        MouseHide;                                  { turn it off now If it's there. }
      End;
    End;
    Dec(MouseFreeze);                           { reactivate handler }
  End;
End;

{************************************}
{ 26-Oct-1990 - dk                   }
{                                    }
{  Deinitialize the Mouse routines.  }
{                                    }
{************************************}
Procedure MouseDeinit; Assembler;
Asm
  CMP  MouseInstalled, 0
  JE   @Exit
  CALL MouseHide
  sub  ax,ax
  int  33h
  cmp  EgaVga, 0
  JE   @Exit
  {CALL RestoreFont}
@Exit:
End;

{************************************************}
{ 26-Oct-1990 - dk                               }
{                                                }
{  Returns the bits for the button status info.  }
{                                                }
{************************************************}
Function Mousebuttonstatus : Word; Assembler;
Asm
  CMP   MouseInstalled, 0
  JE    @Exit
  MOV   AX, 3
  INT   33h
  MOV   AX, BX
@Exit:
End;

{**************************************************************}
{ 26-Oct-1990 - dk                                             }
{                                                              }
{  Get (and remove) the Mouse event at the head of the queue.  }
{                                                              }
{**************************************************************}
Procedure MouseGet(Var MouInfoRec :TMouInfoRec);
Begin
  If MouseInstalled Then Begin
    If (mbufin <> mbufout) Then Begin { If something is in buffer }
      mouinforec := mbuf[mbufout];
      mbufout := Succ(mbufout) Mod MouseBufferSize;
    End
    Else With MouInfoRec Do Begin  { Nothing to pull, just report Mouse position }
      cx := Mousex;
      cy := Mousey;
      buttonstat := 0;
      shiftstate := Mem[$0040: $0017];
    End;
  End;
End;

End.









