Unit FDC;

{
  Written by Mikael Lrum 01-1993 in C,
  Rewritten by Eugeni Bobrov

}
Interface

Const
  NecError : Integer = 0;
  NecAdr   = $3F0;


Function ChLine(Drive: Byte) : Boolean;
Procedure MotorOn(Drive : Byte);

Implementation

{-$DEFINE ASMTEST}

Procedure NecOut(Data : Byte); Assembler;
Asm
	MOV	CX, 0FFFFh           { Wait for NEC ready }
	MOV	DX, NecAdr+4         { While ((Port[NecAdr + 4] And $C0) }
@L1:	IN	AL, DX               { <> $80) And (CX > 0) Do Dec(CX);  }
	AND	AL, 0C0h
        CMP	AL, 80h
        JE      @L2
        DEC	CX
        JNE	@L1
@L2:    CMP	CX, 0                { If CX = 0 Then NecError := 1;}
	JNE	@L3
        MOV	NecError, 1
@L3:	MOV	DX, NecAdr+5         { send byte to nec }
	MOV	AL, Data
        OUT	DX, AL
        { a 35 - 40 [us] delay migth be nessesary here. }
End;

Function NecIn : Byte; Assembler;
Asm
	MOV	CX, 0FFFFh           { Wait for NEC ready }
	MOV	DX, NecAdr+4         { While ((Port[NecAdr + 4] And $C0) }
@L1:	IN	AL, DX               { <> $80) And (CX > 0) Do Dec(CX);  }
        AND     AL, 0C0h
        CMP	AL, 080h
        JE      @L2
        DEC	CX
        JNE	@L1
@L2:    CMP	CX, 0                { If CX = 0 Then NecError := 2;}
	JNE	@L3
        MOV	NecError, 2
@L3:	MOV	DX, NecAdr+5         { read from NEC }
	IN	AL, DX
        { a 35 - 40 [us] delay migth be nessesary here. }
End;


{   Recalibrate drive }
Procedure DriveReset(Drive : Byte);
Begin
  NecOut(7);
  NecOut(Drive And 3);
End;

Procedure Seek(Drive, Track :Byte);
Begin
  NecOut($F);
  NecOut(Drive And 3);
  NecOut(Track);
End;

Procedure MotorOn(Drive : Byte);
Const
  MotorOnTabel     : Array[0..3] Of Byte = ($1c, $2d,  $4e, $8f);
  MotorStatusTabel : Array[0..3] Of Byte = ($01, $12,  $24, $38);
Var
  MotorOffCounter  : Byte Absolute 0:$440;     { Motor Off Counter in BIOS}
  MotorStatus      : Byte Absolute 0:$43F;     { Motor Status in BIOS }

Begin
  MotorOffCounter := $40;
  If MotorStatus And (MotorStatusTabel[Drive] And $f) = 0 Then Begin
    Port[NecAdr+2] := MotorOnTabel[Drive];     { Turn Drive on }
    MotorStatus := MotorStatusTabel[Drive];
  End;
End;

Function ChLine(Drive:Byte) : Boolean;
{ Return values: 0h  Diskette Change Line not active
                 1h  Diskette Change Line active
}
Var
  MediaState   : Array[0..1] Of Byte Absolute 0:$490; { Drive 0/1 Media status }
  CurrentTrack : Array[0..1] Of Byte Absolute 0:$494; { Drive 0/1 track status }
  SystemTimer  : LongInt             Absolute 0:$46C;
Begin
  ChLine := False;
  MotorOn(Drive);
  If (Port[NecAdr + 7] And $80 = $0)  Then
    CurrentTrack[Drive] := 0
  Else Begin
    CurrentTrack[Drive] := Ord(SystemTimer Mod 12 < 6);   { 0 / 1}
    MediaState[Drive] := MediaState[Drive] And $E8;   { Force DOS to check media change }
    ChLine := True;
  End;
  Seek(Drive, CurrentTrack[Drive]);
End;

End.