{G+,I-,R-,S-}
Unit DosOop;

{ Eugeni Bobrov <eb@biocat.ruc.dk> }

Interface

Uses Dos, DosX;

Type
  TCommand = (cRead, cWrite);
  FatCopy  = (Fat1, Fat2);
  PPhysDevice = ^PhysDevice;
  PhysDevice = Object
    RootDirSectors : Word;
    ClusterSize : Word;
    LDosSector : LongInt;
    RWBlock : ReadWriteBlock;
    Drive : Byte;

    Constructor Init;
    Destructor Done; virtual;
    Procedure SetDrive(D:Byte);
    Procedure IoCtl_Io(Command : Word);
    Function  NextCluster(Var P:PZeroArray; C:Word) : Word; Virtual;
    Procedure BootRecord_Io(Var P; cm : TCommand); Virtual;
    Procedure Fat_Io(Offset:LongInt; Var P; Fc:FatCopy; cm : TCommand); Virtual;
    Procedure RootDir_Io(Var P; cm : TCommand); Virtual;
    Procedure Cluster_Io(Var P; C, n : Word; cm : TCommand);  Virtual;
    Procedure Sector_Io(Var P; S, n : Word; cm : TCommand);  Virtual;
  End;

  PLogicalDevice = ^LogicalDevice;
  LogicalDevice = Object(PhysDevice)
    ControlPacket : TControlPacket;

    Constructor Init(D:Byte; Var P);
    Destructor Done; virtual;
    Procedure BootRecord_Io(Var P; cm : TCommand); Virtual;
    Procedure RootDir_Io(Var P; cm : TCommand); Virtual;
    Procedure Fat_Io(Offset:LongInt; Var P; Fc:FatCopy; cm : TCommand); Virtual;
    Procedure Cluster_Io(Var P; C, n : Word; cm : TCommand);  Virtual;
    Procedure Sector_Io(Var P; S, n : Word; cm : TCommand);  Virtual;
  End;

  PFileDevice = ^FileDevice;
  FileDevice = Object(PhysDevice)
    F : File;

    Constructor Init(Path : PathStr; Var P);
    Destructor Done; virtual;
    Procedure BootRecord_Io(Var P; cm : TCommand); Virtual;
    Procedure RootDir_Io(Var P; cm : TCommand); Virtual;
    Procedure Fat_Io(Offset:LongInt; Var P; Fc:FatCopy; cm : TCommand); Virtual;
    Procedure Cluster_Io(Var P; C, n : Word; cm : TCommand);  Virtual;
    Procedure Sector_Io(Var P; S, n : Word; cm : TCommand);  Virtual;
  End;

Implementation

{ ------------------------------------------------------------------- }

Constructor PhysDevice.Init;
Begin
  FillChar(RWBlock, SizeOf(RWBlock), 0);
End;

Destructor PhysDevice.Done;
Begin
End;

Procedure PhysDevice.SetDrive(D:Byte);
Begin
  Drive := D;
  With DeviceP^ Do Begin
    ClusterSize := Sec_Cluster*BytesSector;
    RootDirSectors := RootDirEnt Div (BytesSector Div 32);
  End;
End;


Procedure PhysDevice.IoCtl_Io(Command : Word);
Var s : Word;
Begin
  While (RWBlock.FirstSector + RWBlock.Sectors) > DeviceP^.SectorsTrack Do Begin
    s := RWBlock.Sectors;
    RWBlock.Sectors := DeviceP^.SectorsTrack-RWBlock.FirstSector;
    GenIoCtlReq(Drive, Command, RWBlock);
    Inc(LongInt(RWBlock.Buffer), RWBlock.Sectors*DeviceP^.BytesSector);
    Inc(RWBlock.Head);
    If RWBlock.Head = DeviceP^.Heads Then Begin
      RWBlock.Head := 0;
      Inc(RWBlock.Track);
    End;
    RWBlock.FirstSector := 0;
    RWBlock.Sectors := S-RWBlock.Sectors;
  End;
  GenIoCtlReq(Drive, Command, RWBlock);
End;

Procedure PhysDevice.BootRecord_Io(Var P; cm: TCommand);
Begin
  RWblock.Head := DeviceP^.HiddenSectors Div DeviceP^.SectorsTrack;
  RWBlock.Track := 0;
  RWBlock.Buffer := Addr(P);
  RWBlock.FirstSector := 0;
  RWBlock.Sectors := 1;
  Case cm Of
    cRead : IoCtl_Io(ReadTrack);
    cWrite : IoCtl_Io(WriteTrack);
  End;
End;

Procedure PhysDevice.RootDir_Io(Var P; cm : TCommand);
Var PS : TPhysSector;
Begin
  LDosSector := GetSystemSectors(DeviceP)-RootDirSectors;
  DosSectorToPhysSector(DeviceP, LDosSector, PS);
  Move(PS, RWBlock.Head, SizeOf(PS));
  RWBlock.Buffer := Addr(P);
  RWBlock.Sectors := RootDirSectors;
  Case cm Of
    cRead : IoCtl_Io(ReadTrack);
    cWrite : IoCtl_Io(WriteTrack);
  End;
End;

Function PhysDevice.NextCluster(Var P : PZeroArray; C : Word) : Word;
Const
  Offset : LongInt = 0;
Var
  OffsetFat : LongInt;
  Cluster : Word;
Begin
  Case FATType Of
    Fat12 : Begin
              OffsetFat := C * 3 Div 2;
              Cluster := P^[OffsetFat]+P^[OffsetFat+1] Shl 8;
              If C Mod 2 = 0 Then              { Even Cluster }
                Cluster := Cluster And $FFF
              Else
                Cluster := (Cluster And $FFF0) Shr 4;
            End;
    Fat16 : Begin
              OffsetFat := LongInt(C) Shl 1;
              If Not ((OffsetFat >= Offset) And (OffsetFat < Offset+FatSize)) Then Begin
                Offset := (OffsetFat Div FatSize) * FatSize;
                Fat_Io(Offset, P^, Fat1, cRead);
              End;
              OffsetFat := OffsetFat Mod FatSize;
              Cluster := P^[OffsetFat]+P^[OffsetFat+1] Shl 8;
            End;
  End;
  NextCluster := Cluster;
End;

Procedure PhysDevice.Fat_Io(Offset:LongInt; Var P; Fc:FatCopy; cm : TCommand);
Var
  PS : TPhysSector;
Begin
  With DeviceP^ Do Begin
    If LongInt(FatSectors)*BytesSector < FatSize Then
      FatSize := LongInt(FatSectors)*BytesSector;
    LDosSector := HiddenSectors+ResSectors+Offset Div BytesSector;
    Inc(LDosSector, Ord(Fc)*FatSectors);
    RWBlock.Buffer := Addr(P);
    RWBlock.Sectors := FatSize Div BytesSector;
  End;
  DosSectorToPhysSector(DeviceP, LDosSector, PS);
  Move(PS, RWBlock.Head, SizeOf(PS));
  Case cm Of
    cRead  : IoCtl_Io(ReadTrack);
    cWrite : IoCtl_Io(WriteTrack);
  End;
End;

Procedure PhysDevice.Cluster_Io(Var P; C, n : Word; cm : TCommand);
Var
  PS : TPhysSector;
Begin
  DosSectorToPhysSector(DeviceP, ClusterToDosSector(DeviceP, C), PS);
  Move(PS, RWBlock.Head, SizeOf(PS));
  RWBlock.Sectors := DeviceP^.Sec_Cluster*n;
  RWBlock.Buffer := Addr(P);
  Case cm Of
    cRead  : IoCtl_Io(ReadTrack);
    cWrite : IoCtl_Io(WriteTrack);
  End;
End;

Procedure PhysDevice.Sector_Io(Var P; S, n : Word; cm : TCommand);
Var
  PS : TPhysSector;
Begin
  DosSectorToPhysSector(DeviceP, S, PS);
  Move(PS, RWBlock.Head, SizeOf(PS));
  RWBlock.Sectors := n;
  RWBlock.Buffer := Addr(P);
  Case cm Of
    cRead  : IoCtl_Io(ReadTrack);
    cWrite : IoCtl_Io(WriteTrack);
  End;
End;

{ ------------------------------------------------------------------- }

Constructor LogicalDevice.Init(D:Byte; Var P);
Var PP : Pointer;
Begin
  Drive := D;
  PP := Addr(P);
  BootRecord_Io(P, cRead);
  Inc(LongInt(PP), 11);
  Move(PP^, DeviceP^.BytesSector, 29);
  With DeviceP^ Do Begin
    HiddenSectors := 0;
    ClusterSize := Sec_Cluster*BytesSector;
    RootDirSectors := RootDirEnt Div (BytesSector Div 32);
  End;
End;

Destructor LogicalDevice.Done;
Begin
End;

Procedure LogicalDevice.BootRecord_Io(Var P; cm : TCommand);
Begin
  ControlPacket.Sector := 0;
  ControlPacket.Count  := 1;
  ControlPacket.Buffer := Addr(P);
  Case cm Of
    cRead : AbsRead(Drive-1, ControlPacket);
    cWrite : AbsWrite(Drive-1, ControlPacket);
  End;
End;

Procedure LogicalDevice.RootDir_Io(Var P; cm : TCommand);
Begin
  LDosSector := GetSystemSectors(DeviceP)-RootDirSectors;
  ControlPacket.Sector := LDosSector;
  ControlPacket.Count :=  RootDirSectors;
  ControlPacket.Buffer := Addr(P);
  Case cm Of
    cRead  : AbsRead(Drive-1, ControlPacket);
    CWrite : AbsWrite(Drive-1, ControlPacket);
  End;
End;

Procedure LogicalDevice.Fat_Io(Offset : LongInt; Var P; Fc:FatCopy; cm : TCommand);
Begin
  With DeviceP^ Do Begin
    If Fats = 2 Then
      Inc(LDosSector, Ord(Fc)*FatSectors);
    LDosSector := HiddenSectors+ResSectors+Offset Div BytesSector;
    ControlPacket.Sector := LDosSector;
    ControlPacket.Count := FatSize Div BytesSector;
  End;
  ControlPacket.Buffer := Addr(P);
  Case cm Of
    cRead  : AbsRead(Drive-1, ControlPacket);
    CWrite : AbsWrite(Drive-1, ControlPacket);
  End;
End;

Procedure LogicalDevice.Cluster_Io(Var P; C, n : Word; cm : TCommand);
Begin
  ControlPacket.Sector := ClusterToDosSector(DeviceP, C);
  ControlPacket.Count := DeviceP^.Sec_Cluster*n;
  ControlPacket.Buffer := Addr(P);
  Case cm Of
    cRead  : AbsRead(Drive-1, ControlPacket);
    CWrite : AbsWrite(Drive-1, ControlPacket);
  End;
End;

Procedure LogicalDevice.Sector_Io(Var P; S, n : Word; cm : TCommand);
Begin
  ControlPacket.Sector := S;
  ControlPacket.Count := n;
  ControlPacket.Buffer := Addr(P);
  Case cm Of
    cRead  : AbsRead(Drive-1, ControlPacket);
    CWrite : AbsWrite(Drive-1, ControlPacket);
  End;
End;

{ ------------------------------------------------------------------- }

Constructor FileDevice.Init(Path:PathStr; Var P);
Var
  PP : Pointer;
Begin
  Assign(F, Path);
  Reset(F, 1);
  If IoResult <> 0 Then Begin
    WriteLn('File Not found');
    Halt(2);
  End;
  BootRecord_Io(P, cRead);
  PP := Addr(P);
  Inc(LongInt(PP), 11);
  Move(PP^, DeviceP^.BytesSector, 29);
  With DeviceP^ Do Begin
    RootDirSectors := RootDirEnt Div (BytesSector Div 32);
    ClusterSize := Sec_Cluster*BytesSector;
  End;
End;

Destructor FileDevice.Done;
Begin
  Close(F);
End;

Procedure FileDevice.BootRecord_Io(Var P; cm : TCommand);
Begin
  Seek(F, 0);
  Case cm Of
    cRead : BlockRead(F, Addr(P)^, 512);
    cWrite : BlockWrite(F, Addr(P)^, 512);
  End;
End;

Procedure FileDevice.RootDir_Io(Var P; cm : TCommand);
Begin
  LDosSector := GetSystemSectors(DeviceP)-RootDirSectors;
  Seek(F, LDosSector*512);
  Case cm Of
    cRead : BlockRead(F, Addr(P)^, RootDirSectors*DeviceP^.BytesSector);
    cWrite : BlockWrite(F, Addr(P)^, RootDirSectors*DeviceP^.BytesSector);
  End;
End;

Procedure FileDevice.Fat_Io(Offset:LongInt; Var P; Fc:FatCopy; cm : TCommand);
Begin
  With DeviceP^ Do Begin
    LDosSector := HiddenSectors+ResSectors+Offset Div BytesSector;
    Inc(LDosSector, Ord(Fc)*FatSectors);
  End;
  Seek(F, LDosSector*512);
  Case cm Of
    cRead : BlockRead(F, Addr(P)^, FatSize);
    cWrite : BlockWrite(F, Addr(P)^, FatSize);
  End;
End;

Procedure FileDevice.Cluster_Io(Var P; C, n : Word; cm : TCommand);
Begin
  Seek(F, ClusterToDosSector(DeviceP, C)*512);
  Case cm Of
    cRead : BlockRead(F, Addr(P)^, ClusterSize*n);
    cWrite : BlockWrite(F, Addr(P)^, ClusterSize*n);
  End;
End;

Procedure FileDevice.Sector_Io(Var P; S, n : Word; cm : TCommand);
Begin
  Seek(F, LongInt(S)*512);
  Case cm Of
    cRead : BlockRead(F, Addr(P)^, 512*n);
    cWrite : BlockWrite(F, Addr(P)^, 512*n);
  End;
End;

End.
