{$A+,B-,D+,E-,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V+,X+,Y+}
{$M 3072,0,655360}
Program CopyDisk;

{ Eugeni Bobrov <eb@biocat.ruc.dk> }

Uses
  CpuId,
  ParseCom,
  XCRT,
  XMM,
  Dos,
  DosX,
  DosOOP,
  FDC,
  CDTCV,
  CDTTY,
  CDFull,
  BootSect,
  Strings;

Const
  Version : String[45] = '3.30';
  DriveParamsSaved : Boolean = False;
  Month : Array[1..12] Of String[3] =
  ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');

Var
  { XMM Vars }
  XMSAlloc   : LongInt;
  ExtMemMove : ExtMemMoveRec;
  PScr : PTTY_Msg;
  PDevice : PPhysDevice;
  Format : Boolean;
  FloppyDrives, OldDriveS : Byte;
  RootDir, Fat : PZeroArray;

{$L DATE.OBJ }
{$F+}
Function CompiledDate : PChar; External;
{$F-}


Procedure Abort(s: Str80; n : Byte);
Begin
  Dispose(PScr, Done);
  PScr := Nil;
  Dispose(PDevice, Done);
  PDevice := Nil;
  If s <> '' Then WriteLn(#13#10,s);
  Halt(n);
End;

{ Inserts V in TmpStr at Offset 24 }
{$V+}
Procedure InsertMulti(V : Word; Var TmpStr : Str80; Offs : Byte);
Var
  s : String[6];
Begin
  Str(V, S);
  Insert('#' + S + ' ', TmpStr, Offs);
End;
{$V-}

Procedure CheckDosVersion;
Begin
  DosVer := Swap(DosVersion);
  If DosVer < $031E Then
    Abort(ErrTxt0, 1);
End;

Function GetVideoMode(S:Str6) : Word;
Var
  j, VMSize : Word;
Begin
  j := 0;
  VMSize := SizeOf(VideoModeArray) Div SizeOf(VideoModeArray[j]);
  While (s <> VideoModeArray[j].S) And (j<VMSize) Do
    Inc(j);
  If (j = VMSize) Then
    GetVideoMode := LastMode
  Else
    If j < VMSize Then
      GetVideoMode := VideoModeArray[j].C;
End;


Procedure WriteSetup(Res : Boolean);
Const
  DefaultSetup : Array[0..20] Of Byte =
  (02, 01, 01, 00, 01, 00, 00, 01, 01, 00, 00, 00, 00, $00, $00, $00, $00,
   00, 00, 00, 01);
  Offset = 50000;
Var
  F : File;
  Buf : PZeroArray;
  DirInfo : SearchRec;
  i : Word;
  S : String[5];
  P : Pointer;
Begin
  FindFirst(ParamString[0]^, Archive, DirInfo);
  Assign(F, ParamString[0]^);
  Reset(F, 1);
  With DirInfo Do Begin
    GetMem(Buf, Size);
    Seek(F, Offset);
    BlockRead(F, Buf^, Size-Offset);
    S[0] := #5;
    i := 0;
    Move(Buf^, S[1], SizeOf(S)-1);
    While S <> Setup Do Begin
      Inc(i);
      Move(Buf^[i], S[1], SizeOf(S)-1);
    End;
    Inc(i, SizeOf(S)-1);
    P := Addr(Alarm);
    If Res Then
      Move(DefaultSetup, P^, SizeOf(DefaultSetup));
    Seek(F, i+Offset);
    BlockWrite(F, P^, SizeOf(DefaultSetup));
    SetFTime(F, Time);
    FreeMem(Buf, Size);
  End;
  Close(F);
End;

Procedure GetOptinion;

Procedure SyntaxError(s : String);
Begin
  PScr^.ShowSyntax;
  Abort('Unknown option '+ s, 255);
End;

Var
  i,j   : Byte;
  s     : Str80;
  Name  : NameStr;
  Ext   : ExtStr;
  Error : Integer;
  ShowHelp : Boolean;
Begin
  SaveSetup := False;
  ShowHelp := False;
  For i := 1 To ParamCt Do Begin
    s := ParamString[i]^;
    If s[1] = '/' Then Begin
      Case UpCase(s[2]) Of
        'A'     : Case s[3] Of
                      '+', '2' : Alarm := sAlarm;
                      '1'      : Alarm := sNormalSound;
                      '0', '-' : Alarm := sSilence;
                  End;
        'B'     : Begin
                    FSplit(Fexpand(Copy(s, 3, Length(s))), SwapDir, Name, Ext);
                    SwapFname := Name+Ext;
                  End;
        'C'     : UseChangeLine := s[3] = '+';
        'E'     : FullScreen := s[3] = '+';
        'F'     : Case s[3] Of
                      '+' : ForcedFormat := True;
                      '-' : ForcedFormat := False;
                      'S' : FatSelect := s[4] = '+';
                  End;
        'I'     : Ignore := s[3] = '+';
        'K'     : UseKeyboard := s[3] = '+';
        'L'     : ShowLabel := s[3] = '+';
        'M'     : Begin
                    Val(Copy(s, 3, Length(s)), NoOfCopies, Error);
                    MultiCopy := Error = 0;
                    If MultiCopy Then Begin
                      If NoOfCopies = 0 Then Abort('Zero copies ??!!', $FF);
                    End
                    Else SyntaxError(s);
                  End;
        'R'     : Begin
                    Case s[3] Of
                      '+' :Skewing := True;
                      'S' :SlowRW  := s[4] = '+';
                      '-' :Skewing := False;
                    End;
                    ForcedFormat := Skewing Or ForcedFormat;
                  End;
        'S'     : Begin
                    s := Copy(S, 4, Length(S));
                    VideoMode := s;
                    VideoModeC := GetVideoMode(s);
                  End;
        'V'     : Verify   := s[3] = '+';
        'X'     : UseXms   := s[3] = '+';
        'W'     : Case S[3] Of
                    '0' : Begin
                            WriteSetup(True);
                            VideoModeC := GetVideoMode(VideoMode);
                          End;
                    '1' : SaveSetup := True;
                  End;
        'H','?' : ShowHelp := True;
      Else
        SyntaxError(s);
      End;
    End;
  End;
  If ShowHelp Then Begin
    PScr^.ShowSyntax;
    Dispose(PScr, Done);
    PScr := Nil;
    Halt;
  End;
End;

Procedure ShowTransferTime(T : LongInt);
Var
  Seconds : Word;
Begin
  Seconds := (T * 10) Div 182;
  PScr^.TransferTime(Seconds Div 60, Seconds Mod 60);
End;

{ Returns systemtimer in DX:AX }
Function ReadSystemTimer : Longint; Assembler;
Asm
  MOV	AH, 00
  INT   1Ah
  MOV	AX, DX
  MOV	DX, CX
End;

Procedure DeallocMem;
Var
  i : Byte;
  XMM_Ret : LongInt;
Begin
  If MemAllocated Then Begin
    For i := 1 To BufId+1 Do
      FreeMem(Buf[i], TrackSize);
    If SwapToXms And XmsAllocated Then Begin
      XMM_Ret := XMM_FreeExtended(XMSHandle.Handle); { Deallocation of XMS mem }
      XmsAllocated := XMM_Ret < 0;                   { This code is called     }
      If XmsAllocated Then                           { every time program finish }
        WriteLn(#13'Unable to free XMS', XMM_Ret);   { copying a disk }
    End;
    Memallocated := False;
    FreeMem(RootDir, DeviceP^.RootDirEnt*32);
  End;
End;

Procedure ChangeDrive(Cont:ContType; Var Drive:Byte; Var DriveChanged:Boolean);
Begin
  If FloppyDrives > 1 Then Begin
    If (DriveS=1) And (Cont=ctNewDriveB) Or (DriveS=2) And (Cont=ctNewDriveA) Then Begin
      DriveChanged := True;
      SourceP^.SpecFunc := 4;
      GenIoCtlReq(DriveS, SetDevice, SourceP^);  { !!Restore Drive parameters!! }
      If DriveT <> DriveS Then Begin
        TargetP^.SpecFunc := 4;
        GenIoCtlReq(DriveT, SetDevice, TargetP^);{ !!Restore Drive parameters!! }
      End;
      If DriveS = 1 Then
        Inc(DriveS)
      Else
        Dec(DriveS);
      SourceP^.SpecFunc := 0;
      GenIoCtlReq(DriveS, GetDevice, SourceP^);  { !!Save Drive parameters!! }
      DriveT := DriveS;
      TargetP^.SpecFunc := 0;
      GenIoCtlReq(DriveS, GetDevice, TargetP^);  { !!Save Drive parameters!! }
      Drive := DriveS;
      PScr^.SetDrives(Chr(DriveS+64), Chr(DriveT+64));
      tSource[Length(tSource)-1] := Chr(DriveS+64);
      tTarget[Length(tTarget)-1] := Chr(DriveT+64);
      tRemoveSource[26] := Chr(DriveS+64);
      tRemoveTarget[26] := Chr(DriveT+64);
      tRemoveDisk[28]  := Chr(DriveS+64);
    End;
  End
  Else
    PScr^.Beep(bpError);
End;

Procedure ChangeDisk(Drive:Byte; Remove:TPrompt; Var DriveChanged :Boolean);
Const
  ChangeLineIdx : Boolean = True;
  FirstTime : Boolean = True;
Var
  B, ChangeLine :Boolean;
  Sec, Sec1, n : Byte;
  Cont : ContType;
  S : Str80;
Begin
  DriveChanged := False;
  If Alarm <> sSilence Then
    If Remove=ptRemoveSource Then
      PScr^.Beep(bpSource)
    Else
      PScr^.Beep(bpTarget);
  Sec := ((ReadSystemTimer Mod 65543) Mod 1092) * 100 Div 1821;
  Repeat
    Cont := PScr^.Continue;
  Until (Cont = ctGoOn) Or (Cont = ctQuit);
  If (Remove=ptRemoveTarget) And (DiskId = 1) Then
    tText := tSource
  Else Begin
    tText := tTarget;
    If MultiCopy Then
      InsertMulti(DiskId, tText, 24);
  End;
  PScr^.ClearLine;
  If (Not UseChangeLine And UseKeyBoard) Or Not ChangeLineSupport[Drive] Then Begin
    If DriveS <> DriveT Then Begin
      tText := tTarget;
    End;
    tText := tText + ' and Press ENTER to continue';
    PScr^.Prompt(ptText);
    Repeat
      Cont := PScr^.Continue;
    Until (Cont = ctEnterSpace) Or (Cont = ctQuit);
    PScr^.NewLine;
    PScr^.ClearLine;
    If PScr^.Continue=ctQuit Then
      Halt(0);
  End
  Else Begin
    If Not StartCopy Then Begin
      If DriveS = DriveT Then Begin
        B := False;
        Repeat
          Sec1 := ((ReadSystemTimer Mod 65543) Mod 1092) * 100 Div 1821;
          If ((Sec1-Sec) Mod 15 = 0) And (Alarm <> sSilence) And B Then Begin
            B := False;
          End Else If (Sec1-Sec) Mod 15 <> 0 Then
            B := True;
          If ChangeLineIdx Then Begin
            n := 0;
            Repeat
              PScr^.Delay(50);
              ChangeLine := ChLine(Drive-1);
              Inc(n);
            Until Not ChangeLine or (n=20);
            ChangeLineIdx := False;
          End;
          ChangeLine := ChLine(Drive-1);
          If Not ChangeLine And Not B Then  { Wait until drive not Ready }
            If FirstTime Then
              PScr^.Prompt(ptRemoveDisk)
            Else Begin
              If Remove=ptRemoveSource Then
                PScr^.Prompt(ptRemoveSource)
              Else Begin
                If MultiCopy Then Begin
                  S := tRemoveTarget;
                  If DiskId-1 <> 0  Then
                    n := DiskId-1
                  Else
                    n := NoOfCopies;
                  InsertMulti(n, tRemoveTarget, 15);
                  PScr^.Prompt(ptRemoveTarget);
                  tRemoveTarget := S;
                End
                Else
                  PScr^.Prompt(ptRemoveTarget);
             End;
          End;
          Cont := PScr^.Continue;
          If Cont In [ctNewDriveA, ctNewDriveB] Then Begin
            ChangeDrive(Cont, Drive, DriveChanged);
            If DriveChanged Then
              Exit;
          End;
        Until (ChangeLine) Or (Cont In [ctEnterSpace, ctQuit]);
        If PScr^.Continue=ctQuit Then
          Abort('', 0);
        PScr^.ClearLine;
      End;
    End;
    FirstTime := False;
    If DriveS <> DriveT Then Begin
      If Not FullScreen Then Begin
        PScr^.Prompt(ptInsertSource);
        PScr^.NewLine;
        PScr^.NewLine;
        tText := tTarget;
        If MultiCopy Then
          InsertMulti(DiskId, tText, 24);
      End
      Else Begin
        tText := tTarget;
        If MultiCopy Then
          InsertMulti(DiskId, tText, 24);
        tText := tSource + ' and ' + Copy(tText, 8, Length(tText));
      End;
    End;
    PScr^.Prompt(ptText);
    Repeat
      PScr^.Delay(100);
      ChangeLine := ChLine(Drive-1);
      Cont := PScr^.Continue;
      If Cont In [ctNewDriveA, ctNewDriveB] Then Begin
        ChangeDrive(Cont, Drive, DriveChanged);
        If DriveChanged Then
          Exit;
      End;
    Until Not ChangeLine Or (Cont In [ctEnterSpace, ctQuit]);
    If Cont=ctQuit Then
      Abort('', 0);
    If FullScreen Then
      PScr^.ClearLine;
  End;
  PScr^.Beep(bpNone);
End;

Procedure AllocMem;
Var
  AllocRet : LongInt;
Begin
  GetMem(RootDir, DeviceP^.RootDirEnt*32);
  BufId := 1;
  While (MaxAvail-512 >= TrackSize) And (LongInt(BufId-3)*TrackSize < RealDSizeS) Do Begin
    GetMem(Buf[BufId], TrackSize);
    FillChar(Buf[BufId]^, TrackSize, $F6);
    Inc(BufId);
  End;
  Dec(BufId, 2);                                 { res. 1 Buffer }
  DosAllocSize := LongInt(TrackSize)*(BufId-1);  { res 1 Buffer for transfer }
  SwapMem := RealDSizeS-DosAllocSize;
  SwapToXMS := ((RealDSizeS > LongInt(TrackSize)*(BufId-1)) And SwapToXMS) And UseXMS;
  If SwapToXMS Then Begin
    If SwapMem >= FreeExtended*1024 Then
      XMSAlloc := FreeExtended
    Else
      XMSAlloc := Succ(SwapMem Div 1024);
    AllocRet := XMM_AllocateExtended(XMSAlloc);
    XmsAllocated := AllocRet >= 0;
    If XmsAllocated Then Begin
      XMSHandle.Handle := Word(AllocRet);
      XMSAllocSize := LongInt(XMSAlloc)*1024;
      If XMSAllocSize + DosAllocSize - DeviceP^.BytesSector > RealDsizeS Then
        Dec(XMSAlloc);
    End
    Else Begin
      If Byte(XmsError(AllocRet)) = $A1 Then
        WriteLn(#13'Unable to allocate XMS', AllocRet);
      XMSAllocSize := 0;
    End;
  End;
  MemAllocated := True;
  Fat := Buf[1];
  Inc(LongInt(Fat), DeviceP^.BytesSector);
  SwapToDisk := SwapMem-XMSAllocSize > 0;
End;

Procedure CopyDiskExitProc;                  { Ctrl-C Handler and Exit proc}
Begin
  If MemAllocated Then
    DeAllocMem;                   { DOS dealloctes conv mem!, but not XMS  }
  If SaveSetup Then
    WriteSetup(False);
  ExitProc := ExitProcPtr;
  WriteLn;
  If SwapToDisk Then Begin
    Close(SwapF);
    If IoResult = 0 Then
      Erase(SwapF);
  End;
  SetIntVec($23, int23);
  If DriveParamsSaved Then Begin
    SourceP^.SpecFunc := 4;
    GenIoCtlReq(DriveS, SetDevice, SourceP^);  { !!Restore Drive parameters!! }
    If DriveT <> DriveS Then Begin
      TargetP^.SpecFunc := 4;
      GenIoCtlReq(DriveT, SetDevice, TargetP^);{ !!Restore Drive parameters!! }
    End;
    SetLogicalDrive(OldDriveS);
  End;
  If PScr <> Nil Then
    Dispose(PScr, Done);
  If PDevice <> Nil Then
    Dispose(PDevice, Done);
  WriteLn('Thanks for using CopyDisk');
  Halt;
End;

Procedure Init;
Var
  XMM_Ret : LongInt;
  Ver : String[4];
  Sectors : Word;

  Function SearchDriveSize(Sectors : Word) : Boolean;
  Var
    Found : Boolean;
    SearchDrive : Byte;
  Begin
    Found := False;
    SearchDrive := 1;
    DeviceP^.SpecFunc := 0;
    While (SearchDrive <= FloppyDrives) And Not Found Do Begin
      GenIoCtlReq(SearchDrive, GetDevice, DeviceP^);
      Found := DeviceP^.Sectors = Sectors;
      If Not Found Then Inc(SearchDrive);
    End;
    If Found Then Begin
      DriveS := SearchDrive;
      DriveT := SearchDrive;
      DiskType := 0;
      Repeat
        Inc(DiskType);
      Until (LongInt(Sectors)*DeviceP^.BytesSector=DiskSizeList[DiskType].C);
    End;
    SearchDriveSize := Found;
  End;

  Procedure SearchSize;
  Var
    i : Byte;
    Found : Boolean;
    Sectors : Word;
  Begin
    i := Pred(DiskTypes);
    Found := False;
    While (i > 0) And Not Found  Do Begin
      Sectors := DiskSizeList[i].DP[16]+DiskSizeList[i].DP[17] Shl 8;
      Found := SearchDriveSize(Sectors);
      Dec(i);
    End;
    If Not Found Then
      Abort('Can''t find any High Density Drives', $FF);
  End;

  Function GetDrive(Drive : Byte) : Byte; Assembler;
  { Returns no of phys. Drives in System
    Param  0  Ret floppydrive, 80h Ret Harddrive  }
  Asm
    MOV AH, 08
    MOV DL, Drive
    INT 13h
    MOV AL, DL
  End;


  Procedure CheckDrive(Drive : Byte);
  Var DeviceInfo : Word;
  Begin
    DeviceInfo := GetDeviceInfo(Drive);
    If DeviceInfo And $8000 = $8000 Then
      Abort('Can''t acces an ASSIGNed or SUBSTed drive', $FF);
    If DeviceInfo And $1000 = $1000 Then
      Abort('Can''t acces a network drive', $FF);
    If RemovableDevice(Drive) <> 0 Then
      Abort(ExtendedError($F)+Errtxt1, $FF);
  End;

Var
  Date : String[11];
  MonthIdx, Error  : Integer;
  CountryInfo : TCountry;
Begin
  GetIntVec($23, int23);
  ExitProcPtr := ExitProc;                  { Setup for Exit }
  ExitProc := @CopyDiskExitProc;
  SetIntVec($23, ExitProc);
  PScr := New(PTTY_Msg, Init);
  VideoModeC := GetVideoMode(VideoMode);
  GetCountryInfo(CountryInfo);
  Date := StrPas(CompiledDate);
  If CountryInfo.DateFormat = 0 Then Begin
    Date := Copy(Date, 4, 2) + ' ' + Date;
    Delete(Date, 7, 3);
  End;
  Val(Copy(Date, 4, 2), MonthIdx, Error);
  Delete(Date, 4, 2);
  Insert(Month[MonthIdx], Date, 4);
  If Date[1] = '0' Then Delete(Date, 1, 1);
  Version := Version + ',  '+ Date;
  PScr^.Welcome(Version, CPUStr[CPUType]);
  CheckDosVersion;
  If Not Verify Then
    GetVerify(Verify);                         { DOS VERIFY Settings }
  FloppyDrives := GetDrive(0);
  If FloppyDrives = 0 Then
    Abort('No diskette drive', $FF);
  New(DeviceP);
  FillChar(DeviceP^, SizeOf(DeviceParams), 0);
  DevicePSize := SizeOf(DeviceParams)-(SizeOf(DeviceP^.TrackLayout)+2);
  If FileNo[1]=0 Then Begin
    SearchSize;
    CheckDrive(DriveS);
  End
  Else Begin
    DriveS := Ord(UpCase(ParamString[FileNo[1]]^[1]))-64; { Logical. Drive 1 = A: }
    CheckDrive(DriveS);
    If FileNo[2]=0 Then DriveT := DriveS
    Else Begin
      DriveT := Ord(UpCase(ParamString[FileNo[2]]^[1]))-64; { Logical Drive 1 = A: }
      CheckDrive(DriveT);
    End;
  End;
   { One Drive present and assigned as B: }
  OldDriveS := Lo(GetLogicalDrive(DriveS));
  If (FloppyDrives = 1) Then Begin
    { Assigned as A, need as B }
    If (OldDriveS=1) And (DriveS=2) Then
      DriveS := Lo(SetLogicalDrive(DriveS));
    { Assigned as B, need as A }
    If (OldDriveS=2) And (DriveS=1) Then
      DriveS := Lo(SetLogicalDrive(DriveS));
    DriveT := DriveS;
  End;
  { QueryIOCTL Only works with DOS 5+, Bug in OS/2 2.0, Odder WAS ?}
  If DosVer >= $500 Then
    If Not (QueryIOCTL(DriveS,ReadTrack) And QueryIOCTL(DriveT,WriteTrack))Then
      Abort('IO-CTL Not supported, (Are you running OS/2 ???)', ExtendedDosError);
  GetOptinion;
  If FullScreen Then Begin
    Dispose(PScr, Done);
    PScr := New(PFull_Msg, Init);
    PScr^.Welcome(Version, CPUStr[CPUType]);
  End;
  PDevice := New(PPhysDevice, Init);
  PScr^.SetDrives(Chr(DriveS+64), Chr(DriveT+64));
  tSource[Length(tSource)-1] := Chr(DriveS+64);
  tTarget[Length(tTarget)-1] := Chr(DriveT+64);
  tRemoveSource[26] := Chr(DriveS+64);
  tRemoveTarget[26] := Chr(DriveT+64);
  tRemoveDisk[28]  := Chr(DriveS+64);
  GetMem(SourceP, DevicePSize);
  FillChar(SourceP^, DevicePSize, 0);
  GenIoCtlReq(DriveS, GetDevice, SourceP^);  { Save Source DeviceP }
  ChangeLineSupport[DriveS] := Boolean(SourceP^.DeviceAttr Shr 1); { Changeline supported }
  If DriveT <> DriveS Then Begin
    GetMem(TargetP, DevicePSize);
    FillChar(TargetP^, DevicePSize, 0);
    GenIoCtlReq(DriveT, GetDevice, TargetP^);  { Save Target DeviceP }
    ChangeLineSupport[DriveT] := Boolean(TargetP^.DeviceAttr Shr 1); { Changeline supported }
  End
  Else
    TargetP := SourceP;
  DriveParamsSaved := True;
  WriteLn;
  If UseXms And XMM_Installed Then Begin
    Ver := PScr^.HexWord(Word(XMM_Version));
    While (Ver[1] = '0') And (Length(Ver) > 1) Do Delete(Ver, 1, 1);
    Insert('.', Ver, 2);
    If Not FullScreen Then Begin
      tText := 'XMS Version ' + Ver + ' detected.'#13#10;
      PScr^.Prompt(ptText);
      PScr^.NewLine;
    End;
    FreeExtended := XMM_QueryLargestFree;   { Free Memory in Kb }
  End;
  SwapToXMS := FreeExtended > 0;
End;

Function CmpW(P1, P2 : Pointer; Len : Word) : Boolean; Assembler;
Asm
     PUSH  DS
     MOV   CX, Len
     SHR   CX, 1
     LDS   SI, P1
     LES   DI, P2
     CLD
     REPE  CMPSW
     JNE   @1
     MOV   AL, 0
     JMP   @2
@1:  MOV   AL, 1
@2:  POP   DS
End;

Procedure InsertDisk(Drive: Byte; Writing, B : Boolean);
Var ChangeLine : Boolean;
Begin
  If (Alarm <> sSilence) And B Then PScr^.Beep(bpError);
  If ChangeLineSupport[Drive] And UseChangeLine Then Begin
    Repeat
      ChangeLine := ChLine(Drive-1);
      If Not Writing Then
        ChangeLine := Not ChangeLine;  { Vend ChangeLine }
    Until ChangeLine Or (PScr^.Continue In [ctEnterSpace, ctQuit]);
  End
  Else
    Repeat
      { nothing }
    Until PScr^.Continue In [ctEnterSpace, ctQuit];
  If PScr^.Continue=ctQuit Then
    Abort('', 0);
End;

Function WriteError(Drive:Byte; Var n:Byte; IODir:Boolean; Var Cont:ContType) : Boolean;
Var
  Status, DiskOk : Boolean;
  ExError : Byte;
  RWBlockTemp : ReadWriteBlock;
  Device : ^DeviceParams;
Begin
  ExError := ExtendedDosError;
  Status := False;
  DiskOk := False;
  Case ExError Of
    DriveNotReady : Begin
      Cont := PScr^.Continue;
      PScr^.ClearLine;
      tErrorPrompt := tNewDisk;
      If Not (ChangeLineSupport[Drive] And UseChangeLine) Then
        Insert(' and Press Enter', tErrorPrompt, 16);
      PScr^.Error(ExError);
      New(Device);
      Repeat
        PScr^.Prompt(ptErrorPrompt);
        InsertDisk(Drive, False, True);
        PScr^.ClearError;
        PScr^.Beep(bpNone);
        PScr^.ClearLine;
        Device^.SpecFunc := 1;
        GenIoCtlReq(Drive, GetDevice, Device^);
        Status := (Device^.Sectors < DeviceP^.Sectors) And Not ForcedFormat;
        If IoDir And Status And Not Boolean(ExtendedDosError) Then Begin
          PScr^.Prompt(ptDiskTypeMisMatch);
          InsertDisk(Drive, True, False);
          PScr^.ClearLine;
        End
        Else
          DiskOk := True;
      Until DiskOk;
      If Not Status And (ExtendedDosError <> NotFormatted) Then Begin
        FillChar(RWBlockTemp, SizeOf(RWBlock), 0);
        RWBlockTemp.Buffer := Buf[BufId+1];
        RWBlockTemp.Sectors := DeviceP^.SectorsTrack;
        GenIoCtlReq(Drive, ReadTrack, RWBlockTemp);
        Status := CMPW(Buf[1], RWBlockTemp.Buffer, TrackSize);
        Dec(n, Ord(Not Status));
      End
      Else
        Status := ExtendedDosError = NotFormatted;
      Dispose(Device);
    End;
    WriteProtected : Begin  { Disk WP }
        PScr^.ClearLine;
        PScr^.Error(ExError);
        tErrorPrompt :=  tCorrect;
        If Not (ChangeLineSupport[Drive] And UseChangeLine) Then
          Insert(' and Press Enter,', tErrorPrompt, 9);
        PScr^.Prompt(ptErrorPrompt);
        InsertDisk(Drive, True, True);
        PScr^.ClearError;
        PScr^.Beep(bpNone);
        PScr^.ClearLine;
        If ChangeLineSupport[Drive] And UseChangeLine Then
          InsertDisk(Drive, False, False);
        Dec(n);
    End;
    DiskDataError, SectorNotFound, NotFormatted : Begin      { CRC DATA Error / Sector not Found / General failure}
      If Ignore Then Begin
        n := 1;
        Cont := ctIgnore;
      End
      Else Begin
        PScr^.ClearLine;
        PScr^.Error(ExError);
        PScr^.Prompt(ptRetryAbortIgnore);
         If Alarm <> sSilence Then PScr^.Beep(bpError);
         Repeat
           MotorOn(Drive-1);            { Keep the disk motor running }
           Cont := PScr^.Continue;
         Until Cont In [ctRetry, ctQuit, ctIgnore, ctAlways];
         Case Cont Of
           ctQuit : Abort('', 0);
           ctRetry : Dec(n);
           ctIgnore : n := 1;
           ctAlways : Begin
                         n := 1;
                         Cont := ctIgnore;
                         Ignore := True;
                       End;
         End;
         PScr^.ClearError;
         PScr^.Beep(bpNone);
      End;
    End;
  End;
  PScr^.ClearLine;
  ExtendedDosError := ExError;
  WriteError := Status;
End;

Procedure CheckQuit;
Begin
  If PScr^.Continue=ctQuit Then
    Halt(0);
End;


Procedure RecoverTrack(Drive : Byte; Command : Word; N : LongInt);
Var
  RWBlockTemp : ReadWriteBlock;
Begin
  Move(RWBlock, RWBlockTemp, SizeOf(RWBlock));
  With RWblock Do Begin
    PScr^.CurCopied(Command=ReadTrack, Track, Head, N);
    Sectors := 1;                      { Read 1 sector }
    For FirstSector := 0 To Pred(DeviceP^.SectorsTrack) Do Begin
      GenIoCtlReq(DriveS, Command, RWBlock);
      Inc(LongInt(Buffer), DeviceP^.BytesSector);
      Inc(N, DeviceP^.BytesSector);
      If ExtendedDosError <> 0 Then Begin
        PScr^.CurCopied(Command=ReadTrack, Track, Head, N);
        Inc(BadSectors);
      End;
      CheckQuit;
      PScr^.CurCopied(Command=ReadTrack, Track, Head, N);
    End;
  End;
  Move(RWBlockTemp, RWBlock, SizeOf(RWBlock));
End;

Procedure ReadWriteTrack(Drive:Byte; Command:Word; n:Byte);
{ Read/Write a Track with sector slide }
Const
  Offs : Word = 0;
Var
  SS : Word;
  RWBlockTemp : ReadWriteBlock;
Begin
  If ((DiskSizeList[DiskType].SH=0) And (DiskSizeList[DiskType].ST=0)) Or
  SlowRW Or (Writing And Skewing) Then
    GenIoCtlReq(Drive, Command, RWBlock)
  Else Begin
    If ProtectedMode Then
      Inc(Offs, n);
    SS := 0;
    Move(RWBlock, RWBlockTemp, SizeOf(RWBlock));    { Save Params }
    With RWBlock Do Begin
      With DiskSizeList[DiskType] Do
        FirstSector := (Head*SH+Track*(SH+ST)+Offs) Mod DeviceP^.SectorsTrack;
      Sectors := (Sectors-FirstSector);
      Inc(LongInt(Buffer), FirstSector*DeviceP^.BytesSector);
      Repeat
        GenIoCtlReq(Drive, Command, RWBlock);
        Inc(SS, Sectors);
        If ExtendedDosError = 0 Then Begin
          If Sectors < RWBlockTemp.Sectors Then Begin
            FirstSector := DeviceP^.SectorsTrack-(FirstSector+Sectors);
            Sectors := DeviceP^.SectorsTrack-Sectors;
            Buffer := RWBlockTemp.Buffer;
          End;
        End;
      Until (SS = DeviceP^.SectorsTrack) Or (ExtendedDosError<>0);
    End;
    Move(RWBlockTemp, RWBlock, SizeOf(RWBlock));
  End;
End;

Procedure FatSelection(Command : Word; n : Byte);
Var
  DS, Cluster : Word;
  InUse, NotInUse : Boolean;
  P : Pointer;
Begin
  NotInUse := False;
  With RWBlock Do Begin
    FirstSector := 0;
    Sectors := 0;
    While Sectors+FirstSector < DeviceP^.SectorsTrack Do Begin
      Repeat
        DS := DosSector(DeviceP, Track, Head, FirstSector+Sectors);
        Cluster := DosSectorToCluster(DeviceP, DS);
        Cluster := PDevice^.NextCluster(Fat, Cluster);
        InUse := (Cluster <> 0) And (Cluster <> BAD);
        If InUse Then Begin
          Inc(Sectors);
          NotInUse := False;
        End
        Else If NotInUse Then
          Inc(FirstSector);
      Until (Sectors+FirstSector = DeviceP^.SectorsTrack) Or (Not InUse And Not NotInUse);
      If Sectors = DeviceP^.SectorsTrack Then Begin
        NotInUse := False;
        ReadWriteTrack(DriveS, Command, n);
      End
      Else Begin
        NotInUse := True;
        If Sectors <> 0 Then Begin
          P := Buffer;
          Inc(Longint(Buffer), FirstSector*DeviceP^.BytesSector);
          GenIoCtlReq(DriveS, Command, RWBlock);
          Buffer := P;
        End;
        Inc(FirstSector, Sectors);
        Sectors := 0;
      End;
    End;
  End;
End;

Procedure ReadDisk(Var Error : ErrorType);

Var
  NumRead, XMM_Ret, DestOffset : LongInt;
  Io_Error, n, BufIdx : Byte;
  BeginSwapToDisk, ExitRead, InUse, NotInUse : Boolean;
  Cont : ContType;

Begin
  Badsectors := 0;
  Error := eNone;
  ExitRead := False;
  BeginSwapToDisk := Not SwapToXMS;
  DestOffset := 0;
  NumRead := 0;
  BufIdx := 1;
  With RWBlock Do Begin
    FirstSector := 0;
    Sectors := DeviceP^.SectorsTrack;
    Track := 0;
    While (Track < DeviceP^.Tracks) And Not ExitRead Do Begin
      Head := 0;
      While (Head < DeviceP^.Heads) And Not ExitRead Do Begin
        CheckQuit;
        Buffer := Buf[BufIdx];
        n := 0;
        Repeat
          PScr^.CurCopied(True, Track, Head, NumRead);
          If FatSelect And Boolean(Track) Then
            FatSelection(ReadTrack, 0)
          Else
            ReadWriteTrack(DriveS, ReadTrack, 0);
          If ExtendedDosError <> 0 Then Begin
            ExitRead := WriteError(DriveS, n, False, Cont) Or ((Cont = ctQuit) And StartCopy);
            If Cont = ctIgnore Then
              RecoverTrack(DriveS, ReadTrack, NumRead);
            Inc(n);
          End;
        Until (ExtendedDosError=0) Or (n=2) Or ExitRead;
        If BufIdx < Pred(BufId) Then Inc(BufIdx) { One buffer is reserved as }
        Else Begin                               { XMSBuffer/diskbuffer }
          If BufIdx = BufId Then Begin           { Write last buffer to disk or XMS }
            If Not BeginSwapToDisk Then Begin
              XMM_Ret := MoveCon2XMM(Buf[BufId], DestOffset, TrackSize);
              If XMM_Ret >= 0 Then
                Inc(DestOffset, TrackSize);
              BeginSwapToDisk := XMSAllocSize-ExtMemMove.DestOffset<TrackSize;
            End
            Else Begin
              BlockWrite(SwapF, Buf[BufIdx]^, TrackSize);
              If IOResult = 101 Then Abort('Disk full', 101);
            End;
          End Else
            Inc(BufIdx);                         { Setup for last buffer }
        End;
        Inc(NumRead, TrackSize);
        Inc(Head);
      End;
      Inc(Track);
    End;
    If Not ExitRead Then Begin
      PScr^.CurCopied(True, Pred(Track), Pred(Head), NumRead);
      PScr^.NewLine;
      PScr^.NewLine;
    End;
  End;
  If ExitRead Then Error := eDiskChange;
  StartCopy := False;
End;

{Returns 0:No Error 1:Diskchange; 2:VerifyError}
Procedure WriteDisk(Var Error : ErrorType);

  { Rotates (slides) sectors n }
  Procedure SectorSlide(Var DP: DeviceParams; n : Byte);
  Var Temp : Array[1..72] Of Word;
  Begin
    With DP Do Begin
      n := DP.SectorsTrack-n;
      Move(TrackLayout, Temp, SectorsTrack*4);
      Move(TrackLayout[1+n*2], TrackLayout, (SectorsTrack-n)*4);
      Move(Temp, TrackLayout[1+(SectorsTrack-n)*2], n*4);
    End;
  End;

Var
  NumWrit, XMM_Ret, SourceOffset : LongInt;
  BufIdx, n : Byte;
  FormatError, CmpError, BeginSwapToDisk, ExitWrite : Boolean;
  Cont : ContType;
  s : String;
  BootSector : PBootSector;
  SS, FS : Word;
  InUse, NotInUse : Boolean;
  DeviceSlide : ^DeviceParams;
Begin
  Badsectors := 0;
  Error := eNone;
  ExitWrite := False;
  FillChar(FVBlock, SizeOf(FVBlock), 0);  { Init SpecFunc, Track, Head = 0 }
  FillChar(RWBlock, SizeOf(RWBlock), 0);
  RWBlock.Sectors := DeviceP^.SectorsTrack;
  If Not ForcedFormat And (ExtendedDosError <> NotFormatted) Then Begin
    If DSizeT = DSizeS Then
      DSizeT := -1;                     { Skip determination of Disksize }
    RWBlock.Buffer := Buf[BufId+1];
    Repeat
      CheckQuit;
      GenIoCtlReq(DriveT, ReadTrack, RWBlock);
      Case ExtendedDosError Of
        DriveNotReady : ExitWrite := WriteError(DriveT, n, False, Cont);
        { Some factory preformatted disks, return error SectorNotFound }
        0  : Begin
               BootSector := @BootSectorData;
               Move(Buf[BufId+1]^, BootSector^, 512);
               With BootSector^ Do Begin
                 DSizeT := LongInt(Sectors)*BytesSector;
                 Dec(DSizeT, (FatSectors*Fats+1+RootDirEnt Div 16)*BytesSector);
               End;
             End;
      End;
    Until (ExtendedDosError <> DriveNotReady) Or (DSizeT = -1);
  End;
  Format := ((DSizeS<>DSizeT) Or (ExtendedDosError In [SectorNotFound, NotFormatted])) Or ForcedFormat;
  If SwapToDisk Then Reset(SwapF, 1);
  BeginSwapToDisk := Not SwapToXMS;
  SourceOffset := 0;
  PScr^.FormatStatus(Format, Skewing);
  If Format Then Begin
    If Skewing Then Begin
      New(DeviceSlide);
      Move(DeviceP^, DeviceSlide^, SizeOf(DeviceParams));
    End;
    If (DSizeT < DSizeS) And (DSizeT <> -1) Then Begin
      DeviceP^.SpecFunc := $05;          { Tell DOS to ignore ParameterBlock}
      GenIoCtlReq(DriveT, SetDevice, DeviceP^);   { Vigtig }
    End;
  End;
  PScr^.VerifyStatus(Verify);
  BufIdx := 0;
  NumWrit := 0;
  CmpError := False;
  With RWBlock Do Begin
    FirstSector := 0;
    Sectors := DeviceP^.SectorsTrack;
    Track := 0;
    While (Track < DeviceP^.Tracks) And Not ExitWrite Do Begin
      Head := 0;
      While (Head < DeviceP^.Heads) And Not ExitWrite Do Begin
        CheckQuit;
        If Format Then Begin
          If Skewing Then
            GenIoctlReq(DriveT, SetDevice, DeviceSlide^);
          n := 0;
          Move(RWBlock, FVBlock, SizeOf(FVBlock));
          Repeat
            PScr^.CurCopied(False, Track, Head, NumWrit);
            GenIoCtlReq(DriveT, FormatTrack, FVBlock);
            If ExtendedDosError <> 0 Then
              ExitWrite := WriteError(DriveT, n, True, Cont);
            FormatError := Boolean(ExtendedDosError);
            If FormatError Then Inc(n);
          Until Not FormatError Or (n = 2) Or ExitWrite;
          If Skewing Then
             GenIoctlReq(DriveT, SetDevice, DeviceP^);
        End;
        If Not ExitWrite Then Begin
          If BufIdx < BufId Then Inc(BufIdx);
          If BufIdx = BufId Then Begin
            If Not BeginSwapToDisk Then Begin       { Move from Xtended Mem }
              XMM_Ret := MoveXmm2Con(SourceOffset, Buf[BufId], TrackSize);
              If XMM_Ret >= 0 Then Inc(SourceOffset, TrackSize);
              BeginSwapToDisk := XMSAllocSize-ExtMemMove.SourceOffset<TrackSize;
            End
            Else
              BlockRead(SwapF, Buf[BufIdx]^, TrackSize); { Read into last buffer}
          End;
          Buffer := Buf[BufIdx];
          n := 0;
          Repeat
            PScr^.CurCopied(False, Track, Head, NumWrit);
            If FatSelect And Boolean(Track) Then
              FatSelection(WriteTrack, 0)
            Else
              ReadWriteTrack(DriveS, WriteTrack, 0);
            If ExtendedDosError <> 0 Then Begin
              ExitWrite := WriteError(DriveT, n, True, Cont);
              If Cont = ctIgnore Then Begin
                RecoverTrack(DriveS, WriteTrack, NumWrit);
                If ExtendedDosError In[DiskDataError, SectorNotFound] Then Error := eVerify;
              End;
            End
            Else Begin
              If Verify Then Begin
                Buffer := Buf[BufId+1];
                If FatSelect And Boolean(Track) Then
                  FatSelection(ReadTrack, 1)
                Else
                  ReadWriteTrack(DriveS, ReadTrack, 1);
                CmpError := CmpW(Buf[BufIdx], Buf[BufId+1], TrackSize);
              End;
            End;
            Inc(n);
          Until (ExtendedDosError=0) Or (n=2) Or ExitWrite;
          If (ExtendedDosError In[DiskDataError, SectorNotFound]) And Not ExitWrite Then Begin
            If CmpError Then Begin
	      PScr^.Prompt(ptVerifyError);
              PScr^.NewLine;
            End;
            Error := eVerify;                           { Ret Error Code }
          End;
          Inc(NumWrit, TrackSize);
          If (Head = 0) And Skewing And Format Then
            SectorSlide(DeviceSlide^, DiskSizeList[DiskType].SH);
          Inc(Head);
        End;
      End;
      Inc(Track);
      If Skewing And Format Then
        SectorSlide(DeviceSlide^, DiskSizeList[DiskType].ST);
    End;
    If Not ExitWrite Then Begin
      PScr^.CurCopied(False, Pred(Track), Pred(Head), NumWrit);
      PScr^.NewLine;
      PScr^.NewLine;
    End;
  End;
  If FullScreen Then PScr^.FormatStatus(ForcedFormat, False);
  If Format And (DSizeT < DSizeS) And (DSizeT<>-1) Then Begin
    DeviceP^.SpecFunc := $04;
    GenIoCtlReq(DriveT, SetDevice, DeviceP^);   { Vigtig }
    If SkeWing Then Dispose(DeviceSlide);
  End;
  If ExitWrite Then Error := eDiskChange;
End;

Procedure ShowFat(BT : BarType);  { 20/7-94}

  Function ClusterToSector(C : Word) : Word;
  Begin
    ClusterToSector := LongInt(C) * DeviceP^.Sec_Cluster;
  End;

Var
  S, Sector, Cluster, i : Word;
  Clusters : Array[0..2] Of Word;
  Bar : BarType;
  {  ClustersInUse, ClustersNotInUse, ClustersBad ,: Word; }
Begin
  PScr^.ShowBar(0, BT);
  FillChar(Clusters, 6, 0);
  Sector := GetSystemSectors(DeviceP);
  PScr^.ShowBar(Sector,  bInUse);
  While Sector < DeviceP^.Sectors Do Begin
    Cluster := PDevice^.NextCluster(Fat, DosSectorToCluster(DeviceP, Sector));
    If (Cluster <> 0) And (Cluster <> BAD) Then Begin  { Cluster in Use }
      For i := 1 To 2 Do
        If Clusters[i] > 0 Then Begin
          S := ClusterToSector(Clusters[i]);
          PScr^.ShowBar(S, BarType(i+2));
          Clusters[i] := 0;
        End;
      Inc(Clusters[0]);
    End
    Else Begin
      If Clusters[0] > 0 Then Begin
        S := ClusterToSector(Clusters[0]);
        PScr^.ShowBar(S, BT);
        Clusters[0] := 0;
      End;
      If Cluster = BAD Then
        Inc(Clusters[2])
      Else
        Inc(Clusters[1]);
    End;
    Inc(Sector, DeviceP^.Sec_Cluster);
  End;
  For i := 0 To 2 Do
  If Clusters[i] > 0 Then Begin
    If i = 0 Then
      Bar := BT
    Else
      Bar := BarType(i+2);
    S := ClusterToSector(Clusters[i]);
    PScr^.ShowBar(S,  Bar);
  End;
End;

Procedure ShowFileNames;
Var
  DirInfo : DirEntryRec;
  MaxLines,  i, DirLine : Word;
  VolumeLabel : Str11;
Begin
  MaxLines := PScr^.ClearFileList;
  PDevice^.RootDir_Io(RootDir^, cRead);
  i := 0;
  VolumeLabel := '';
  While (RootDir^[i] <> 0) And (VolumeLabel = '') Do Begin
    If RootDir^[i] <> $E5 Then Begin
      Move(RootDir^[i], DirInfo, 32);
      If DirInfo.Attr And VolumeId = VolumeId Then Begin
        Move(DirInfo.Name, VolumeLabel[1], SizeOf(DirInfo.Name));
        VolumeLabel[0] := Char(SizeOf(DirInfo.Name));
      End;
    End;
    Inc(i, SizeOf(DirInfo));
  End;
  If DosVer >= $400 Then Begin
    GenIoCtlReq(DriveS, GetMediaId, MediaBlock);
    If ExtendedDosError = UnknownMediaType Then
      MediaBlock.SerialNum := 0;
  End;
  PScr^.VolumeSerial(VolumeLabel, MediaBlock.SerialNum);
  If MaxLines > 0 Then Begin
    i := 0;
    DirLine := 0;
    While (RootDir^[i] <> 0) And (DirLine < MaxLines) Do Begin
      If RootDir^[i] <> $E5 Then Begin
        Move(RootDir^[i], DirInfo, SizeOf(DirInfo));
        If DirInfo.Attr And VolumeId <> VolumeId Then Begin
          PScr^.AddFileName(DirInfo);
          Inc(DirLine);
        End;
      End;
      Inc(i, SizeOf(DirInfo));
    End;
  End;
End;

Procedure SetupSwapFile;
Var
  SwapDisk, Io_Error : Byte;
  Dir : DirStr;
  Name : NameStr;
  Ext : ExtStr;
Begin
  If SwapDir = '' Then Begin
    SwapDir := GetEnv('TMP');
    If SwapDir = '' Then SwapDir := GetEnv('TEMP');
    If ((SwapDir<>'') And (SwapMem>DiskFree(Ord(SwapDir[1])-64))) Or (SwapDir='')
    Then SwapDir := 'C:\';
  End;
  While SwapDir[Length(SwapDir)] <> '\' Do
    SwapDir := SwapDir + '\';
  If SwapFName = '' Then Begin
    Fsplit(ParamString[0]^, Dir, Name, Ext);
    SwapFname := Name + '.SWP';
  End;
  Assign(SwapF, SwapDir + SwapFname);
  SwapDisk := Ord('C')-64;
  Repeat
    ReWrite(SwapF, 1);
    Io_Error := IoResult;
    Case Io_Error Of
      3 : If RemovableDevice(SwapDisk) = 1 Then
            Assign(SwapF, Chr(SwapDisk+64) + ':\' + SwapFname)
          Else
            Inc(SwapDisk);
    End;
  Until Io_Error = 0;
End;

Procedure SetVolumeLabel;  { 27-7-94 }
Const
  NoName : String[11] = 'NO NAME';
  SysType : String[8] = 'FAT12';
Var
  i : Word;
  DirEntry : DirEntryRec;
  Ftime : Longint;
  DT : DateTime;
  Offset, sec100 : Word;
  VolumeLabel : Str11;

Begin
  MediaBlock.InfoLevel := 0;
  GenIoCtlReq(DriveT, GetMediaId, MediaBlock);
  FillChar(MediaBlock.VolLabel, SizeOf(MediaBlock.VolLabel), #32);
  PScr^.GetVolumeSerial(VolumeLabel, MediaBlock.SerialNum);
  If (Copy(VolumeLabel, 1, Length(tUnlabeled))  = tUnlabeled) Then
    VolumeLabel := NoName;
  Move(VolumeLabel[1],  MediaBlock.VolLabel, Length(VolumeLabel));
  i := 0;
  Move(RootDir^[i], DirEntry, SizeOf(DirEntry));
  With DeviceP^ Do
    While (i<RootDirEnt*SizeOf(DirEntry)) And (RootDir^[i]<>0)
    And ((DirEntry.Attr And VolumeId) <> VolumeId) Do Begin
      Move(RootDir^[i], DirEntry, SizeOf(DirEntry));
      If (DirEntry.Attr And VolumeId) <> VolumeId Then
        Inc(i, SizeOf(DirEntry));     { Scan root for #0 in Name }
    End;
  If VolumeLabel <> NoName Then Begin
    FillChar(DirEntry, SizeOf(DirEntry), 0);
    Move(MediaBlock.VolLabel, DirEntry.Name, SizeOf(DirEntry.Name));
    DirEntry.Attr := VolumeId;
    GetTime(DT.Hour, DT.Min, DT.Sec, sec100);
    GetDate(DT.Year, DT.Month, DT.Day, sec100);
    PackTime(DT, FTime);
    Move(Ftime, DirEntry.Time, 4);
  End Else
    If DirEntry.Attr And VolumeId = VolumeId Then
      DirEntry.Name[0] := #$E5;
  Move(DirEntry, RootDir^[i], SizeOf(DirEntry));
  PDevice^.RootDir_Io(RootDir^, cWrite);
  If MediaBlock.FileSysType <> SysType Then
    Move(SysType[1], MediaBlock.FileSysType, Length(SysType));
  GenIoCtlReq(DriveT, SetMediaId, MediaBlock);     { update of boot record }
End;

Procedure RemoveBadEntrys;   { 11/8-94 }
Const GoodMarks : Array[0..1, 0..1] Of Byte = (($00,$F0), ($0F,$00));
  { Even Cluster Odd Cluster } { 0 Start Mark, 1 End Mark }
Var
  Cluster, Sector, OffsetInFat, NextCluster, n : Word;
  BadClusters : Boolean;
Begin
  BadClusters := False;
  For Sector := GetSystemSectors(DeviceP) To DeviceP^.Sectors Do Begin
    Cluster := DosSectorToCluster(DeviceP, Sector);
    NextCluster := PDevice^.NextCluster(Fat, Cluster);
    If NextCluster = BAD Then Begin
      OffsetInFat := Cluster * 3 Div 2;
      n := Cluster Mod 2;        { 0 = Even }
      Fat^[OffsetInFat]   := Fat^[OffsetInFat]   And GoodMarks[n, 0];
      Fat^[OffsetInFat+1] := Fat^[OffsetInFat+1] And GoodMarks[n, 1];
      BadClusters := True;
    End;
  End;
  If BadClusters Then Begin
    PScr^.ClearLine;
    tText := 'Updating File Alloction Tables';
    PScr^.Prompt(ptText);
    PDevice^.Fat_Io(0, Fat^, Fat1, cWrite);
    PDevice^.Fat_Io(0, Fat^, Fat2, cWrite);
    PScr^.NewLine;
  {  ShowFat(bInUse);}
  End;
End;

Procedure TransferDisk;
Var
  ReadTime, WriteTime : LongInt;
  Device : ^DeviceParams;
  Status, DiskOk, DriveChanged : Boolean;
  Cont : ContType;
Begin
  PDevice^.Fat_Io(0, Fat^, Fat1, cRead);
  Writing := False;
  If FatSelect Then
    ShowFat(bInUse)
  Else
    PScr^.InitBar(bEmpty);
  ReadTime := ReadSystemTimer;
  ReadDisk(ErrorRes);
  If ErrorRes = eNone Then Begin
    ReadTime := ReadSystemTimer-ReadTime;
    Repeat
      New(Device);
      DiskOk := False;
      Repeat
        If DiskId = 1 Then
          ChangeDisk(DriveT, ptRemoveSource, DriveChanged)
        Else
          ChangeDisk(DriveT, ptRemoveTarget, DriveChanged);
        If DriveChanged Then Begin
          Dispose(Device);
	  Exit;
        End;
        PScr^.NewLine;
        Device^.SpecFunc := 1;
        GenIoCtlReq(DriveT, GetDevice, Device^);
        Status := (Device^.Sectors*3 Div 2 < DeviceP^.Sectors) And Not ForcedFormat;
        If Status And Not Boolean(ExtendedDosError) Then Begin
          PScr^.Prompt(ptDiskTypeMismatch);
          InsertDisk(DriveT, True, False);
          PScr^.ClearLine;
        End
        Else
          DiskOk := True;
      Until DiskOk Or (PScr^.Continue = ctQuit);
      If ExtendedDosError <> NotFormatted Then With Device^ Do
        DSizeT := LongInt(Sectors)*BytesSector;
      Dispose(Device);
      If PScr^.Continue = ctQuit Then
        Halt(0);
      WriteTime := ReadSystemTimer;
      PDevice^.SetDrive(DriveT);
      Repeat
        If FatSelect Then Begin
          ShowFat(bFull);
        End
        Else
          PScr^.InitBar(bFull);
        Writing := True;
        WriteDisk(ErrorRes);
        Writing := False;
        Cont := ctUnknown;
        Case ErrorRes Of
          eDiskChange : ;
          eVerify : Begin                { Verify Error }
                PScr^.ClearLine;
                PScr^.Prompt(ptErrorWrite);
                Repeat
                  Cont := PScr^.Continue;
                Until Cont In [ctYes, ctNo, ctQuit];
                PScr^.NewLine;
                PScr^.ClearLine;
              End;
        End;
        If (Cont = ctNo) Or (ErrorRes = eNone) Then Begin
          WriteTime := ReadSystemTimer - WriteTime;
          If LabelChanged Then
            SetVolumeLabel;
          If FatSelect Then
            RemoveBadEntrys;
          ShowTransferTime(ReadTime+WriteTime);
          Inc(DiskId);
          ReadTime := 0;
          ErrorRes := eNone;
        End;
      Until ErrorRes = eNone;
    Until DiskId > NoOfCopies;
  End;
End;

Procedure CopyAnother(Var Cont:ContType);
Begin
  If UseKeyboard Then Begin
    PScr^.NewLine;
    PScr^.ClearLine;
    PScr^.Prompt(ptCopyAnother);
    If Alarm <> sSilence Then PScr^.Beep(bpNewDisk);
    Repeat
      Cont := PScr^.Continue;
    Until Cont In [ctYes, ctNo, ctQuit];
    PScr^.NewLine;
    PScr^.NewLine;
  End;
End;

Var
  Continue : ContType;
  DriveChanged : Boolean;
Begin
  ErrorRes := eNone;
  Init;
  Repeat
    Continue := ctGoOn;
    DriveChanged := False;
    DiskId := 1;
    tText := tSource;
    Repeat
      If ErrorRes = eNone Then ChangeDisk(DriveS, ptRemoveTarget, DriveChanged);
      DeviceP^.SpecFunc := 1;
      GenIoCtlReq(DriveS, GetDevice, DeviceP^);  { Get Source DeviceP }
      Continue := PScr^.Continue;
    Until ((ExtendedDosError = 0) And Not DriveChanged) Or (Continue = ctQuit) ;
    PDevice^.SetDrive(DriveS);
    If Continue = ctQuit Then
      Halt(0);
    PScr^.NewLine;
    If TargetP^.Sectors < DeviceP^.Sectors Then
      Abort(Errtxt2, 1);
    With DeviceP^ Do Begin
      RealDSizeS := Sectors*LongInt(BytesSector);     { Phys DiskSize }
      DSizeS := RealDSizeS-(ResSectors+FatSectors*FATs+(RootDirEnt Div 16))*LongInt(BytesSector);
      DiskType := 0;
      While (DiskSizeList[DiskType].C <> RealDSizeS) And (DiskType < Disktypes) Do
        Inc(DiskType);
      If DiskType = DiskTypes Then
        Abort(ErrTxt3, $FF);
      TrackSize := SectorsTrack*BytesSector;
      Tracks := Sectors Div (Heads*SectorsTrack);
      PScr^.DiskStat(DiskType, Tracks, Heads, SectorsTrack);
    End;
    With DeviceP^ Do Begin
      SpecFunc := $04;
      InitTrackLayout(DeviceP^);
      GenIoCtlReq(DriveS, SetDevice, DeviceP^);   { Vigtig }
    End;
    If DriveT <> DriveS Then
      GenIoCtlReq(DriveT, SetDevice, DeviceP^);   { Vigtig }
    FillChar(RWBlock, SizeOf(RWBlock), 0); { Init af Specfunc & FirstSector }
    RWBlock.Sectors := DeviceP^.SectorsTrack;
    AllocMem;
    ShowFilenames;
    If SwapToDisk Then SetupSwapFile;
    PScr^.TempUse(DosAllocSize, XMSAlloc*1024, RealDSizeS-DosAllocSize-XMSAlloc*1024);
    TransferDisk;
    DeallocMem;
    If SwapToDisk Then Begin
      Close(SwapF);
      Erase(SwapF);
    End;
    CopyAnother(Continue);
  Until Continue In [ctQuit, ctNo];
End.
