{$G+,S-,R-,I-}
Unit CDTTY;

Interface

Uses
  Cnt_U,
  CDTCV,
  Dos,
  DosX,
  XCrt;

Type
  ContType = (ctQuit, ctGoOn, ctRetry, ctUnknown, ctIgnore, ctYes, ctNo,
              ctAlways, ctEnterSpace, ctNewDriveA, ctNewDriveB,
	      ctChangeLabel, ctSetup);
  BeepType = (bpNone, bpSource, bpTarget, bpNewDisk, bpError);
  BarType  = (bEmpty, bFull, bInUse, bNotInUse, bBAD);
  Action = (actRead, actWrite, actWaitAbortRetry);
  TPrompt = (ptNone, ptInsertSource, ptText, ptRemoveSource, ptRemoveTarget
              ,ptInsertTarget, ptInsertNewDisk, ptRemoveDisk,
              ptDiskTypeMisMatch, ptCorrect, ptRetryAbortIgnore, ptErrorPrompt,
              ptVerifyError, ptErrorWrite, ptCopyAnother, ptSourceAndTarget);
  TDiskType = (dtUnknown, dt180, dt360, dt720, dt1_2, dt1_44, dt2_88);
  Str11 = String[11];
  LH = Record
    Low,High : Char;
  End;
  PTTY_MSG = ^TTY_MSG;
  TTY_MSG = Object
    SourceDrive,
    TargetDrive : Char;
    SourceType,
    TargetType : TDiskType;
    LastKey : Word;
    Constructor Init;
    Destructor Done; virtual;
    Procedure Welcome(Version:String; CPUStr:String); virtual;
    Procedure ShowSyntax; virtual;
    Procedure SetDrives(SDrive,TDrive:Char); virtual;
    Procedure SetDiskTypes(SType, TType : TDiskType); virtual;
    Procedure Beep(BT:BeepType);
    Procedure Delay(ms:Word); virtual;
    Function  FReadKey:Char; virtual;
    Procedure NewLine; virtual;
    Procedure ClearLine; virtual;
    Procedure Error(E:Byte); virtual;
    Procedure ClearError; virtual;
    Procedure Prompt(Prm:TPrompt); virtual;
    Function  Continue:ContType; virtual;
    Function  ClearFileList : Word; virtual;
    Procedure AddFileName(Dir:DirEntryRec); virtual;
    Procedure TempUse(UseLowMem, UseXMS, UseDisk : LongInt); virtual;
    Procedure CurCopied(Reading:Boolean; T, H :Byte; N : LongInt); virtual;
    Procedure CurActivity(Act:Action); virtual;
    Procedure FormatStatus(F, S:Boolean); virtual;
    Procedure VerifyStatus(V:Boolean);  virtual;
    Procedure TransferTime(M, S:Byte); virtual;
    Procedure DiskStat(DT:Byte; Tracks, Heads, Sectors : Word); virtual;
    Procedure InitBar(BT : BarType); virtual;
    Procedure ShowBar(SS : Word; BT : BarType); virtual;
    Procedure VolumeSerial(VL : Str11; VSN : LongInt); virtual;
    Procedure GetVolumeSerial(Var VL : Str11; Var VSN : LongInt); Virtual;
    Function  HexWord(w:Word) : Str4;
  End;

Const
  AskedForQuit : Boolean = False;

Implementation


Constructor TTY_Msg.Init;
Begin
  SourceDrive := '@';
  TargetDrive := '@';
  SourceType := dtUnknown;
  TargetType := dtUnknown;
  LastKey := $0000;
End;

Destructor TTY_Msg.Done;
Begin
End;

Function TTY_Msg.HexWord(w: Word) : Str4;
Const
  hexChars: Array [0..$F] of Char = '0123456789ABCDEF';
Begin
  HexWord := hexChars[Hi(w) shr 4] + hexChars[Hi(w) and $F]
    + hexChars[Lo(w) shr 4] + hexChars[Lo(w) and $F];
End;

Procedure TTY_Msg.Welcome(Version, CPUStr :String );
Var F : Text;
Begin
  Assign(F, '');
  ReWrite(F);
  WriteLn(F, 'CopyDisk ', Version, ', 1992-94  Eugeni Bobrov');
  Close(F);
End;

Procedure TTY_Msg.GetVolumeSerial(Var VL: Str11; Var VSN : Longint);
Begin
End;


Procedure TTY_Msg.ShowBar(SS : Word; BT :BarType);
Begin
End;

Procedure TTY_Msg.InitBar(BT:BarType);
Begin
End;

Procedure TTY_Msg.ShowSyntax;
Var F : Text;
  Function Bool2Char(B : Boolean) : Char;
  Const Chars : Array[0..1] Of Char = ('-', '+');
  Begin
    Bool2Char := Chars[Ord(B)];
  End;

Begin
  Assign(F, '');  { a trick to force BIOS-Writes and disable }
  ReWrite(F);     { direct video addresing }
  WriteLn(F, 'Syntax :   COPYDISK [Options] [Source] [Options] [Target] [Options]'#13#10);
  WriteLn(F, '  Default Source is ', Chr(DriveS+64), ': ', DiskSizeList[DiskType].S, '  Options are:');
  WriteLn(F, '  /A{0..2}  Alarm when diskette change,                 default A',Ord(Alarm));
  Write  (F, '  /Bfname   Full path of buffer,                        default ');
  If SwapDir+SwapFname = '' Then
    WriteLn(F, '%TMP% or %TEMP%')
  Else
    WriteLn(F, SwapDir+SwapFname);
  WriteLn(F, '  /C{+|-}   Use diskette Change line                    default C',Bool2Char(UseChangeLine));
  WriteLn(F, '  /E{+|-}   Run Full Screen                             default E',Bool2Char(FullScreen));
  WriteLn(F, '  /F{+|-}   Format target diskette                      default F',Bool2Char(ForcedFormat));
  WriteLn(F, '  /FS{+|-}  FAT-select, copy only what DOS is using     default FS',Bool2Char(FatSelect));
  WriteLn(F, '  /H  |/?   Display this help screen');
  WriteLn(F, '  /I{+|-}   Ignore (CRC data error or Sector not found) default I',Bool2Char(Ignore));
  WriteLn(F, '  /K{+|-}   Use Keyboard                                default K',Bool2Char(UseKeyboard));
  WriteLn(F, '  /L{+|-}   Display volume Label                        default L',Bool2Char(ShowLabel));
  WriteLn(F, '  /M{value} Make multiple copies, (max 65535)           default M',NoOfCopies);
  WriteLn(F, '  /R{+|-}   Rotate sectors when formatting, enables /F  default R',Bool2Char(Skewing));
  WriteLn(F, '  /RS{+|-}  Disable sector skewing when reading/writing default RS',Bool2Char(SlowRW));
  Write  (F, '  /S:{Mode} Set default videomode                       default ');
  If VideoMode = '' Then
    WriteLn(F, 'DOS textmode')
  Else
    WriteLn(F, 'S:', VideoMode);
  WriteLn(F, '  /V{+|-}   Verify and compare while writing            default V',Bool2Char(Verify));
  WriteLn(F, '  /X{+|-}   Use Extended memory (XMS)                   default X',Bool2Char(UseXms));
  WriteLn(F, '  /W{0,1}   Write Setup to CopyDisk, 0 : Reset');
  Close(F);
End;

Procedure TTY_Msg.SetDrives(SDrive,TDrive:Char);
Begin
  SourceDrive := SDrive;
  TargetDrive := TDrive;
End;

Procedure TTY_Msg.SetDiskTypes(SType, TType : TDiskType);
Begin
  SourceType := SType;
  TargetType := TType;
End;

Procedure TTY_Msg.Beep(BT:BeepType);
Begin
  If Alarm = sAlarm Then
    Case BT Of
      bpNone   : BeepStop;
      bpSource : BeepStart(SuccessBeep);
      bpTarget : BeepStart(SmartBeep);
      bpError  : BeepStart(ErrorBeep);
      bpNewDisk: BeepStart(SimpleBeep);
    End
  Else Begin
    Case BT Of
      bpSource : Begin
                   Sound(2*880);
                   Delay(200);
                 End;
      bpTarget : Begin
                   Sound(880);
                   Delay(200);
                 End;
      bpError  : Begin
                   Sound(440);
                   Delay(200);
                   Sound(880);
                   Delay(200);
                 End;
      bpNewDisk: Begin
                   Sound(440);
                   Delay(200);
                 End;
    End;
    NoSound;
  End;
End;

Procedure TTY_Msg.Delay(ms:Word);
Begin
  xCrt.Delay(ms);
End;

Function TTY_Msg.FReadKey:Char; Assembler;
Asm
  MOV AX, 0C08h
  INT 21h
End;

Procedure TTY_Msg.NewLine;
Begin
  WriteLn;
End;

Procedure TTY_Msg.ClearLine;
Begin
  Write(#13, ' ':78,#13);
End;

Procedure TTY_Msg.Error(E:Byte);
Begin
  Write(ExtendedError(E), '.  ');
End;

Procedure TTY_Msg.ClearError;
Begin
  ClearLine;
End;

Procedure TTY_Msg.FormatStatus(F, S:Boolean);
Begin
  If F Then Begin
    Write('Formatting while copying');
    If S Then
      Write(',  Sectorshift ',DiskSizeList[DiskType].ST,':',DiskSizeList[DiskType].SH);
    WriteLn;
  End;
End;

Procedure TTY_Msg.VerifyStatus(V:Boolean);
Begin
  If V Then WriteLn('Verifying while writing');
End;

Procedure TTY_Msg.Prompt(Prm:TPrompt);
Var S : String[70];
Begin
  S := '';
  Case Prm Of
    ptInsertSource     : S := tSource;
    ptText             : S := tText;
    ptInsertTarget     : S := tTarget;
    ptRemoveSource     : S := #13+tRemoveSource;
    ptRemoveTarget     : S := #13+tRemoveTarget;
    ptRemoveDisk       : S := #13+tRemoveDisk;
    ptInsertNewDisk    : S := tNewDisk;
    ptErrorWrite       : S := tErrorWrite;
    ptRetryAbortIgnore : S := tRetryAbortIgnore;
    ptErrorPrompt      : S := tErrorPrompt;
    ptCopyAnother      : S := tCopyAnother;
    ptDiskTypeMisMatch : S := tDiskTypeMisMatch;
    ptVerifyError      : S := '  '+tVerifyError;
    ptNone             : S := '';
    ptSourceAndTarget  : S := tSource+#13#10#10+tText;
  End;
  Write(S);
End;

Function TTY_Msg.Continue:ContType;
Begin
  Continue := ctGoOn;
  If AskedForQuit Then
    Continue := ctQuit
  Else If Not KeyPressed Then
      Continue := ctGoOn
    Else
      While KeyPressed Do Begin
        LastKey := Ord(ReadKey);
        Case UpCase(LH(LastKey).Low) Of
          #0       : LH(LastKey).High := ReadKey;
          #27      : Begin
                       Continue := ctQuit;
                       AskedForQuit := True;
                     End;
          'R'      : Continue := ctRetry;
          'I'      : Continue := ctIgnore;
          'A'      : Continue := ctAlways;
          'N'      : Continue := ctNo;
          'Y'      : Continue := ctYes;
          ' ', #13 : Continue := ctEnterSpace;
        Else
          Continue := ctUnknown
        End;
      End;
End;

Function TTY_Msg.ClearFileList:Word;
Begin
  ClearFileList := 0;
End;

Procedure TTY_Msg.AddFileName(Dir:DirEntryRec);
Begin
End;

Procedure TTY_Msg.TempUse(UseLowMem, UseXMS, UseDisk : LongInt);
Begin
  Write('Memory:   DOS: ',UseLowMem Div 1024,' Kb');
  If UseXMS > 0 Then
    Write(',  XMS: ', UseXMS Div 1024, ' Kb');
  If UseDisk > 0 Then
    Write('  Buffer file: ', SwapDir, SwapFname);
  WriteLn;
End;

Procedure TTY_Msg.CurCopied(Reading:Boolean; T, H :Byte; N : LongInt);
Begin
  Write(#13);
  Write(RWStatus[Reading], 'Track':7, T:3, 'Head':6, H:2,
    N Div 1024:6, ' Kb  ',  N / RealDSizeS * 100 :4:0, '%');
  If BadSectors > 0 Then
    Write('  Bad Sectors: ', Badsectors:2);
End;

Procedure TTY_Msg.CurActivity(Act:Action);
Begin
End;

Procedure TTY_Msg.TransferTime(M, S : Byte);
Var MStr, SStr : Str2;
Begin
  Str(M, MStr);
  Str(S, SStr);
  While Length(SStr) < 2 Do
    SStr := '0' + SStr;
  WriteLn('Transfer Time: ', MStr, '.', SStr);
End;

Procedure TTY_Msg.VolumeSerial(VL : Str11; VSN : LongInt);
Begin
  If ShowLabel Then Begin
    Write('Volume in drive ', SourceDrive, ' is ');
    If VL='' Then
      WriteLn(tunlabeled)
    Else
      WriteLn(VL);
    WriteLn('Volume Serial Number is ', HexWord(VSN Shr 16)+'-'+HexWord(Word(VSN)));
    NewLine;
  End;
End;

Procedure TTY_Msg.DiskStat(DT:Byte; Tracks, Heads, Sectors : Word);
Begin
  WriteLn('Copying ', DiskSizeList[DT].S:6,
        Tracks:4, ' Tracks, ', Heads, ' Heads, ', Sectors:3, ' Sectors');
End;

End.
