{
Kernel homerange estimaton program based on

Worton, B. J. 1989.  Kernel methods for estimating the utilization
distribution in home-range studies.  Ecology, 70, 164-168

Silverman, B. W. 1986.  Density estimation for statistics and data
analysis.  Chapman and Hall.

If you have any questions about the program write to

Jarle Tufto
Dept. Zoology
7055 DRAGVOLL
NORWAY

or

jarle.tufto@avh.unit.no


}

{$define final}

{$E+,N+}
Program HomeRange;

uses crt,graph;
const
   maxtd=300;
   resolution=50;
   tablesize=(resolution+1)*(resolution+1);
   outside=0.07;
   presision=0.05;
   SEMeanRatio=0.05;
   minh=0.01;
   maxh=5.0;
   maxsim=100;
   maxStrPerCommand=20;

type
   OperType=record
      name:string;
      prior:integer;
   end;
const
   nOper=6;
   Operator:array[1..nOper] of OperType=((name:'EQ'  ;prior:1)
                                     ,(name:'GT'  ;prior:1)
                                     ,(name:'LT'  ;prior:1)
                                     ,(name:'AND';prior:2)
                                     ,(name:'OR' ;prior:2)
                                     ,(name:'NOT';prior:1)
                                     );
type
   realtype=real;
   observation=record
      px,py:realtype;
      rx,ry:realtype;
      l:realtype;
   end;
   trackingdata=array[0..maxtd] of observation;
   point=record
      density:realtype;
      v:array [0..1] of boolean;
   end;
   udmatrise=array[0..resolution,0..resolution] of point;
   vector=record
      x,y:integer;
   end;
   udPointer=^point;
   hc=(ls,ah,ug,na);

const
   dir:array[0..3] of vector
   = ((x: 0;y: 1),
      (x: 1;y: 0),
      (x: 0;y:-1),
      (x:-1;y: 0));
var
   h,hx:realtype;
   n:longint;
   tot,dummy:integer;
   a:trackingdata;
   UD:udmatrise;
   table:array[0..tablesize-1] of udPointer;
   scale:realtype;
   hchoice:hc;
   maxdensity:realtype;
   ax,bx,ay,by:realtype;
   volume:realtype;

   adhoch,sdh:real;
   discrete:real;
   schoener,swihart,area:real;
   nfields:integer;
   exclude:string;
   adaptiv,screen,densitycontours,simulate:boolean;
   cvolume:array[1..30] of real;

   nvolumes:integer;

   ncontours:integer;
   tablemade,hmade,scalemade,UDmade:boolean;
{
   ithink:integer;
procedure think;
   begin
      ithink:=(ithink+1) mod 10;
      if ithink=0 then
         gotoxy(ithink+1,wherey);
      write('.         ');
      gotoxy(1,wherey);
   end;
}

function expx(x:realtype):realtype;
   begin
      if x<-1000 then begin
         expx:=1e-1000;
     {    writeln('expx:obs!');   }
      end else
         expx:=exp(x);

   end;
function lnx(x:realtype):realtype;
   begin
      if x<=0 then begin
         lnx:=-3.4e-2000;
     {   writeln('lnx:obs!');      }
      end else
         lnx:=ln(x);
   end;
procedure ComputeSchoener;
   var
      r2,z2,meanx,meany:realtype;
      i:integer;
   begin
      meanx:=0;
      meany:=0;
      for i:=0 to n-1 do begin
         meanx:=meanx+a[i].px;
         meany:=meany+a[i].py;
      end;
      meanx:=meanx/n;
      meany:=meany/n;
      Writeln('Geometric center (x,y) = (',meanx:5:1,',',meany:5:1,')');
      r2:=0;
      for i:=0 to n-1 do r2:=r2+sqr(a[i].px-meanx)+sqr(a[i].py-meany);
      r2:=r2/(n-1);
      Writeln('Mean squared distance from the center r2 = ',r2:5:1);
      z2:=0;
      for i:=0 to n-2 do z2:=z2+sqr(a[i].px-a[i+1].px)+sqr(a[i].py-a[i+1].py);
      z2:=z2/(n-2);
      Writeln('Mean squared distance between succesive observations z2 = ',z2:5:1);
      Writeln('z2 / r2 = ',z2/r2:5:3);
      schoener:=z2/r2;
   end;
procedure ComputeSwihart;
   var
      s2lx,s2x,s2ly,s2y,
      sxlx,sxly,sylx,syly,
      meanlx,meanx,meanly,meany:realtype;
      i                         :integer;
   begin
      meanx:=0;
      meany:=0;
      meanlx:=0;
      meanly:=0;
      for i:=1 to n-1 do begin
         meanx :=meanx +a[i  ].px;
         meany :=meany +a[i  ].py;
         meanlx:=meanlx+a[i-1].px;
         meanly:=meanly+a[i-1].py;
      end;
      meanx:=meanx/(n-1);
      meany:=meany/(n-1);
      meanlx:=meanlx/(n-1);
      meanly:=meanly/(n-1);

      s2lx:=0;
      s2x :=0;
      s2ly:=0;
      s2y :=0;
      sxlx:=0;
      sxly:=0;
      sylx:=0;
      syly:=0;
      for i:=1 to n-1 do begin
         s2x :=s2x +sqr(a[i  ].px-meanx );
         s2lx:=s2lx+sqr(a[i-1].px-meanlx);
         s2y :=s2y +sqr(a[i  ].py-meany );
         s2ly:=s2ly+sqr(a[i-1].py-meanly);
         sxlx:=sxlx+(a[i].px-meanx)*(a[i-1].px-meanlx);
         sxly:=sxly+(a[i].px-meanx)*(a[i-1].py-meanly);
         sylx:=sylx+(a[i].py-meany)*(a[i-1].px-meanlx);
         syly:=syly+(a[i].py-meany)*(a[i-1].py-meanly);
      end;
      Swihart:=sxlx/sqrt(s2x*s2lx)
              +syly/sqrt(s2y*s2ly)
          +abs(sxly/sqrt(s2x*s2ly))
          +abs(sylx/sqrt(s2y*s2lx));
      writeln('Swihart and Slades independence index = ',swihart:10:8);
   end;

procedure SimulateNormal(nsim:integer);
   var
      i:integer;
      x,y:real;
   begin
      Write('Simulating a normal distribution');
      n:=nsim;
      for i:=0 to n-1 do with a[i] do begin
         repeat
            x:=random*10-5;
            y:=random*10-5;
         until random<expx(-x*x-y*y);
         write('.');
         rx:=x; px:=x;
         ry:=y; py:=y;
      end;
      hmade:=false;
      tablemade:=false;
      scalemade:=false;
      UDmade:=false;
   end;
procedure SimulateMulti(nsim:integer);
   var
      i:integer;
      x,y:real;
   begin
      Write('Simulating a multimodal distribution');
      n:=nsim;
      for i:=0 to n-1 do with a[i] do begin
         repeat
            x:=random*10-5;
            y:=random*10-5;
         until random<expx(-x*x-y*y);
         write('.');
         rx:=x; px:=x;
         ry:=y; py:=y;
      end;
      hmade:=false;
      tablemade:=false;
      scalemade:=false;
      UDmade:=false;
   end;

procedure ReadTrackingfile(filename:string);
   var
      infile:text;
      i,j,dummy:integer;
      instring:string;
      fieldvalue:array[1..30] of real;
   function ValNum(expression:string):real;
      var
         field:integer;
         value:real;
      begin
         if expression[1]='#' then begin
            val(copy(expression,2,100),field,dummy);
            ValNum:=FieldValue[field];
         end else begin
            val(expression,value,dummy);
            ValNum:=value;
         end;
      end;

   function ValBoolean(expression:string):boolean;
      var
         i,j,OperPos:integer;
         DoOperator:OperType;
         a,b:string;
      procedure skip;
         var
            pLevel:integer;
         begin
            if expression[i]='(' then begin
               plevel:=1;
               while pLevel>0 do begin
                  inc(i);
                  if expression[i]='(' then inc(pLevel);
                  if expression[i]=')' then dec(pLevel);
               end;
               inc(i);
            end;
         end;
      begin
         if expression='' then
          valBoolean:=false
         else begin
          i:=1;
          Skip;
          if i>length(expression) then
            ValBoolean:=ValBoolean(copy(expression,2,length(expression)-2))
          else begin
            i:=1;
            DoOperator.prior:=0;
            repeat
               skip;
               for j:=1 to nOper do
                  if (Operator[j].name=copy(expression,i,length(operator[j].name)))
                  and (Operator[j].prior>DoOperator.Prior) then begin
                     OperPos:=i;
                     DoOperator:=Operator[j];
                  end;
               inc(i);
            until i>length(expression);
            with doOperator do begin
               a:=copy(expression,1,OperPos-1);
               b:=copy(expression,OperPos+length(name),100);
               if      name='GT'                   then ValBoolean:=(ValNum(a)>ValNum(b))
               else if name='LT'                   then ValBoolean:=ValNum(a)<ValNum(b)
               else if name='EQ'                   then ValBoolean:=ValNum(a)=ValNum(b)
               else if name='AND'                 then ValBoolean:=ValBoolean(a) and ValBoolean(b)
               else if name='OR'                  then ValBoolean:=ValBoolean(a) or valboolean(b)
               else if name='NOT'                 then ValBoolean:=Not(Valboolean(b))
               else begin
                  writeln('Error in exclude expression');
                  halt;
               end;

            end;

          end;
         end;
      end;
   procedure ReadFields;
      var
         instring:string;
         i,i0,f,dummy:integer;
      begin
         for i:=1 to nFields do fieldvalue[i]:=0;
         repeat
            readln(infile,instring)
         until (length(instring)>5) or eof(infile);
         i:=1; i0:=1; f:=1;
         repeat
            repeat
               inc(i)
               until ((instring[i]=' ') and (instring[i-1]<>' ')) or (i>length(instring));
            val(copy(instring,i0,i-i0),fieldvalue[f],dummy);
            inc(f);
            i0:=i;
         until i>length(instring);
      end;
   begin

      Assign(infile,filename);
      Reset(infile);
      writeln('Reading observations from ',filename,'...');
      i:=0; tot:=0;
      repeat
         Readfields;
         if fieldvalue[1]<>0 then with a[i] do begin
            {for j:=1 to nFields do read(infile,fieldvalue[j]);}
            rx:=fieldvalue[4];
            ry:=fieldvalue[5];
            px:=rx;
            py:=ry;

            if not(ValBoolean(exclude)) then
               inc(i);
            inc(tot);

         end;
      until eof(infile);
      n:=i;
      writeln('N = ',n,' out of ',tot,' observations included.');
      hmade:=false;
      tablemade:=false;
      scalemade:=false;
      UDmade:=false;
      ComputeSchoener;
      ComputeSwihart;
   end;

procedure clearVertex;
   var
      i,j:integer;
   begin
      for i:=0 to resolution do for j:=0 to resolution do with ud[i,j] do begin
         v[0]:=false;
         v[1]:=false;
      end;
   end;

function vv(i,j,o:integer):boolean;
   begin
      case o of
         0,1:vv:=ud[i  ,j  ].v[o];
         2  :vv:=ud[i  ,j-1].v[0];
         3  :vv:=ud[i-1,j  ].v[1];
      end;
   end;
procedure vvSet(i,j,o:integer; state:boolean);
   begin
      case o of
         0,1:ud[i  ,j  ].v[o]:=state;
         2  :ud[i  ,j-1].v[0]:=state;
         3  :ud[i-1,j  ].v[1]:=state;
      end;
   end;

{
procedure Estimate;
   var
      i,j:integer;
      volume:realtype;
}

procedure Maketable;
   var
      i,j,k:integer;
      temp:udPointer;
      tempvolum:realtype;

   procedure sort(l,r: integer);
      var
         i,j:integer;
         x,y:realtype;
         temp:udPointer;
      begin
         i:=l; j:=r; x:=table[(l+r) DIV 2]^.density;
         repeat
            while table[i]^.density>x do i:=i+1;
            while x>table[j]^.density do j:=j-1;
            if i<=j then
            begin
               temp:=table[j];
               table[j]:=table[j+1];
               table[j+1]:=temp;
               i:=i+1; j:=j-1;
            end;
         until i>j;
         if l<j then sort(l,j);
         if i<r then sort(i,r);
      end;

   begin
      k:=0;
      for i:=0 to resolution do for j:=0 to resolution do begin
         table[k]:=Addr(ud[i,j]);
         inc(k);
      end;
      writeln('Sorting utilisation distribution table...');
      {
      Sort(0,k-1);
      }
      for i:=0 to tablesize-2 do
         for j:=tablesize-2 downto i do
           if table[j]^.density<table[j+1]^.density then begin
              temp:=table[j];
              table[j]:=table[j+1];
              table[j+1]:=temp;
           end;
      tablemade:=true;

   end;


procedure Outputmatrise(matrixfile:string);
   var
      i,j:integer;
      f:text;
   begin
      writeln('Writing UD matrix to ',matrixfile,'...');
      assign(f,matrixfile);
      rewrite(f);
      for j:=-1 to resolution do begin
         for i:=-1 to resolution do begin
            if j=-1 then
               if i=-1 then
                  write(f)
               else
                  write(f,ax*i+bx:5:1)
            else
               if i=-1 then
                  write(f,ay*j+by:5:1)
               else
                  write(f,ud[i,j].density:15);
            write(f,#9);
         end;
         writeln(f);
      end;
      close(f);
   end;

procedure OutputUtilisation(utilfile:string);
   var
      uf:text;
      tempvolum:real;
      i:integer;
   begin
      if not(tablemade) then Maketable;
      writeln('Writing utilisation distribution data to ',utilfile,'...');
      assign(uf,utilfile);
      rewrite(uf);
      tempvolum:=0;
      writeln(uf,'Area',#9,'Density',#9,'Volum');
      for i:=0 to tablesize-1 do begin
         tempvolum:=tempvolum+table[i]^.density*scale*scale;
         writeln(uf,(i+1)*scale*scale:10:5,
                 #9,table[i]^.density:10:5,
                 #9,tempvolum);
      end;
      close(uf);
   end;


procedure Findscale;
   var
      minx,maxx,miny,maxy,adjoutside,maxmax:realtype;
      i:integer;
   begin
      minx:=maxint; maxx:=-maxint;
      miny:=maxint; maxy:=-maxint;
      for i:=1 to n-1 do with a[i] do begin
         if rx>maxx then maxx:=rx;
         if rx<minx then minx:=rx;
         if ry>maxy then maxy:=ry;
         if ry<miny then miny:=ry;
      end;
      if maxx-minx>maxy-miny then
         maxmax:=maxx-minx
      else
         maxmax:=maxy-miny;
      if densitycontours then
         adjoutside:=-2.5/0.2*(1/nVolumes)+0.5
      else
         adjoutside:=2.5*cvolume[nVolumes]+8.0;
      adjoutside:=adjoutside*h/maxmax;

      if maxx-minx>maxy-miny then begin
         ax:=(maxx-minx)*(1+2*adjoutside)/resolution;
         bx:=minx-(maxx-minx)*adjoutside;
         ay:=ax;
         by:=(miny+maxy)/2-ay*resolution/2;
      end else begin
         ay:=(maxy-miny)*(1+2*adjoutside)/resolution;
         by:=miny-(maxy-miny)*adjoutside;
         ax:=ay;
         bx:=(minx+maxx)/2-ax*resolution/2;
      end;
      scale:=ax;
      scalemade:=true;
   end;

procedure shiftcoordinates(shiftdistance:real);
   var
      i:integer;
   begin
      for i:=0 to n-1 do with a[i] do begin
         rx:=rx+shiftdistance;
         ry:=ry+shiftdistance;
      end;
      writeln('All coordinates shifted ',shiftdistance:7:3,' units.');
   end;
procedure nondiscretize;
   var
      i:integer;
   begin
      for i:=0 to n-1 do with a[i] do begin
         px:=rx+discrete*(random-0.5);
         py:=ry+discrete*(random-0.5);
      end;
   end;
procedure RandomizePoints;
   var
      i:integer;
   begin
      writeln('Rerandomizing the data.....');
      for i:=0 to n-1 do with a[i] do begin
         rx:=rx+discrete*(random-0.5);
         ry:=ry+discrete*(random-0.5);
         px:=rx;
         py:=ry;
      end;
   end;



function Normal(x:realtype):realtype;
   begin
      normal:=expx(-x*x/2)/(2*PI);
   end;

function Normal2(x:realtype):realtype;
   begin
      Normal2:=Normal(x/1.41421356)/2;
   end;

function dist(i,j:integer):realtype;
   var
      temp:realtype;
   begin
      if not(simulate) then begin
         if i=j then
            temp:=0
         else begin
            temp:=sqrt(sqr(a[i].px-a[j].px)+sqr(a[i].py-a[j].py));
            if temp=0 then temp:=discrete*0.521
         end;
         dist:=temp;
      end else
         dist:=sqrt(sqr(a[i].px-a[j].px)+sqr(a[i].py-a[j].py));

   end;
function M(h:realtype):realtype;
   var
      i,j:integer;
      tempM:realtype;
      distance:realtype;
   begin
      tempM:=0;

      { halvparten av alle kombinasjoner bortsett fra diagonalen }
      for i:=0 to n-1 do for j:=0 to i-1 do begin
         distance:=dist(i,j)/h;
         tempM:=tempM+Normal2(Distance)-2*Normal(Distance);
      end;

      { alle kombinasjoner }
      tempM:=tempM*2;

      { pluss diagonalen }
      tempM:=tempM+n*(Normal2(0)-2*Normal(0));

      tempM:=tempM/(n*n*h*h)+2*Normal(0)/(n*h*h);

      M:=tempM;
   end;
procedure Examineh(outfile:string);
   var
      h,pot,tempM:real;
      f:text;
   begin
      assign(f,outfile);
      rewrite(f);
      pot:=1;
      repeat
         h:=exp(pot*ln(10));
         tempM:=M(h);
         writeln(h,' ',tempM);
         writeln(f,h,' ',tempM);
         pot:=pot-0.25;
      until keypressed;
      close(f);
   end;

procedure LeastSquareh;
   var
      step,Mleft,Mright,se,sd,SumSqrDev,htot,hmean:realtype;
      simh:array[1..maxsim] of realtype;
      left,right:boolean;
      sim,i:integer;
      simfile:text;
   procedure SearchForh;
      begin
         left:=false;
         right:=false;
         h:=minh;
         step:=(maxh-minh)/2;
         repeat
            h:=h+step;
            Mleft:=M(h);
            Mright:=M(h*(1+presision));
         {   writeln(h:1:8,' ',Mleft,' ',Mright);   }
            step:=step/2;
            if Mleft<Mright then begin
               left:=true;
               step:=-abs(step)
            end else begin
               right:=true;
               step:=abs(step);
            end;
         until abs(step/h)<presision;
      end;
   begin
      writeln('Searching for least-square-cross validation choice of h');
      writeln('between ',minh:7:3,' and ',maxh:7:3);
      if simulate then begin
         sim:=0;
         htot:=0;
         assign(simfile,'c:\simh.txt');
         rewrite(simfile);
         repeat
            inc(sim);
            Nondiscretize;
            Write('Sim.nr.',sim:4);
            SearchForh;
            write('  h = ',h:11:8);

            Writeln(simfile,h);
            simh[sim]:=h;
            htot:=htot+h;
            hmean:=htot/sim;
            SumSqrDev:=0;
            for i:=1 to sim do
               SumSqrDev:=SumSqrDev+Sqr(simh[i]-hmean);
            if sim>1 then begin
               sd:=sqrt(sumsqrDev/(sim-1));
               se:=sd/sqrt(sim);
            end;
            Write('  Mean(h) = ',hmean:11:8);
            gotoxy(1,wherey);
         until (se/hmean<SEMeanRatio) and (sim>5) or (sim=maxsim);
         close(simfile);
         writeln('Number of simulations = ',sim,'          ');
         writeln('Standard deviation of h = ',sd);
         sdh:=sd;
         writeln('Standard error of hmean = ',se);
         h:=hmean;
      end else
         SearchForh;
      if left and right then begin
         writeln('Optimal choice is hmean=',h:6:3)
      end else begin
         if hx<>0 then
            h:=hx
         else
            h:=1;
         writeln('No minimum value of M(h) found, using h=',hx:6:3);
      end;
      hmade:=true;
      udmade:=false;

   end;

procedure adhoc;
   var
      xmean,ymean:realtype;
      i:integer;
      sx,sy,rho:realtype;
   begin
      writeln('Calculating ad-hoc choice of smoothing parameter h...');
      sx:=0;
      sy:=0;
      for i:=0 to n-1 do begin
         sx:=sx+a[i].rx;
         sy:=sy+a[i].ry;
      end;
      xmean:=sx/n;
      ymean:=sy/n;
      sx:=0;
      sy:=0;
      for i:=0 to n-1 do begin
         sx:=sx+sqr(a[i].rx-xmean);
         sy:=sy+sqr(a[i].ry-ymean);
      end;
      sx:=sx/(n-2);
      sy:=sy/(n-2);
      rho:=0.5*sqrt(sx+sy);
      h:=rho*exp(-1/6*ln(n));
      writeln('h = ',h:6:3);
      hmade:=true;
      udmade:=false;
      adhoch:=h;
   end;
procedure nadjust(hsub:realtype);
   begin
      h:=hsub*exp(-1/6*ln(n));
      writeln('User given choice of h adjusted for sample size is ',h:6:3);
      hmade:=true;
      udmade:=false;
   end;
procedure delta(deltah:realtype);
   begin
      write('Adjusting from h = ',h:6:3);
      h:=h*(1+deltah);
      write(' to h = ',h:6:3);
      hmade:=true;
      udmade:=false;
      adhoch:=h;
   end;
procedure testbreak;
   begin
   end;

function udobs(k:integer):realtype;
   var
      i,j:integer;
      wx,wy:realtype;
      c1,c2,c3,c4,sum:realtype;
   begin
      i:=trunc((a[k].px-bx)/ax);
      j:=trunc((a[k].py-by)/ay);
      wx:=frac((a[k].px-bx)/ax);
      wy:=frac((a[k].py-by)/ay);
      c1:=(1-wx)*(1-wy);
      c2:=wx    *(1-wy);
      c3:=(1-wx)*wy    ;
      c4:=wx    *wy    ;
      sum:=c1+c2+c3+c4;
      udobs:=( ud[i  ,j  ].density*c1
              +ud[i+1,j  ].density*c2
              +ud[i  ,j+1].density*c3
              +ud[i+1,j+1].density*c4)/sum;

   {  i:=round((a[k].rx-bx)/ax);
      j:=round((a[k].ry-by)/ay);
      udobs:=ud[i,j].density;    }
   end;

procedure Kernel(adap:boolean);
   var
      i,j,k:integer;
      udx,udy:realtype;
      li:realtype;
   procedure localsmooth;
      var
         g:realtype;
         i:integer;
      begin
         g:=0;
         for i:=0 to n-1 do
            g:=g+lnx(udobs(i));
         g:=expx(g/n);
         for i:=0 to n-1 do a[i].l:=expx(-0.5*lnx(udobs(i)/g));
      end;

   begin
      if not(hmade) then leastsquareh;
      if not(scalemade) then findscale;

      Write('Calculating the ');
      if not(adap) and adaptiv then write('pilot estimat ');
      if adap and adaptiv then write('Adaptiv kernel ');
      if not(adaptiv) then write('Fixed kernel ');
      writeln('UD matrix...');
      if adap then localsmooth;
      volume:=0;
      for i:=0 to resolution do begin
        for j:=0 to resolution do begin
         {$ifdef test}
         if (i=10) and (j=0) then testbreak;
         {$endif}
         {$ifdef test2} writeln(i:4,j:4); {$endif}
         udx:=ax*i+bx;
         udy:=ay*j+by;
         with ud[i,j] do begin
            density:=0;
            for k:=0 to n-1 do begin
               if adap then begin
                  li:=a[k].l;
               end else
                  li:=1;
               density:=density+Normal(sqrt(sqr(a[k].px-udx)+sqr(a[k].py-udy))/(h*li))/(li*li);
             end;
            density:=density/(n*h*h);
            volume:=volume+density*ax*ay;
         end;
        end;
      end;
      writeln(volume*100:7:4,'% of the UD function included inside the matrix.');
      tablemade:=false;
      udmade:=true;
   end;

procedure MakeContours(coordinatefile:string);
   var
      i,j,o,vi:integer;
      graphdriver,graphmode,maxx,maxy:integer;
      sax,sbx,say,sby:real;
      d,v:realtype;
      cf:text;
   procedure contour(i,j,o:integer);
      var
         sx,sy,sx0,sy0,o2:integer;
         ux,uy,ux0,uy0:real;
         start:boolean;
         interpol,d1,d2:realtype;
         puy,pux,incarea:realtype;
      begin
         start:=true;
         inc(nContours);
         if coordinatefile<>'' then writeln(cf,nContours);
         repeat
            vvSet(i,j,o,true);
            d1:=ud[i,j].density;
            d2:=ud[i+dir[o].x,j+dir[o].y].density;
            interpol:=(d-d1)/(d2-d1);
            if screen then begin
               sx:=trunc(sax*(i+dir[o].x*interpol)+sbx);
               sy:=trunc(say*(j+dir[o].y*interpol)+sby);
            end;
            ux:=ax*(i+dir[o].x*interpol)+bx;
            uy:=ay*(j+dir[o].y*interpol)+by;
            if Start then begin
               sx0:=sx;
               sy0:=sy;
               ux0:=ux;
               uy0:=uy;
               if screen then MoveTo(sx,sy);
               if coordinatefile<>'' then writeln(cf,ux:10:6,' ',uy:10:6);
            end else begin
               if screen then LineTo(sx,sy);
               if coordinatefile<>'' then writeln(cf,ux:10:6,' ',uy:10:6);
               area:=area+0.5*(ux*puy-uy*pux);
            end;
            pux:=ux;
            puy:=uy;
            start:=false;
            o2:=(o+3) mod 4;
            if ud[i+dir[o2].x,j+dir[o2].y].density>d then
               o:=o2
            else if ud[i+dir[o2].x+dir[o].x,j+dir[o2].y+dir[o].y].density>d then begin
               i:=i+dir[o2].x;
               j:=j+dir[o2].y;
               o:=o;
            end else begin
               i:=i+dir[o2].x+dir[o].x;
               j:=j+dir[o2].y+dir[o].y;
               o:=(o+1) mod 4;
            end;

         until vv(i,j,o);
         area:=area+0.5*(ux0*puy-uy0*pux);
         if screen then LineTo(sx0,sy0);
         if coordinatefile<>'' then begin
            writeln(cf,ux0:10:6,' ',uy0:10:6);
            writeln(cf,'END');
         end;
      end;
   function VolumeToDensity(v:realtype):realtype;
      var
         i:integer;
         tempvolum,addvolum,interpol:realtype;
      begin
         i:=0;
         tempvolum:=0;
         repeat
            addvolum:=table[i]^.density*scale*scale;
            tempvolum:=tempvolum+addvolum;
            inc(i);
         until tempvolum>v;
         interpol:=(tempvolum-v)/addvolum;

         volumeToDensity:=table[i-1]^.density*interpol+table[i-2]^.density*(1-interpol);
      end;


   begin
      if not(UDmade) then begin
         kernel(false);
         kernel(true);
      end;
      if not(tablemade) then MakeTable;
      if coordinatefile<>'' then begin
         writeln('Writing contour coordinates to ',coordinatefile,'...');
         assign(cf,coordinatefile);
         rewrite(cf);
      end;

      if screen then begin
         writeln('Press any key to view graphics output');
         repeat until keypressed;
         graphdriver:=vga;
         graphmode:=1;
         initgraph(graphdriver,graphmode,'c:\turbo');
         maxx:=getmaxx;
         maxy:=getmaxy;

         say:=-maxy/resolution;
         sax:=maxy/resolution;
         sby:=maxy;
         sbx:=0;
         setcolor(1);


      end;

      if densityContours then nVolumes:=9;

      nContours:=0;
      for vi:=1 to nVolumes do begin
         if densitycontours then
            d:=table[0]^.density*vi/nVolumes
         else
            d:=VolumeToDensity(cvolume[vi]);

         ClearVertex;
         area:=0;

         for i:=1 to resolution-1 do for j:=1 to resolution-1 do
            if ud[i,j].density<d then
               for o:=0 to 3 do
                  if ud[i+dir[o].x,j+dir[o].y].density>d then
                     if not vv(i,j,o) then
                        contour(i,j,o);
      end;
      if screen then begin
         for i:=0 to n-1 do begin
            putpixel(trunc(sax*(a[i].rx-bx)/ax+sbx),trunc(say*(a[i].ry-by)/ay+sby),12);
            putpixel(trunc(sax*(a[i].px-bx)/ax+sbx),trunc(say*(a[i].py-by)/ay+sby),14);

         end;
         delay(10000);
         repeat until keypressed;
      end;
      if coordinatefile<>'' then begin
         writeln(cf,'END');
         close(cf);
      end;
   end;



Procedure WritePointfile(pointfile:string);
   var
      i:integer;
      pfile:text;
   begin
      writeln('Writing point coordinates to ',pointfile,'...');
      assign(pfile,pointfile);
      rewrite(pfile);
      for i:=0 to n-1 do with a[i] do
         writeln(pfile,i,',',rx:5:1,',',ry:5:1);
      writeln(pfile,'END');
      close(pfile);
   end;
procedure WriteHistofile(histofile:string);
   var
      i,j:integer;
      pfile:text;
      shift:real;
   begin
      writeln('Writing histogram data to ',histofile,'...');
      assign(pfile,histofile);
      rewrite(pfile);
      for i:=0 to n-1 do begin
         shift:=0;
         for j:=0 to i-1 do
            if (a[j].rx=a[i].rx) and (a[j].ry=a[i].ry) then
               shift:=shift+0.05;
         writeln(pfile,i,',',a[i].rx+shift/2:7:3,',',a[i].ry+shift:7:3);
      end;
      writeln(pfile,'END');
      close(pfile);
   end;
function UpCaseStr(a:string):string;
   var
      i:integer;
      temp:string;
   begin
      temp:='';
      for i:=1 to length(a) do insert(upcase(a[i]),temp,i);
      UpCaseStr:=temp;
   end;
procedure WriteSummary(summaryfile:string);
   var
      sf:text;
   begin
      assign(sf,summaryfile);
      rewrite(sf);
      write(sf,area,' ');
      write(sf,n,' ',tot,' ',h,' ');
      write(sf,schoener,' ');
      write(sf,swihart,' ');
      write(sf,sdh,' ',adhoch,' ');
      writeln(sf);
      close(sf);
   end;
procedure ReadCommands;
   var
      malfile:text;
      comfile:text;
      command:string;
      i:integer;
      c:array[1..maxStrPerCommand] of string;
      p:array[2..maxStrPerCommand] of realtype;
      ncom:integer;
      exit,correctcommand:boolean;
   procedure readcommand;
      begin
         if paramcount=0 then begin
            write('>');
            readln(command)
         end else repeat
            readln(comfile,command);
            if command[1]='*' then command:='';
            if eof(comfile) then exit:=true;
         until exit or (command<>'');
      end;
   procedure processcommand;
      var
         i,j:integer;
         ip:integer;
      begin

         for i:=length(command) downto 1 do
            if command[i]='%' then begin
               val(command[i+1],ip,dummy);
               delete(command,i,2);
               insert(paramstr(ip+1),command,i);
            end;
         ncom:=0;
         if paramcount>0 then writeln('>',command);
         j:=0;
         insert(' ',command,length(command)+1);
         for i:=1 to length(command) do begin
            command[i]:=upcase(command[i]);
            if (command[i]=' ') and (i>j+1) then begin
               inc(ncom);
               c[ncom]:=copy(command,j+1,i-j-1);
               j:=i;
            end;
         end;
         for i:=2 to ncom do
            val(c[i],p[i],dummy);
      end;
   procedure defaultcontours;
      var
         i:integer;
      begin
         nvolumes:=9;
         for i:=1 to 9 do cVolume[i]:=i/10;
      end;
   procedure GetVolumes;
      var
         i:integer;
      begin
         nvolumes:=0;
         for i:=2 to ncom do
            cvolume[i-1]:=p[i];
         nvolumes:=ncom-1;
         if nvolumes=0 then defaultcontours;
      end;
   begin
      adhoch:=0;
      sdh:=0;
      exclude:='';
      adaptiv:=true;
      screen:=false;
      hchoice:=ls;
      densityContours:=false;
      nFields:=13;
      discrete:=0;
      defaultcontours;
      hx:=0.8;
      simulate:=false;

      if paramcount>0 then begin
         assign(comfile,paramstr(1));
         reset(comfile);
         writeln('Reading commands from ',paramstr(1));
      end;
      assign(malfile,'c:\macromal.txt');
      rewrite(malfile);
      exit:=false;
      repeat
         readcommand;
         processcommand;
         if ncom>0 then begin
            correctcommand:=true;
                 if c[1]='EXCLUDE'     then exclude:=c[2]
            else if c[1]='INDATA'      then readtrackingfile(c[2])
            else if c[1]='OUTDATA'     then writesummary(c[2])
            else if c[1]='LEASTSQUARE' then LeastSquareh
            else if c[1]='ADHOC'       then adhoc
            else if c[1]='NADJUST'     then nadjust(p[2])
            else if c[1]='DELTA'       then delta(p[2])
            else if c[1]='SIMULATE'    then simulate:=true
            else if c[1]='FIXED'       then kernel(false)
            else if c[1]='ADAPTIV'     then kernel(true)
            else if c[1]='SHIFT'       then shiftcoordinates(p[2])
            else if c[1]='MATRIXFILE'  then outputmatrise(c[2])
            else if c[1]='UTILFILE'    then outpututilisation(c[2])
            else if c[1]='RANDOMIZE'   then RandomizePoints
            else if c[1]='DENSITY'     then begin
                                              densitycontours:=true;
                                              getvolumes;
                                            end
            else if c[1]='VOLUME'      then begin
                                              densitycontours:=false;
                                              getvolumes;
                                            end
            else if c[1]='CONTOURFILE' then MakeContours(c[2])
            else if c[1]='POINTFILE'   then WritePointfile(c[2])
            else if c[1]='HISTOFILE'   then WriteHistofile(c[2])
            else if c[1]='EXIT'        then exit:=true
            else if c[1]='RESOLUTION'  then discrete:=p[2]
            else if c[1]='EXTRAH'      then hx:=p[2]
            else if c[1]='EXAMINE'     then examineh(c[2])
            else if c[1]='NORMAL'      then SimulateNormal(round(p[2]))
            else if c[1]='MULTIMODAL'  then SimulateMulti(round(p[2]))
            else if c[1]='GRAPHICS'    then screen:=truem
            else begin
               writeln('No such command.  Type help!');
               correctcommand:=false;
            end;
            if correctcommand then writeln(malfile,command);
         end;

      until exit;

      if paramcount=0 then begin
         writeln('c:\macromal.txt can be used used as a macro to prosess your data');
         close(malfile);
      end;
   end;

begin
   tablemade:=false;
   writeln('Kernel version 2.0 - 20.10.93');
   randomize;
   readcommands;

end.

