/* --------------------------------- cockpit.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Render instruments etc.
*/

#include "fly.h"


#define	IFG	st.hfg		/* instruments color */
#define	MFG	st.hfgi		/* instruments marker color */

extern void FAR
show_inst (VIEW *view, OBJECT *obj)
{
	int	orgx, orgy, maxx, maxy, sizex, sizey, sizexx, tx, ty, v, x, y;
	int	spitch, croll, sroll, sdir, cdir;

	if (!obj || !IS_PLANE(obj) || !(EE(obj)->hdd & HDD_INSTRUMENTS))
		return;

/* Set screen area and adjust aspect ratio.
*/
	get_area (view, &orgx, &orgy, &maxx, &maxy);
	get_square (view, maxx, maxy, &sizex, &sizey);

	orgx += maxx;				/* lower right corner */
	orgy += maxy;
	sizex /= 8;
	sizey /= 4;
	orgx -= sizex;
	orgy -= sizey;
	tx = sizex/8;
	ty = sizey/8;

	add_line (orgx + sizex, orgy + sizey, T_MOVE);	/* outline */
	add_line (orgx + sizex, orgy - sizey, IFG);
	add_line (orgx - sizex, orgy - sizey, IFG);
	add_line (orgx - sizex, orgy + sizey, IFG);
	add_line (orgx + sizex, orgy + sizey, IFG);

	sizexx = sizex - tx;
	add_line (orgx - sizex,  orgy, T_MOVE);		/* ticks */
	add_line (orgx - sizexx, orgy, IFG);
	add_line (orgx + sizex,  orgy, T_MOVE);
	add_line (orgx + sizexx, orgy, IFG);

	v = muldiv (EE(obj)->rudder, sizex, 90);	/* rudder */
	add_line (orgx + v, orgy + sizey, T_MOVE);
	add_line (orgx + v, orgy + sizey - ty, MFG);

	v = muldiv (EE(obj)->throttle, sizey, 100);	/* throttle */
	add_line (orgx + sizex,  orgy - v, T_MOVE);
	add_line (orgx + sizexx, orgy - v, MFG);

#define	VLIMIT	VONE*300
	v = obj->V[Z];					/* vz */
	if (v > VLIMIT)
		v = VLIMIT;
	if (v < -VLIMIT)
		v = -VLIMIT;
	v = muldiv (v, sizey, VLIMIT);
#undef	VLIMIT

	x = orgx - sizex;
	y = orgy - v;
	add_line (x - tx, y - ty, T_MOVE);
	add_line (x + tx, y + ty, MFG);
	add_line (x - tx, y + ty, T_MOVE);
	add_line (x + tx, y - ty, MFG);

	sroll  = obj->siny;			/* plane */
	croll  = obj->cosy;
	spitch = obj->a[X];
	spitch = fmul (spitch, sizey)/2;

	x = fmul (croll, sizexx);
	y = fmul (sroll, sizey)/2;

	orgy  -= spitch;

	add_line (orgx - x, orgy - y, T_MOVE);
	add_line (orgx + x, orgy + y, IFG);

	x = fmul (sroll, sizexx)/4;
	y = fmul (croll, sizey)/8;

	add_line (orgx,     orgy,     T_MOVE);
	add_line (orgx + x, orgy - y, IFG);
	orgy += spitch;
	orgx -= 2*sizex;

/* direction
*/
	x = sizex;
	y = sizey/2;

	orgy += y;

	sdir  = obj->sinz;
	sdir  = fmul (sdir,  sizexx);
	cdir  = obj->cosz;
	cdir  = fmul (cdir,  y);

	add_line (orgx + x, orgy + y, T_MOVE);		/* outline */
	add_line (orgx - x, orgy + y, IFG);
	add_line (orgx - x, orgy - y, IFG);
	add_line (orgx + x, orgy - y, IFG);

	add_line (orgx, orgy, T_MOVE);
	add_line (orgx - sdir, orgy - cdir, IFG);	/* hand */
	orgx -= 2*sizex;

/* speed
*/

#define	MAXSPEED	(VONE*600)
	x = obj->speed;
	if (x > MAXSPEED)
		x = MAXSPEED;
	else if (x < 0)
		x = 0;
	x = muldiv (x, 2*sizex, MAXSPEED);
	y = sizey/2;
#undef MAXSPEED
	add_line (orgx + sizex, orgy - y, T_MOVE);	/* scale */
	add_line (orgx - sizex, orgy - y, IFG);
	add_line (orgx,             orgy + y, T_MOVE);	/* hand */
	add_line (orgx - sizex + x, orgy - y, IFG);
}

#undef IFG
#undef MFG
