/* --------------------------------- mswin.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* general system-specific stuff for Microsoft WINDOWS.
 * Windows support by Michael Taylor miket@canb.auug.org.au
*/

#include <windows.h>

#include "fly.h"


HANDLE		Fly8Instance;
extern RECT	textrect;
extern TEXTMETRIC textmetric;
char   FAR	Fly8AppName[10]  = "Fly8";
char   FAR	Fly8Text[10]     = "Fly8 Text";
char   FAR	Fly8Message[15]  = "Fly8";

static FILE	*outfile=NULL;
static char	_Gbuf[1024];

int FAR
printf (const char *fmt, ...)
{
	va_list	ap;
	int	i;

	va_start (ap, fmt);
	i = vsprintf (_Gbuf, fmt, ap);
	va_end (ap);
        outfile = fopen ("printf.log", "w+t");
	
	fputs (_Gbuf, outfile);
	fclose (outfile);
	outfile = NULL;
	MessageBox((HWND)NULL, (LPCSTR)_Gbuf, (LPCSTR)"Fly8 Message", MB_OK);
	return (i);
}

static int FAR
init (void)
{return (0);}

static void FAR
term (void)
{
	if (outfile) {
		fclose (outfile);
		outfile = 0;
	}
}

static void FAR
poll (void)
{}

static Ulong FAR
disable (void)
{return (0);}

static void FAR
enable (Ulong flags)
{}

static void FAR
shell (void)
{
	MsgWPrintf (20, "shell not implemented");
}

static void FAR
BuildFileName (char *FullName, char *path, char *name, char *ext)

/* Build file name from parts.
   path is NULL for "current directory".
   path is ""   for "root directory".
*/

{
	FullName[0] = '\0';

	if (path) {
		strcat (FullName, path);
		strcat (FullName, "\\");
	}
	strcat (FullName, name);
	if (ext && ext[0]) {
		strcat (FullName, ".");
		strcat (FullName, ext);
	}
}

struct SysDriver SysDriver = {
	"WINDOWS",
	0,
	init,
	term,
	poll,
	disable,
	enable,
	shell,
	BuildFileName
};

extern long FAR PASCAL Fly8WndProc (HWND, Uint, WORD, LONG);
static long FAR PASCAL Fly8TextProc (HWND, Uint, WORD, LONG);
extern int C_MAIN (int argc, char *argv[]);

static void
baderr (char *msg)
{
	FILE	*errs;

	errs = fopen ("c:\\temp\\fly8w.err", ATMODE);
	if (errs) {
		fprintf (errs, msg);
		fclose (errs);
	}
}

/* Procedure called when the application is loaded for the first time
*/
static BOOL
WinInit ( HANDLE hInstance, LPSTR  lpszAppName, LPSTR  lpszMessage)
{
        WNDCLASS   pFly8Class;

#if 0
        /* Check pointer values */
        if (lpszAppName[0] != '\0'  || lpszMessage != '\0')
                return (FALSE);
        /* Load strings from resource */
        LoadString ( hInstance, IDSTR_NAME, (LPSTR)lpszAppName, 10 );
        LoadString ( hInstance, IDSTR_TITLE, (LPSTR)lpszMessage, 15 );
#endif
    	/* define aspects common to both classes */
        pFly8Class.style          = CS_OWNDC |
        			    CS_BYTEALIGNWINDOW;
        pFly8Class.hCursor        = LoadCursor ( (HINSTANCE)NULL, IDC_SIZE );
        pFly8Class.hIcon          = (HICON)NULL;
        pFly8Class.lpszMenuName   = (LPSTR)NULL;
        pFly8Class.hInstance      = hInstance;
        
        pFly8Class.lpszClassName  = (LPSTR)Fly8AppName;
        pFly8Class.hbrBackground  = (HBRUSH) GetStockObject ( BLACK_BRUSH );
        pFly8Class.lpfnWndProc    = (WNDPROC)Fly8WndProc;

        if ( !RegisterClass ( &pFly8Class ) ) {
baderr ("Fly8 failed 1\n");
                /* Initialization failed.
                 * Windows will automatically deallocate all allocated memory.
                 */
		return FALSE;
        }

/* define the text
*/
        pFly8Class.style          = 0;
        pFly8Class.hCursor        = LoadCursor ( (HINSTANCE)NULL, IDC_ARROW );
        pFly8Class.lpszClassName  = (LPSTR)Fly8Text;
        pFly8Class.hbrBackground  = (HBRUSH) GetStockObject ( BLACK_BRUSH );
        pFly8Class.lpfnWndProc    = (WNDPROC)Fly8TextProc;

/* register the text window class
*/
    	if (!RegisterClass (&pFly8Class)) {
baderr ("Fly8 failed 2\n");
/* Initialization failed.
 * Windows will automatically deallocate all allocated memory.
*/
        	return (FALSE);
        }

        return TRUE;        /* Initialization succeeded */
}

static char	args[1024], *argv[30];

int PASCAL
WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine,
	int nCmdShow)
{
	MSG    	msg;
	HMENU  	hMenu  = NULL;
	char	*p, *q;
	int	i;

	if (!hPrevInstance) {

/* Call initialization procedure if this is the first instance
*/
		if (!WinInit (hInstance, (LPSTR)Fly8AppName,
						(LPSTR)Fly8Message)) {
baderr ("Fly8 failed 3\n");
			return FALSE;
		}
	} else {

/* Copy data from previous instance
*/
		GetInstanceData (hPrevInstance, (BYTE *)Fly8AppName, 10);
		GetInstanceData (hPrevInstance, (BYTE *)Fly8Message, 15);
	}
	
	Fly8Instance = hInstance;

	for (i = 0; i < 30; ++i)
		argv[i] = NULL;
	argv[0] = Fly8AppName;
	strcpy (args, lpszCmdLine);
	q = args + strlen (args);
	for ( i = 1, p = args; p < q && *p && i < 30; ++p ) {
		if (*p != ' ') {
			argv[i] = p;
			++i;
			for (; p < q && *p && i < 30; ++p)
				if (*p == ' ') {
					*p = '\0';
					break;
				}
		}
	}

	C_MAIN (i, argv);	/* pass control to Fly8 */	

	return ((int)msg.wParam);
}

extern void ReDrawText (void);

/* procedure called by WINDOWS when an event occurs in the fly8 text window */
static long FAR PASCAL
Fly8TextProc ( HWND hWnd, unsigned message, WORD wParam, LONG lParam)
{
    	PAINTSTRUCT ps;

    	switch (message) {
       
       	case WM_DESTROY:		/* quit the Fly8 application */
		PostQuitMessage ( 0 );
		break;

       	case WM_PAINT:			/* paint the window */
		BeginPaint ( hWnd, (LPPAINTSTRUCT)&ps );
		ReDrawText ();
		EndPaint ( hWnd, (LPPAINTSTRUCT)&ps );
		break;

       	case WM_SIZE:			/* resize the window */
		ReDrawText ();
		break;

       	default:
		return DefWindowProc( hWnd, message, wParam, lParam );
		break;
       	}
    	return(0L);
}
