/* --------------------------------- config.h ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* System dependent configuration information: Microsoft WINDOWS, c8
 * Microsoft Windows  by Michael Taylor (miket@canb.auug.org.au)
*/

#define	INIFILE	"fly.ini"	/* name of ini file */
#define	LOGFILE	"fly.log"	/* name of log file */
#define MAC_EXT "mac"		/* binary macros file extension */
#define MAX_EXT "max"		/* text macros file extension */
#define VMD_EXT "vmd"		/* video modes file extension */
#define PRM_EXT "prm"		/* plane parameters file extension */
#define SHP_EXT "vxx"		/* object shape file extension */
#define NAV_EXT "nav"		/* nav data file extension */
#define LND_EXT "lnd"		/* landscape file extension */

#define	RTMODE	"rt"		/* fopen file mode: read  text */
#define	RBMODE	"rb"		/* fopen file mode: read  binary */
#define	WTMODE	"w"		/* fopen file mode: write text  */
#define	WBMODE	"wb"		/* fopen file mode: write binary */
#define	ATMODE	"at"		/* fopen file mode: read/write text */
#define	ABMODE	"ab"		/* fopen file mode: read/write binary */

#define PATHSEP	';'		/* path separator */

#ifndef FAR
#define FAR far
#endif

#ifndef NEAR
#define NEAR near
#endif

#ifndef FASTCALL
#define FASTCALL _fastcall
#endif

#ifndef C_MAIN
#define C_MAIN Fly8Main
#endif

#ifdef RGB
#undef RGB
#endif

#ifdef KF_UP
#undef KF_UP
#endif

#ifdef REFRESH
#undef REFRESH
#endif
#define REFRESH 6

#define NOSTDERR

#define INLINED	_inline

#define NEED_STRICMP
#define NEED_STRNICMP
#define NEED_STRDUP
