/* --------------------------------- drivers.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* User defined lists of drivers.
 *
 * Associated with the player we have one of each:
 *  Graphics Driver (output)
 *  Sound Driver (output)
 *  Keyboard Driver (input)
 *  Pointer Driver (input)
 *  Network Drivers (i/o)
*/

#include "fly.h"


extern struct GrDriver NEAR GrQc;
extern struct GrDriver NEAR GrFast;

struct GrDriver NEAR* FAR GrDrivers[] = {
	&GrQc,		/* default */
	&GrFast,
0};


extern struct SndDriver NEAR SndSpeaker;

struct SndDriver NEAR* FAR SndDrivers[] = {
	&SndSpeaker,
0};


extern struct PtrDriver NEAR PtrKeypad;
extern struct PtrDriver NEAR PtrMouse;
extern struct PtrDriver NEAR PtrAstick;
extern struct PtrDriver NEAR PtrBstick;
extern struct PtrDriver NEAR PtrRandom;

struct PtrDriver NEAR* FAR PtrDrivers[] = {
	&PtrKeypad,
	&PtrMouse,
	&PtrAstick,
	&PtrBstick,
	&PtrRandom,
0};


extern struct KbdDriver NEAR KbdConsole;

struct KbdDriver NEAR* KbdDrivers[] = {
	&KbdConsole,
0};


extern struct NetDriver NEAR NetCom;
extern struct NetDriver NEAR NetPack;
extern struct NetDriver NEAR NetSlip;

struct NetDriver NEAR* FAR NetDrivers[] = {
	&NetCom,
	&NetPack,
	&NetSlip,
0};
