/* ------------------------- linec.c ---------------------------------------- */

/* Draw lines on SVGA. Can be very fast when usage of low level assembly
 * support is requested.
 *
 * It originated from the DJgpp package but completely re-written since, the
 * only surviving clue being the WriteMode specification in the color field.
 *
 * This version replaces DJgpp line.c and uses only C code.
 *
 * MoveTo (x, y)
 * DrawTo (x, y, color)
 * DrawLine (x0, y0, x1, y1, color)
 * SetActiveBase (Ulong b)
 * SetVisualBase (Ulong b)
 * SetWriteMode (int mode)
*/

#include "fly.h"

#include <graphics.h>
#include <pc.h>


#define inp(p) 		inportb(p)
#define outp(p,b)	outportb(p,b)

#define GrOR	0x200

#define VGA_PAGE	((char *)0xd0000000)

static int	_GrWriteMode = 0;
static int	ActiveBase = 0, VisualBase = 0;
static Uint	x1 = 0, y1 = 0, xydone = 0, width = 0, height = 0;
static char	*pva = VGA_PAGE;

static char * FAR
_SimpleLoop (iva, count, sv, c)
register char	*iva;
register int	count;
register int	sv;
int		c;
{
	if (_GrWriteMode == 0)
		while (--count >= 0)
			*(iva += sv) = c;
	else if (_GrWriteMode & GrXOR)
		while (--count >= 0)
			*(iva += sv) ^= c;
	else if (_GrWriteMode & GrOR)
		while (--count >= 0)
			*(iva += sv) |= c;
	return (iva);
}

static char * FAR
_InnerLoop (iva, dy, dx, dvx, dvy, c)
register char	*iva;
int		dy, dx;
register int	dvx, dvy, c;
{
	register Ulong	err;		/* conceptualy */
	register int	count;

/* dx > dy  never =!!!
 * dx > 0
 * dy >= 0
 *
 * set:
 * dy = (dy*0x10000)/dx
 * dx = 0x10000
*/

	count = dx;
	dy = (int)((((long)dy)<<16)/dx);
	err = 0x00008000L;

	if (_GrWriteMode == 0)
		for (; --count >= 0;) {
			iva += dvx;
			if ((err += dy) > 0x0000ffffL) {
				err = (Ushort)err;
				iva += dvy;
			}
			*iva = c;
		}
	else if (_GrWriteMode & GrXOR)
		for (; --count >= 0;) {
			iva += dvx;
			if ((err += dy) > 0x0000ffffL) {
				err = (Ushort)err;
				iva += dvy;
			}
			*iva ^= c;
		}
	else  if (_GrWriteMode & GrXOR)
		for (; --count >= 0;) {
			iva += dvx;
			if ((err += dy) > 0x0000ffffL) {
				err = (Ushort)err;
				iva += dvy;
			}
			*iva |= c;
		}
	return (iva);
}

extern void FAR
MoveTo (int x, int y)
{
#if 0
	if (x < 0)
		x = 0;
	else if (x >= width)
		x = width-1;

	if (y < 0)
		y = 0;
	else if (y >= height)
		y = height-1;
#endif
	x1 = x;
	y1 = y;
	xydone = 0;
}

extern void FAR
DrawTo (int x2, int y2, Uint c)
{
	register int	dx, dy, svx, svy;

#if 0
	if (x2 < 0)
		x2 = 0;
	else if (x2 >= width)
		x2 = width-1;

	if (y2 < 0)
		y2 = 0;
	else if (y2 >= height)
		y2 = height-1;
#endif
	if (!xydone) {
		xydone = 1;
		pva = VGA_PAGE + x1 + ActiveBase + y1*(long)width;
		if (_GrWriteMode == 0)
			*pva = c;
		else if (_GrWriteMode & GrXOR)
			*pva ^= c;
		else if (_GrWriteMode & GrOR)
			*pva |= c;
	}

	if ((dx = x2 - x1) < 0) {
		dx = -dx;
		svx = -1;
	} else
		svx = 1;

	if ((dy = y2 - y1) < 0) {
		dy = -dy;
		svy = -width;
	} else
		svy = width;

	if (dx == dy) {
		if (dx)
			pva = _SimpleLoop (pva, dy, svx+svy, _GrWriteMode|c);
	} else if (0 == dx)
		pva = _SimpleLoop (pva, dy, svy, _GrWriteMode|c);
	else if (0 == dy) {
		char	*pvb;

		pvb = pva + x2 - x1;		/* end point */
		if (!_GrWriteMode) {
			memset ((svx>0 ? (pva+1) : pvb), c, dx);
			pva = pvb;
		} else {
			pva = _SimpleLoop (pva, dx, svx, _GrWriteMode|c);
		}
	} else if (dx > dy)
		pva = _InnerLoop (pva, dy, dx, svx, svy, _GrWriteMode|c);
	else
		pva = _InnerLoop (pva, dx, dy, svy, svx,  _GrWriteMode|c);

	x1 = x2;
	y1 = y2;
}

extern void FAR
SetActiveBase (Ulong b)
{
	ActiveBase = b;
}

extern void FAR
SetVisualBase (Ulong base)		/* t4k specific!!!!!!!!!!!!!!!!! */
{
	int	i;
	Ulong	flags;

	if (base == VisualBase)
		return;

	flags = Sys->Disable ();
	outp (0x3d4, 0x0d);	/* start baseess low */
	outp (0x3d5, (int)((base>>2)&0x00ff));

	outp (0x3d4, 0x0c);	/* start baseess high */
	outp (0x3d5, (int)((base>>10)&0x00ff));

	outp (0x3d4, 0x33);	/* start baseess very high */
	i = inp (0x3d5);
	outp (0x3d5, (i&~3)|(int)((base>>18)&3));
	Sys->Enable (flags);

	VisualBase = base;
}

extern void FAR
SetWriteMode (int mode)
{
	_GrWriteMode = mode;
}

extern void FAR
DrawLine (int xa, int ya, int xb, int yb, Uint c)
{
	if (xa != x1 || ya != y1 || !xydone)
		MoveTo (xa, ya);

	if ((c&0xff00) != _GrWriteMode)
		SetWriteMode (c);

	DrawTo (xb, yb, c);
}

extern void FAR
InitGr (int mode, int sizex, int sizey)
{
	GrSetMode (mode, sizex, sizey);
	width  = GrMaxX () + 1;
	height = GrMaxY () + 1;
}

#undef inp
#undef outp
#undef GrOR
