/* --------------------------------- grasm.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Vga graphics driver (direct tseng4000 access, 256 colors only).
*/

#include "fly.h"
#include "colors.h"
#include "gr.h"

#include <graphics.h>
#include <pc.h>


static void FAR
SetActive (int page)
{
	SetActiveBase (page * (long)GrSizeY() * (long)GrSizeX());
}

static void FAR
SetVisual (int page)
{
	if (CS->device->sync) {
		while (inportb (0x3da) & 0x01)	/* wait for Display Enabled */
			sys_poll ();
	}
	SetVisualBase ((long)page * (long)GrSizeX() * (long)GrSizeY());
	if (CS->device->sync) {
		while (inportb (0x3da) & 0x08)	/* wait for Vert Sync*/
			sys_poll ();
		while (!(inportb (0x3da) & 0x08)) /* wait for Vert Sync end */
			sys_poll ();
	}
}

static int FAR
CursorMode (int mode)
{return (0);}

static void FAR
TextColor (Uint fg, Uint bg)
{}

static void FAR
FontSet (DEVICE *dev, char *fname)
{}

static void FAR
TextChar (int c)
{}

static void FAR
TextPut (int c)
{}

static void FAR
SetTextPos (int row, int col)
{}

static void FAR
PushTextPos (void)
{}

static void FAR
PopTextPos (void)
{}

static void FAR
TextClear (void)
{}

static void FAR
WriteMode (int mode)
{
	switch (mode) {
	default:
	case T_MSET:
		mode = 0;
		break;
	case T_MOR:
		mode = GrOR;
		break;
	case T_MXOR:
		mode = GrXOR;
		break;
	}

	SetWriteMode (mode);
}

static void FAR
SetPalette (int n, long c)
{
	int	r, g, b;

	r = 0x0ff & (int)(c      );
	g = 0x0ff & (int)(c >>  8); 
	b = 0x0ff & (int)(c >> 16);
	GrSetColor (n, r, g, b);
}

static void FAR
OpenTextWindow (SCREEN *scr)
{}

static void FAR
CloseTextWindow (SCREEN *scr)
{}

static int FAR
get_options (char *options)
{
	char	*p;

	if (F(p = get_iarg (options, 1)))
		return (1);
	if (!strnicmp (p, "t4k", 3))
		Gr->flags |= GR_TYPE_T4K;
	else {
		LogPrintf ("Bad video type %s\n", p);
		return (1);
	}

	return (0);
}

static int FAR
Init (DEVICE *dev, char *options)
{
	int	i;

	if (get_options (options))
		return (1);

	if (dev->sizex == 0 || dev->sizey == 0)
		return (1);

	InitGr (GR_width_height_graphics, dev->sizex, dev->sizey);

#if 0
	if (dev->mode > 0)
		GrSetBiosMode (dev->mode);
#endif

	for (i = 0; i++ < 256 && GrAllocCell () >= 0;)	/* get 2-255 */
		;

	st.black   = 0;	/* cannot change */
	st.white   = 1;	/* cannot change */
	st.red     = 2;	/* do not change! */
	st.blue    = 4;	/* do not change! */
	st.magenta = 6;	/* do not change! */
	st.green   = 3;
	st.brown   = 5;
	st.gray    = 7;
	st.hudlow  = 8;
	st.hudhigh = 9;
	st.skyblue = 10;
	st.lred    = 11;
	st.lgray   = 12;
	st.ground  = 13;
	st.lblue   = 14;
/*	st.white   = 15;	keep 15 for OR'ed white */

	SetPalette (st.black,   C_BLACK);
	SetPalette (st.white,   C_WHITE);
	SetPalette (st.red,     C_RED);
	SetPalette (st.blue,    C_BLUE);
	SetPalette (st.magenta, C_MAGENTA);
	SetPalette (st.green,   C_GREEN);
	SetPalette (st.brown,   C_BROWN);
	SetPalette (st.gray,    C_GRAY);
	SetPalette (st.hudlow,  C_LYELLOW);
	SetPalette (st.hudhigh, C_YELLOW);
	SetPalette (st.lred,    C_LIGHTRED);
	SetPalette (st.skyblue, C_SKYBLUE);
	SetPalette (st.lgray,   C_LIGHTGRAY);
	SetPalette (st.ground,  C_GRAY);
	SetPalette (st.lblue,   C_LIGHTBLUE);

	for (i = 0; i < dev->npages; ++i) {
		SetActive (i);
		GrClear (0, 0, dev->sizex, dev->sizey, st.black);
	}

	SetVisual (0);
	SetActive (0);

	if (st.fname == 0)
		st.fname = strdup ("6x8.fnt");
	FontSet (dev, st.fname);

	return (0);
}

static void FAR
Term (DEVICE *dev)
{
	InitGr (GR_default_text, 0, 0);
}

static void FAR
Sync (void)
{}

static void FAR
Flush (void)
{}

#if 0
static void FAR
Clear (SCREEN *scr)
{
	GrClear (scr->minx, scr->miny, scr->sizex, scr->sizey, scr->BgColor);
}
#endif

static void FAR
Shutters (int eye)
{
	if (st.misc[7]) {
		if (eye >= 0)
			outportb (st.misc[7]+4, 1+2*eye);
		else if (-1 == eye)
			outportb (st.misc[7]+4, 1);		/* on */
		else if (-2 == eye)
			outportb (st.misc[7]+4, 0);		/* off */
	}
}

struct GrDriver NEAR GrASM = {
	"GrASM",
	0,
	0,
	Init,
	Term,
	OpenTextWindow,
	CloseTextWindow,
	FontSet,
	TextPut,
	TextChar,
	TextColor,
	CursorMode,
	MoveTo,
	DrawTo,
	SetVisual,
	SetActive,
	0,	/* Clear() too slow */
	SetTextPos,
	PushTextPos,
	PopTextPos,
	TextClear,
	WriteMode,
	SetPalette,
	GrEllipse,
	Sync,		/* not used anymore */
	Flush,
	Shutters
};
