{$R-}
{$C-}
{$U-}
program TurboBBS;

(*******************************************************************)
(*                                                                 *)
(*  Turbo Bulletin Board System Source Code Master (Main) File     *)
(*                                                                 *)
(*  (c) 1985 by Robert H. Maxwell                                  *)
(*              201 - 2275 West 7th Avenue,                        *)
(*              Vancouver, British Columbia, CANADA                *)
(*              V6K 1Y3                                            *)
(*                                                                 *)
(*  Original System running 300/1200 baud, 24hrs: (604) 738-7811   *)
(*  Written for a Kaypro 2-84 using Rixon 212A Intelligent modem   *)
(*                                                                 *)
(*  If you like this program, it would most appreciated if you     *)
(*  sent $30 to the above address. If you choose to operate a BBS  *)
(*  with it, please forward the details so you can be kept up to   *)
(*  date with changes to the program.                              *)
(*                                                                 *)
(*  The author has released this code to the public domain, but    *)
(*  reserves all rights to the program. No other party is to make  *)
(*  any charge for this program other than for media and special   *)
(*  preparation charges, such as customization,                    *)
(*                                                                 *)
(*  While every reasonable effort has been made to ensure the      *)
(*  reliability of this program, the author assumes no liability   *)
(*  for any damages that may arise from its use.                   *)
(*                                                                 *)
(*  Files required for compile: BBS.PAS     (this file)            *)
(*                              BBS2.INC    (support routines)     *)
(*                              MACHDEP.INC (machine dependent)    *)
(*                              IO.INC      (Input/Output drivers) *)
(*                              MAILSYS.INC (Sections named here)  *)
(*                              FILESYS.INC (XMODEM code here)     *)
(*                                                                 *)
(*  Information files required: BBSINFO.LBR (members listed below) *)
(*                                                                 *)
(*  The following files are created by the program:                *)
(*                              MESSAGES.BBS (Message table)       *)
(*                              FILES.BBS    (Files table)         *)
(*  Clear these periodically: / COMMENTS.BBS (Comments for Sysop)  *)
(*  They can grow quickly...  \ LOG.BBS      (call log file)       *)
(*                              IDS.BBS      (user list)           *)
(*                                                                 *)
(*  .TXT files are WordStar editable; .BBS files are program data  *)
(*  maintained by the program.                                     *)
(*  User SYSOP is automatically given sysop access on system.      *)
(*                                                                 *)
(*******************************************************************)

const
  version   = '1.05';

  clockin = true;  { Set to false if no clock available. }
  sectsin = true;  { Use to turn section feature on/off. }
  openBBS = true;  { Selects a private or public system. }

  messdrive = 'A:';  { Drive on which messages go }
  filedrive = 'B:';  { Drive for storing files }

  applying = 'B:BBSINFO/APPLYING.TXT';
  welcome  = 'B:BBSINFO/WELCOME.TXT';   {Info files:    }
  otherBBS = 'B:BBSINFO/BBSLIST.TXT';   {text before "/"}
  helpfile = 'B:BBSINFO/BBSHELP.TXT';   {is name of the }
  sysinfo  = 'B:BBSINFO/SYSINFO.TXT';   {.LBR library   }
  meetings = 'B:BBSINFO/MEETING.TXT';   {file with the  }
  bulletin = 'B:BBSINFO/BULLETIN.TXT';  {member filename}
  filehelp = 'B:BBSINFO/FILEHLP.TXT';   {after the "/". }
  mainmenu = 'B:BBSINFO/MAINMENU.TXT';
  readmenu = 'B:BBSINFO/READMENU.TXT';
  filemenu = 'B:BBSINFO/FILEMENU.TXT';
  editmenu = 'B:BBSINFO/EDITMENU.TXT';

  sysop   = 5;  { Access levels }
  reg     = 2;
  newuser = 1;
  twit    = 0;

  noecho    = false;
  echo      = true;
  null      = #0;
  abort     = #3;
  bell      = #7;
  bksp      = #8;
  tab       = #9;
  lnfd      = #10;
  cr        = #13;
  pause     = #19;
  esc       = #27;
  space     = ' ';

type
  name      = string[14];
  longname  = string[25];
  filbuffer = array[0..127] of byte;
  rate      = (slow,fast);
  line      = string[80];
  person    = string[27];
  long      = string[150];
  sysid     = record
                user: person;
                exfl: byte;
                lsto: name;
                lstm: integer;
                pass: name;
                acc:  byte;
                clr:  name;
                bsp:  char;
                lnf:  char;
                upc:  boolean;
                wid:  byte;
              end;
  log       = record
                who:  integer;
                when: name;
                done: name;
              end;
  yesno     = array[boolean] of string[3];

const yn: yesno = ('NO','YES');

var
  libfile:    file;
  libbuff:    filbuffer;
  libeof:     boolean;
  logfile:    file of log;
  logrec:     log;
  idfile:     file of sysid;
  idrec:      sysid;
  caller:     person;
  password,
  timeon,
  timeoff,
  cs,
  message:    name;
  baud:       rate;
  buffer:     long;
  access:     byte;
  libsects,
  usernum,
  lastmess,
  nextmess,
  charcount,
  lastspace,
  bufpointer,
  width:      integer;
  controls,
  printon,
  local,
  filesopen,
  messopen,
  caps,
  expert:     boolean;
  exitchar, bl, lf, bs     : char;
  sec,   onsec,   offsec   : byte;
  min,   onmin,   offmin   : byte;
  hour,  onhour,  offhour  : byte;
  date,  ondate,  offdate  : byte;
  month, onmonth, offmonth : byte;
  usesec, usemin, usehour  : integer;

{$I A:MACHDEP.INC}
{$I A:IO.INC}
{$I A:MAILSYS.INC}
{$I A:FILESYS.INC}
{$I A:BBS2.INC}

begin
  exitchar := space;
  local := false;
  resetbuff;
  setup;
  defaults;
  awaitcall;
  repeat
    if clockin then begin
      clock(onmonth, ondate, onhour, onmin, onsec);
      timeon := time(onmonth, ondate, onhour, onmin, onsec);
    end;
    flush;
    resetbuff;
    lineout('TurboBBS version ' + version);
    if cts and not cancelled then outfile(welcome);
    if cts and not cancelled then outfile(bulletin);
    if cts then signon(caller);
    if cts then initmess;
    readmine; {checks for cts internally}
    if cts then command;
    writeln('hung up...');
    endcall;
    if messopen then closemess;
    close(idfile);
    unload;
    defaults;
    awaitcall;
  until exitchar = abort;
end.

