(*--------------------------------------------------------------------------*)
(*                 TestInvN --- Test inverse normal                         *)
(*--------------------------------------------------------------------------*)

PROGRAM TestInvN;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*   Program:  TestInvN                                                     *)
(*                                                                          *)
(*   Purpose:  Demonstrate inverse normal routine in PIBSIGS                *)
(*                                                                          *)
(*   Usage:    This program prompts for a tail probability value.           *) )
(*             It computes and prints the corresponding percentage point    *)
(*             of the normal distribution.                                  *)
(*                                                                          *)
(*             To stop the program, enter a negative p-value.               *)
(*                                                                          *)
(*   Calls:    Ninv2                                                        *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

VAR
   Z:    REAL;
   P:    REAL;
   Done: BOOLEAN;

(*$I SIGCONST.PAS *)
(*$I ERF.PAS      *)
(*$I SIGNORM.PAS  *)
(*$I NINV.PAS     *)
(*$I NINV2.PAS    *)

BEGIN (* TestInvN *)

   Done := FALSE;
   ClrScr;

   REPEAT

      WRITE('Enter tail probability: ');
      READLN( P );

      IF ( P > 0.0 ) THEN
         BEGIN
            Z     := Ninv2( P );
            WRITELN('Normal distribution percentage point = ',Z:12:5);
         END
      ELSE
         Done := TRUE;

   UNTIL Done;


END   (* TestInvN *).