(*-------------------------------------------------------------------------*)
(*              SigNorm  -- Significance of normal distribution            *)
(*-------------------------------------------------------------------------*)

FUNCTION SigNorm( X : REAL ) : REAL;

(*-------------------------------------------------------------------------*)
(*                                                                         *)
(*       Function:  SigNorm                                                *)
(*                                                                         *)
(*       Purpose:   Evaluates normal distribution probability              *)
(*                                                                         *)
(*       Calling Sequence:                                                 *)
(*                                                                         *)
(*            P     := SigNorm( X );                                       *)
(*                                                                         *)
(*                 X      --- ordinate of normal distribution              *)
(*                                                                         *)
(*                 P      --- Resultant tail probability                   *)
(*                                                                         *)
(*       Calls:                                                            *)
(*                                                                         *)
(*            Erf                                                          *)
(*                                                                         *)
(*       Method:                                                           *)
(*                                                                         *)
(*            The simple relationship between the error function and the   *)
(*            normal distribution is used.                                 *)
(*                                                                         *)
(*-------------------------------------------------------------------------*)

BEGIN (* SigNorm *)

   IF X >= 0.0 THEN
      SigNorm := 1.0 - ( 1.0 + Erf(  X / Sqrt2 ) ) / 2.0
   ELSE
      SigNorm := 1.0 - ( 1.0 - Erf( -X / Sqrt2 ) ) / 2.0;

END   (* SigNorm *);
