#include <stdio.h>
#include "common.h"

int	main(argc,argv)
int	argc;
char	**argv;
{
 if (argc != 2)
 {
  fprintf(stderr,"Usage: %s file.dat\n",argv[0]);
  exit(1);
 }

 data_load();
 map2txt(argv[1]);

 exit(0);
}

int	map2txt(orig)
char	*orig;
{
 int	size;

 size = file_load(orig);
 /* try to load file into memory buffer */

 if (size <= 0)
 {
  fprintf(stderr,"map2txt(): failed to load %s map.\n",orig);
  exit(1);
 }

 m2t(orig,IN_TERR_FILE);
 m2o(orig,IN_OBJE_FILE);
 m2v(orig,IN_UNIT_FILE);
 m2p(orig,IN_PROD_FILE);
 m2s(orig,IN_SHOP_FILE);

 fprintf(stdout,".hex file[s] listed\n");
 fprintf(stdout,".txt file[s] listed\n");

 return (0);
}

int	bytes2terrain(b0,b1)
int	b0, b1;
{
 int	d = -1, loop;

 for (loop=0; loop<TERRs; loop++)
 {
  if ((b0 == terr_cde[loop][0]) && (b1 == terr_cde[loop][1]))
  {
   d = loop;
   break;
  }
 }

 return (d);
}
  
int	m2t(orig,name)
char	*name, *orig;
{
 FILE	*tmp, *fopen();
 byte	x, y, b0, b1;
 int	cd, lx, ly, offset, d;

 tmp = fopen(name,"w");
 /* output file */

 if (tmp == NULL)
 {
  fprintf(stderr,"m2t(): unable to open %s as output.\n",name);
  exit(1);
 }

 x = databuffer[0x266];
 y = databuffer[0x268];
 cd = 0x26A;

 fprintf(tmp,"Terrain Map of %s\n",orig);
 fprintf(tmp,"rows %d cols %d\n",y,x);
 fprintf(tmp,"   ");
 for (lx=0; lx<x; lx += 1)
  fprintf(tmp,"%2d ",lx);
 fprintf(tmp,"\n");

 for (ly=0; ly<y; ly++)
 {
  offset = x*2*ly;

  fprintf(tmp,"%2d ",ly);

  for (lx=0; lx<x; lx += 2)
  {
   b0 = databuffer[cd+offset+lx*2];
   b1 = databuffer[cd+offset+lx*2+1];

   d = bytes2terrain(b0,b1);
   fprintf(tmp,"%s>-<",terr_idx[d]);
  }
  /* 1st pass [odd] */

  fprintf(tmp," %2d\n",ly);
  fprintf(tmp,"   ");

  for (lx=1; lx<x; lx += 2)
  {
   b0 = databuffer[cd+offset+lx*2];
   b1 = databuffer[cd+offset+lx*2+1];

   d = bytes2terrain(b0,b1);
   fprintf(tmp,">-<%s",terr_idx[d]);
  }
  /* 2nd pass [even] */

  fprintf(tmp,"\n");
 }
 fprintf(tmp,"   ");
 for (lx=0; lx<x; lx += 1)
  fprintf(tmp,"%2d ",lx);
 fprintf(tmp,"\n");
 fclose(tmp);

 return(0);
}

int	bytes2object(b0,b1)
int	b0, b1;
{
 int	d = -1, loop;

 for (loop=0; loop<OBJEs; loop++)
 {
  if ((b0 == obje_cde[loop][0]) && (b1 == obje_cde[loop][1]))
  {
   d = loop;
   break;
  }
 }

 return (d);
}
  

int	m2o(orig,name)
char	*name, *orig;
{
 FILE	*tmp, *fopen();
 byte	x, y, b0, b1;
 int	cd, lx, ly, offset, d;

 tmp = fopen(name,"w");
 /* output file */

 if (tmp == NULL)
 {
  fprintf(stderr,"m2o(): unable to open %s as output.\n",name);
  exit(1);
 }

 x = databuffer[0x266];
 y = databuffer[0x268];
 cd = 0x26A + x*y*2;

 fprintf(tmp,"Object Map of %s\n",orig);
 fprintf(tmp,"rows %d cols %d\n",y,x);
 fprintf(tmp,"   ");
 for (lx=0; lx<x; lx += 1)
  fprintf(tmp,"%2d ",lx);
 fprintf(tmp,"\n");

 for (ly=0; ly<y; ly++)
 {
  offset = x*2*ly;

  fprintf(tmp,"%2d ",ly);

  for (lx=0; lx<x; lx += 2)
  {
   b0 = databuffer[cd+offset+lx*2];
   b1 = databuffer[cd+offset+lx*2+1];

   if ((b0 == 255) && (b1 == 255))
    fprintf(tmp,"   >-<");
   else
   {
    d = bytes2object(b0,b1);
    fprintf(tmp,"%s>-<",obje_idx[d]);
   }
  }
  /* 1st pass [odd] */

  fprintf(tmp," %2d\n",ly);
  fprintf(tmp,"   ");

  for (lx=1; lx<x; lx += 2)
  {
   b0 = databuffer[cd+offset+lx*2];
   b1 = databuffer[cd+offset+lx*2+1];

   if ((b0 == 255) && (b1 == 255))
    fprintf(tmp,">-<   ");
   else
   {
    d = bytes2object(b0,b1);
    fprintf(tmp,">-<%s",obje_idx[d]);
   }
  }
  /* 2nd pass [even] */

  fprintf(tmp,"\n");
 }
 fprintf(tmp,"   ");
 for (lx=0; lx<x; lx += 1)
  fprintf(tmp,"%2d ",lx);
 fprintf(tmp,"\n");
 fclose(tmp);

 return(0);
}

int	byte2player(b1)
int	b1;
{
 int	d;

 switch (b1)
 {
  case 1:
   d = 0;
   break;

  case 2:
   d = 1;
   break;

  case 4:
   d = 2;
   break;

  case 8:
   d = 3;
   break;

  case 16:
   d = 4;
   break;

  case 32:
   d = 5;
   break;

  default:
   d = 9;
   break;
 }
 return(d);
}

int	m2v(orig,name)
char	*name, *orig;
{
 FILE	*tmp, *fopen();
 byte	x, y, b0, b1;
 int	cd, lx, ly, offset, d;

 tmp = fopen(name,"w");
 /* output file */

 if (tmp == NULL)
 {
  fprintf(stderr,"m2v(): unable to open %s as output.\n",name);
  exit(1);
 }

 x = databuffer[0x266];
 y = databuffer[0x268];
 cd = 0x26A + x*y*4;

 fprintf(tmp,"Vehicle Map of %s\n",orig);
 fprintf(tmp,"rows %d cols %d\n",y,x);
 fprintf(tmp,"   ");
 for (lx=0; lx<x; lx += 1)
  fprintf(tmp,"%2d ",lx);
 fprintf(tmp,"\n");

 for (ly=0; ly<y; ly++)
 {
  offset = x*2*ly;

  fprintf(tmp,"%2d ",ly);

  for (lx=0; lx<x; lx += 2)
  {
   b0 = databuffer[cd+offset+lx*2];
   b1 = databuffer[cd+offset+lx*2+1];

   d = byte2player(b1);
   if (b0 != 255)
    fprintf(tmp,"%s%d>-<",unit_idx[b0],d);
   else
    fprintf(tmp,"   >-<");
  }
  /* 1st pass [odd] */

  fprintf(tmp," %2d\n",ly);
  fprintf(tmp,"   ");

  for (lx=1; lx<x; lx += 2)
  {
   b0 = databuffer[cd+offset+lx*2];
   b1 = databuffer[cd+offset+lx*2+1];

   d = byte2player(b1);
   if (b0 != 255)
    fprintf(tmp,">-<%s%d",unit_idx[b0],d);
   else
    fprintf(tmp,">-<   ");
  }
  /* 2nd pass [even] */

  fprintf(tmp,"\n");
 }
 fprintf(tmp,"   ");
 for (lx=0; lx<x; lx += 1)
  fprintf(tmp,"%2d ",lx);
 fprintf(tmp,"\n");
 fclose(tmp);

 return(0);
}

int	file_load(name)
char*	name;
{
 FILE	*tmp, *fopen();
 int	size;

 tmp = fopen(name,"rb");
 if (tmp == NULL)
 {
  fprintf(stderr,"fileload(): unable to open %s map.\n",name);
  exit(1);
 }

 fread(databuffer,BUFSIZE,1,tmp);
 /* read whole file into memory */

 size = ftell(tmp);
 /* file size */

 fclose(tmp);

 fprintf(stdout,".dat file[s] loaded\n"); 
 return(size);
}

int	m2p(orig,name)
char	*name, *orig;
{
 FILE	*tmp, *fopen();
 int	loop;
 word	value;

 tmp = fopen(name,"w");
 /* output file */

 if (tmp == NULL)
 {
  fprintf(stderr,"m2p(): unable to open %s as output.\n",name);
  exit(1);
 }

 fprintf(tmp,"Production List of %s\n",orig);

 for(loop=0; loop<UNITs; loop++)
 {
  value = databuffer[0x1b2+loop*2];
  /* retrieve value */

  fprintf(tmp,"%-25s %d\n",unit_dsc[loop],value);
 }
 fclose(tmp);
 return(0);
}

int	m2s(orig,name)
char	*name, *orig;
{
 FILE	*tmp, *fopen();
 int	x, y, loop, offset, block, shops, type;
 byte	lo, hi;
 int	pos, lx, ly, stype1, slot;
 int	cd_o, cd_u;
 int	*ppp;

 x = databuffer[0x266];
 y = databuffer[0x268];
 cd_o = 0x26A + x*y*2;
 cd_u = 0x26A + x*y*4;

 tmp = fopen(name,"w");
 /* output file */

 if (tmp == NULL)
 {
  fprintf(stderr,"m2s(): unable to open %s as output.\n",name);
  exit(1);
 }

 shops = databuffer[0x26a+4+x*y*6] + 256*databuffer[0x26a+5+x*y*6];
 /* shop no# */

 fprintf(tmp,"Shop List of %s\n",orig);
 fprintf(tmp,"shops %d\n",shops);

 offset = 0x26a+6+x*y*6;
 /* offset to 1st shop */

 for (loop=0; loop<shops; loop++)
 {
  block = offset + loop*0x50;
  /* current offset */

  type = databuffer[block];
  /* shop type */

  fprintf(tmp,"***type\t\t%4d\n",type);

  switch (type)
  {  
   case 0x01:
    lo = databuffer[block+2];
    hi = databuffer[block+3];
    pos = lo+hi*256;
    ly = pos/0x40;
    lx = pos - ly*0x40;
    /* retrieve position */

    fprintf(tmp," row/col\t%4d %4d\n",ly,lx);
    /* map position */

    stype1 = databuffer[block+4];
    switch (stype1)
    {
     case 0x01:
      fprintf(tmp," object H ");
      lo = databuffer[cd_o+x*ly*2+lx*2];
      hi = databuffer[cd_o+x*ly*2+lx*2+1];
      if (lo != 0xff)
       fprintf(tmp,"   %s\n",obje_idx[bytes2object(lo,hi)]);
      else
       fprintf(tmp,"   ???\n");
      break;

     case 0x02:
      fprintf(tmp," object P ");
      lo = databuffer[cd_o+x*ly*2+lx*2];
      hi = databuffer[cd_o+x*ly*2+lx*2+1];
      if (lo != 0xff)
       fprintf(tmp,"   %s\n",obje_idx[bytes2object(lo,hi)]);
      else
       fprintf(tmp,"   ???\n");
      break;

     case 0x04:
      fprintf(tmp," object C ");
      lo = databuffer[cd_o+x*ly*2+lx*2];
      hi = databuffer[cd_o+x*ly*2+lx*2+1];
      if (lo != 0xff)
       fprintf(tmp,"   %s\n",obje_idx[bytes2object(lo,hi)]);
      else
       fprintf(tmp,"   ???\n");
      break;

     case 0x08:
      fprintf(tmp," object T ");
      lo = databuffer[cd_o+x*ly*2+lx*2];
      hi = databuffer[cd_o+x*ly*2+lx*2+1];
      if (lo != 0xff)
       fprintf(tmp,"   %s\n",obje_idx[bytes2object(lo,hi)]);
      else
       fprintf(tmp,"   ???\n");
      break;

     case 0x10:
      fprintf(tmp," object B ");
      lo = databuffer[cd_o+x*ly*2+lx*2];
      hi = databuffer[cd_o+x*ly*2+lx*2+1];
      if (lo != 0xff)
       fprintf(tmp,"   %s\n",obje_idx[bytes2object(lo,hi)]);
      else
       fprintf(tmp,"   ???\n");
      break;

     case 0x20:
      fprintf(tmp," object U ");
      lo = databuffer[cd_u+x*ly*2+lx*2];
      hi = databuffer[cd_u+x*ly*2+lx*2+1];
      if (lo != 0xff)
       fprintf(tmp,"   %s\n",unit_idx[lo]);
      else
       fprintf(tmp,"   ???\n");
      break;

     default:
      fprintf(stderr,"m2s(): unknown object type in shop %d\n",loop);
      exit(1);
      break;
    }
    /* building type */

    lo = databuffer[block+0x32];
    hi = databuffer[block+0x33];
    switch(hi)
    {
     case 0x00:
      fprintf(tmp," struct U\n");	/* use 0x0000 */
      break;

     case 0x01:
      fprintf(tmp," struct H\n");
      break;

     case 0x02:
      fprintf(tmp," struct A\n");
      break;

     case 0x04:
      fprintf(tmp," struct S\n");
      break;

     case 0x08:
      fprintf(tmp," struct F\n");
      break;
  
     case 0x10: 
      fprintf(tmp," struct C\n");
      break;
  
     case 0x20: 
      fprintf(tmp," struct B\n");
      break;
 
     case 0x40:
      fprintf(tmp," struct T\n");
      break;
 
     case 0x80:
      fprintf(tmp," struct ?\n");
      break;
 
     default:
      fprintf(tmp," struct -\n");
      break;
    }
    /* subtype */

    fprintf(tmp," id\t\t%4d\n",databuffer[block+8]);
    /* shop id */

    fprintf(tmp," =energy\t%4d\n",databuffer[block+12]);
    fprintf(tmp," =raw_mt\t%4d\n",databuffer[block+14]);
    lo = databuffer[block+16];
    fprintf(tmp," +energy\t%4d\n",lo);
    lo = databuffer[block+17];
    fprintf(tmp," +raw_mt\t%4d\n",lo);

    for(slot=0; slot<16; slot++)
    {
     lo = databuffer[block+18+slot*2];
     hi = databuffer[block+18+slot*2+1];
  
     if (lo != 0xff)
      fprintf(tmp,"  slot %s\n",unit_idx[lo]);
     else
      break;
    }
    fprintf(tmp,"  <\n");
    /* the 16 slots */

    for(slot=0; slot<4; slot++)
    {
     lo = databuffer[block+52+slot*2];
     if (lo)
      fprintf(tmp,"  prod %s\n",unit_idx[lo]);
     else
      break;
    }
    fprintf(tmp,"  <\n");
    /* jolly slots */

    lo = databuffer[block+0x3e];
    hi = databuffer[block+0x3f];
    fprintf(tmp," score\t\t%4d\n",(lo+hi*256));
    /* score value */

    lo = databuffer[block+0x40];
    fprintf(tmp," owner\t\t%4d\n",byte2player(lo));

    break;

   case 0x02:
    lo = databuffer[block+2];
    hi = databuffer[block+3];
    pos = lo+hi*256;
    ly = pos/0x40;
    lx = pos - ly*0x40;
    /* retrieve position */

    fprintf(tmp," row/col\t%4d %4d\n",ly,lx);
    /* map position */

    lo = databuffer[block+0x48];
    hi = databuffer[block+0x49];
    fprintf(tmp," w0x48\t\t%4d\n",(lo+hi*256));
    /* score value */

    lo = databuffer[block+0x4a];
    hi = databuffer[block+0x4b];
    fprintf(tmp," w0x4a\t\t%4d\n",(lo+hi*256));
    /* score value */

    lo = databuffer[block+0x4c];
    hi = databuffer[block+0x4d];
    fprintf(tmp," w0x4c\t\t%4d\n",(lo+hi*256));
    /* score value */
    break;

   default:
    fprintf(tmp,"not implemented\n");
    break;
  }
 }

 fclose(tmp);
 return(0);
}
