/*
 * Lister - a program to display vat control messages
 *
 * Usage: lister [multicast address] [port]
 *
 *   Lister is a primarly useless program that I hacked together to
 * prove that my multicast code was recieving correctly. It will list
 * the contents of all of the vat control messages on the address/port
 * pair specified. The default is for MBone Audio, but using the 
 * command line arguments, you can specify any session. FYI: The port that
 * is specified on the vat command line or in the options panel is the 
 * data port. The control port, the port lister takes, is the one immediately
 * above that. Any keypress will cause lister to exit.
 *
 * Jim Martin
 * jim@noc.rutgers.edu
 * 11/10/93
 */



#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <conio.h>
#include <tcp.h>

/* as taken from Van's message in rem-conf on Wed July 8, 1992 */
struct CtrlMsgHdr {
  unsigned char version:2;
  unsigned char flags:6;
  unsigned char type;
  unsigned short confid;
};



void main(int argc, char **argv)
{
    udp_Socket telsock;
    static udp_Socket *s;
    longword host;
    int status;
    word port;
    char buffer[8192];
    char spare[1500];
    struct CtrlMsgHdr *control;

	/* override defaults with command line if available */
	if (argc>1)
		host=resolve(argv[1]);
	else
	        host = resolve("224.2.0.1");

	if (argc>2)
		port=atoi(argv[2]);
	else
		port=3457;

	sock_init();

	s = (udp_Socket *)&telsock;


        /* Open the udp connection (?!) */
	if( !udp_open( s, port, host, port, NULL)){
		printf("Unable to open udp connection\n");
		exit(0);
	}

        /* Join the multicast group */
	if( ! join_mcast_group( host ))
	       printf("Unable to join group!!!\n");

	if ( sock_recv_init(s,buffer,sizeof( buffer ))){
		printf("Could not enable large buffers!\n");
		exit(3);
	}

        /* turn off UDP checksums */
	sock_mode( s, UDP_MODE_NOCHK );

        /* loop through until someone whacks a key */
	while ( !kbhit() ){
		tcp_tick(NULL);

		if( sock_recv( s, spare, sizeof( spare ))){
		        control = (struct CtrlMsgHdr *)spare;
			printf("Vers: %u Flags: %u Type: %u ConfID: %u ID: %s \n",
			       control->version, control->flags,
			       control->type, ntohs(control->confid),
			       spare+sizeof(struct CtrlMsgHdr));
		}

	}

sock_err:
	sock_close( s );

        /* leave the multicast group */
	if( ! leave_mcast_group( host ))
	        printf("Unable to leave group!!!\n");

	exit( 0 );
}






