/*++
/* NAME
/*	spoolfil,metafile 3
/* SUMMARY
/*	create message file and meta file
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	general utilities
/* SYNOPSIS
/*	int spoolfil(mesg,meta_info,mesg_prefix,meta_prefix)
/*	char *mesg;
/*	char *meta_info;
/*	char *mesg_prefix;
/*	char *meta_prefix;
/*
/*	int metafile(string,path)
/*	char *string;
/*	char *path;
/* DESCRIPTION
/*	spoolfil() creates a message, meta file pair in the spool
/*	directory. 
/*
/*	"mesg" should be null-terminated string with the name of an existing 
/*	file. The contents of that file are filtered to produce a
/*	clean ASCII file.
/*
/*	"meta-info" is a string with additional information that is 
/*	written to a meta file (usually name of mail recipient, mail
/*	originator or a comment describing the contents of the message file).
/*
/*	"mesg_prefix," "meta_prefix" are strings that will be used for building
/*	names for files in the spool directory.
/*
/*	metafile() creates a file, writes a string to it and terminates
/*	the file with a newline character. This function is typically used
/*	to create a file with meta information (mail originator, message
/*	summary etc.).
/* FUNCTIONS AND MACROS
/*	ascopen(), ascget(), ascclose(), newseqno()
/* DIAGNOSTICS
/*	A nonzero return value indicates an error condition (see status.h)
/* SEE ALSO
/*	status(5)	return values
/*	ascf(3)		ASCII filter
/* BUGS
/*	Wordprocessor control codes etc will be lost when spoolfil copies 
/*	a file.
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Mon May 18 18:45:10 GMT+1:00 1987
/* LAST MODIFICATION
/*	Mon Apr  4 23:50:14 MET 1988
/* VERSION/RELEASE
/*	1.3
/*--*/

#include "defs.h"
#include "path.h"
#include "ascf.h"
#include "status.h"

/* metafile - create a one-liner file */

public int metafile(string,file)
char *string;
char *file;
{
    register FILE *fp;

    if ((fp = fopen(file,"w")) == 0) {
	return(E_WRITERR);
    } else if (fprintf(fp,"%s\n",string),ferror(fp)) {
	fclose(fp);
	return(E_WRITERR);
    } else {
	fclose(fp);
	return(0);
    }
}
	
/* spoolfil - make arbitrary spool file */

public int spoolfil(fname,meta,msgpfx,auxpfx)
char *fname;
char *meta;
char *msgpfx;
char *auxpfx;
{
    register int newid = newseqno();			/* new message id */
    register int stat;					/* some status */
    char *msgpath;					/* new message file */
    char *auxpath;					/* new meta file */

    msgpath = mesg_file(msgpfx,newid);			/* message file path */
    auxpath = meta_file(auxpfx,newid);			/* meta file path */

    /* copy disk file to spool file, check for errors */

    if (stat = copyfile(fname,msgpath)) {		/* read/write error */
	unlink(msgpath);				/* delete msg file */
	return(stat);					/* notify caller */

    /* create file for meta information, check for errors */

    } else if (stat = metafile(meta,auxpath)) {		/* metafile error */
	unlink(msgpath);				/* delete msg file */
	unlink(auxpath);				/* delete meta file */
	return(stat);					/* notify caller */

    /* when nothing went wrong */

    } else {
	chmod(msgpath,0444);				/* message read-only */
	chmod(auxpath,0444);				/* metafile read-only */
	return(0);					/* own error handling */
    }
}

/* copyfile - copy a file and filter it */

public int copyfile(from,to)
char *from;
char *to;
{
    register FILE *in,*out;			/* file pointers */
    int rerr,werr;				/* error status */

    if ((in = ascopen(from,"r")) == 0) {	/* cannot read ?? */
	return(E_READERR);
    } else if ((out = fopen(to,"w")) == 0) {	/* cannot write */
	ascclose(in);
	return(E_WRITERR);
    } else {
	register int c;
	while ((c = ascget(in)) != EOF)		/* ASCII filter */
	   putc(c,out);
	rerr = ferror(in);			/* check read status */
	werr = ferror(out);			/* check write status */
	ascclose(in);
	fclose(out);
	if (rerr) {
	    return(E_READERR);
	} else if (werr) {
	    return(E_WRITERR);
	} else {
	    return(0);
	}
    }
}
