/*++
/* NAME
/*      smail 1
/* SUMMARY
/*      mail spooler
/* PROJECT
/*      pc-mail
/* PACKAGE
/*      smail
/* SYNOPSIS
/*      smail file destinations
/* DESCRIPTION
/*      smail makes preparations to send a copy of a text file
/*	across the network.
/*
/*	The contents of the original file are filtered in order to
/*	get rid of control characters, high most-significant bits,
/*	or non-standard carriage-control conventions. The filter
/*	has no effect on ordinary flat text files, such as program 
/*	sources.
/*
/*	Aliases in the list of destinations are expanded, and multiple
/*	occurrances of the same recipient are eliminated. The algorithms
/*	that manipulate the list of destinations are case-insensitive.
/* FILES
/*	In the spool directory. Files that belong together have the
/*	same sequence number in their name.
/*      D<seqno>	message body (data file)
/*	X<seqno>	destinations (meta file)
/* SEE ALSO
/*	ascf(3)		ASCII filter
/*	spoolfile(3)	create data-file/meta-file pair
/*      path(5)         system-dependent path names
/*	unalias(3)	alias expansion and cleanup
/* DIAGNOSTICS
/*      Error messages if invoked with insufficient arguments.
/*      The program terminates with a nonzero exit status if 
/*      problems were detected (out of memory, file access problems,
/*	loops in the alias data base). The exit status indicates the
/*	nature of the problem.
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*      Mon Apr  6 16:58:42 GMT+1:00 1987
/* LAST MODIFICATION
/*	Wed Apr  6 00:22:39 MET 1988
/* VERSION/RELEASE
/*	1.4
/*--*/

#include "defs.h"
#include "path.h"
#include "status.h"

extern char **unalias();

main(argc,argv)
int argc;
char **argv;
{
    int stat = 0;				/* pathinit() status code */
    char **vec;					/* final destinations vector */
    char *str;					/* final destinations string */

    if (argc <= 2) {
	fprintf(stderr,"usage: smail filename destination(s)\n");
	exit(1);
    } else if (stat = pathinit()) {		/* check environment vars */
	exit(stat);
    } else if ((vec = unalias(argv+2)) == 0) {	/* process destinations list */
	exit(E_SYSFAIL);
    } else if (vec[BUFSIZ-1]) {			/* destination list overflow */
	exit(E_OVALIAS);
    } else if ((str = vecstr(vec," ")) == 0) {	/* list -> string conversion */
	exit(E_SYSFAIL);
    } else {
	exit(sendmail(argv[1],str));		/* make spool files */
    }
    /* NOTREACHED */
}
