/*++
/* NAME
/*	setup 3
/* SUMMARY
/*	edit/display configuration parameters
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	mailsh
/* SYNOPSIS
/*	#include "mailsh.h"
/*
/*	int setup()
/* DESCRIPTION
/*	The functions in this module handle the configurations file with 
/*	communications parameters.
/*
/*	setup() starts a dialogue with the user. It allows the user to
/*	select a parameter and enter a new value. All modifications are
/*	done in core (pager file). Upon exit, the setup is written to 
/*	disk if any changes were made.
/* FUNCTIONS AND MACROS
/*	open_pager(), app_pager(), gets_pager(), puts_pager()
/*	kbdinp()
/* FILES
/*	In the spool directory: the configuration file s00000.
/* SEE ALSO
/*	cico(1)	communications program.
/* DIAGNOSTICS
/*	An error message if the setup file could not be created.
/* BUGS
/*	Does not check parameter values at all, just like the UUCP 
/*	configurations files L.sys etcetera.
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Wed Apr  8 15:16:18 GMT+1:00 1987
/* LAST MODIFICATION
/*	Mon Apr  4 23:49:37 MET 1988
/* VERSION/RELEASE
/*	1.3
/*--*/

#include "defs.h"
#include "path.h"
#include "screen.h"
#include "mailsh.h"
#include "pager.h"
#include "params.h"
#include "status.h"
#include "window.h"

hidden void make_setup();			/* forward declarations */
hidden int change_setup();
hidden int pick_setup();
hidden int show_setup();

hidden File *setfile = 0;			/* memory! */
hidden Info *prmtable = 0;			/* more memory */
hidden int chgflag = 0;				/* more flags! */

/* setup - start dialogue */

public int setup()
{
    static Screen screen[] = {
	'C',	"Close",        0,      initscreen,
	PGUP,	PgUp,		pu_pager,pageup,
	PGDN,	PgDn,		pd_pager,pagedn,
	UP,	"Up",           up_pager,csrup,
	DOWN,	"Down",         dn_pager,csrdn,
	ENTER,	"Enter",        pick_setup,"Modify selected parameter",
	0,	0,              show_setup,
	"Select communications parameter with cursor keys, then press ENTER",
    };

    kbdinp(screen);				/* start dialogue */
    if (chgflag && cp_pager(parm_file())) {
	errdisp(E_WRITERR);			/* save failed */
    } else {
	chgflag = 0;				/* save succeeded */
    }
    close_pager(setfile);
    setfile = 0;
    return(S_REDRAW);				/* refresh screen */
}

/* show_setup - make setup display or use existing one */

hidden int show_setup()
{
    if (setfile == 0 || prmtable == 0) {	/* no setup display */
	prmtable = getparams();
	setfile = open_pager();
	make_setup();
    } else {					/* use existing display */
	set_pager(setfile);
    }
    ds_pager();					/* display it */
    return(0);
}

/* make_setup - create setup display */

hidden void make_setup()
{
    register File *f = setfile;
    register Info *i;

    for (i = prmtable; i->ident; i++)
	app_pager(f,strcons("%-20s %s",i->ident,i->strval ? i->strval : ""));
}

/* pick_setup - user has selected one parameter */

hidden int pick_setup()
{
    static Screen screen[] = {
	STRING,	0,              change_setup,int_error,
	0,	0,              0,
	"Press ESC to cancel. New parameter value:"
    };
    register char *sp = gets_pager();
    register Info *ip;

    for (ip = prmtable; ip->ident; ip++)		/* check id string */
	if (strncmp(ip->ident,sp,ip->length) == 0)
	    break;
    if (ip) {
	kbdinp(screen);					/* ask for new value */
	return(S_REDRAW);
    } else {
	beep();						/* bad id string */
	return(0);
    }
}

/* change_setup - enter new communications parameter value */

hidden int change_setup(newval)
char *newval;
{
    register char *sp = gets_pager();			/* read from display */
    register Info *ip;

    for (ip = prmtable; ip->ident; ip++) {		/* check id string */
	if (strncmp(ip->ident,sp,ip->length) == 0) {
	    puts_pager(strcons("%-20s %s",ip->ident,newval)); /* new entry */
	    chgflag = 1;				/* say change made */
	}
    }
    return(S_BREAK|S_REDRAW);				/* screen changed */
}
