/*++
/* NAME
/*	params 5
/* SUMMARY
/*	communication parameter definitions
/* PROJECT
/*	pc-mail
/* PACKAGE
/*	library
/* SYNOPSIS
/*	#include "params.h"
/* DESCRIPTION
/* .nf

/* /* 
* Identification strings for the external representation of the setup.
* The parameter setup is stored as a file, with one identification string
* and parameter value per line. The identification strings are the same
* ones as used by the mail shell (the Setup option in the initial screen).
*/

#define	PORT	"communications_port:"
#define	BAUD	"baud_rate:"
#define	HOST	"remote_host_name:"
#define	LOGIN	"login_name:"
#define	DIAL	"dialup_sequence:"
#define	DISC	"disconnect_sequence:"

/* /* Table offsets for the internal representation */

#define	P_PORT	0
#define	P_BAUD	1
#define	P_HOST  2
#define	P_LOGIN	3
#define	P_DIAL	4
#define	P_DISC	5

/* /* Structure of the in-core setup table. */

typedef struct {
    char *ident;		/* identification string */
    int length;			/* length of id string */
    char *strval;		/* string value of parameter */
} Info;

extern Info *getparams();	/* read setup file */
/* AUTHOR(S)
/*	W.Z. Venema
/*	Eindhoven University of Technology
/*	Department of Mathematics and Computer Science
/*	Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*	Wed Apr  8 15:39:23 GMT+1:00 1987
/* LAST MODIFICATION
/*	Mon Apr  4 23:47:08 MET 1988
/* VERSION/RELEASE
/*	1.3
/*--*/
