/*++
/* NAME
/*      newseqno 3
/* SUMMARY
/*      generate sequence number for spool file
/* PROJECT
/*      pc-mail
/* PACKAGE
/*      general
/* SYNOPSIS
/*      newseqno()
/* DESCRIPTION
/*      newseqno() deduces a new spool file sequence number by looking
/*	at the names of files in the spool directory.
/* BUGS
/*	A sequence file would be better; both for performance, and
/*	for collision detection.
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*      Sat Mar 28 18:10:53 GMT+1:00 1987
/* LAST MODIFICATION
/*	Mon Apr  4 23:45:54 MET 1988
/* VERSION/RELEASE
/*	1.3
/*--*/

#include "defs.h"
#include "path.h"
#include "dir.h"

/* newseqno - extract sequence number from existing spool file names */

public int newseqno()
{
    register int seqno = 0;
    register char *p;
    register int dd = opendir(maildir);
    int tmp = 0;

    /* needs locking mechanism on multi-tasking operating systems */

    while (p = readdir(dd)) {
	if (sscanf(p+sizeof(HDRPFX)-1,"%d",&tmp) == 1 && tmp > seqno)
	    seqno = tmp;
    }
    closedir(dd);
    return(seqno+1);
}
