/*++
/* NAME
/*      mailsh
/* SUMMARY
/*      visual mail-shell
/* PROJECT
/*      pc-mail
/* PACKAGE
/*      mail
/* SYNOPSIS
/*      mail
/* DESCRIPTION
/*      mail is an interactive program for reading, receiving
/*      and producing electronic mail. Actually, most of the work
/*	is done by programs called by the mail program.
/*
/*      By default, the program presents the user display of a list of
/*      mail messages in the form of one-line summaries. Single-key 
/*	commands are available to select and manipulate mail messages.
/*	Mail messages are created with an editor chosen by the user.
/*
/*      The name of the spool directory, printer program and editor
/*      are taken from the environment, or assume system-dependent defaults.
/* ENVIRONMENT
/*      MAILDIR		name of spool directory
/*      EDITOR          name of program to create mail
/*	MAILPRN		name of program/file to print with/to
/*	MAILCMD		command to execute upon termination
/* COMMANDS
/*      cico            network communications program
/*      rmail           postprocessor for mail received by cico
/* FILES
/*      The mail system maintains various files in a spool directory,
/*      as well as a logfile of all network transactions.
/* SEE ALSO
/*      path(3)         system-dependent path names
/* DIAGNOSTICS
/*      Error messages should be self-explanatory.
/* BUGS
/*      The user has to explicitly tell the system to contact a remote
/*	mail host. This is a limitation of MS-DOS, not of the program.
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*      Thu Apr  2 21:54:08 GMT+1:00 1987
/* LAST MODIFICATION
/*	Mon Apr  4 23:44:44 MET 1988
/* VERSION/RELEASE
/*	1.3
/*--*/

#include <signal.h>
#include "defs.h"
#include "path.h"
#include "status.h"
#include "mailsh.h"
#include "window.h"

/* forward declarations */

hidden int checkfiles();

/* for now, don't even try to look at command args */

public main(argc,argv)
int argc;
char **argv;
{
    register int stat;

    /* 
    * Initializations: get screen control and function-key codes (wininit).
    * check if the limit on the number of open files is ok (checkfiles),
    * get the values from environment variables (pathinit), set the
    * terminal driver to the desired mode (kbdinit), check for partally
    * processed new mail with the rmail program.
    * Also make sure that our file permissions are safe (umask).
    */

    if (!isatty(fileno(stdin))) {
	perror("mail: standard input");
	exit(1);
    }

    umask(022);				/* avoid problems */
    wininit();                          /* do termcap stuff */
    clrscreen();                         /* clear screen */
    (stat = checkfiles())		/* get max nbr of open files */
    || (stat = pathinit())		/* get spool, printer, editor */
    || (stat = invokelp(RMAIL,(char *)0));/* just in case there's mail */
    kbdinit();                          /* set to tty RAW, NOECHO */
    if (stat)
	errdisp(stat);			/* we have a problem */

    /* enter the main command loop */

    desk();				/* start the machine */

    /* finalizations */

    kbdrest();                          /* restore tty driver */
    clrscreen();                         /* clear screen */
    fflush(stdout);
    onexit(mailcmd);			/* do exit command */
    exit(0);                            /* huh?? */
    /* NOTREACHED */
}

/* checkfiles - make sure we can open as many files as we want */

hidden int checkfiles()
{
    register int i;
    int fds[MINFILES];
    register int stat;

    for (i = 0; i < MINFILES; i++)              /* try to open many files */
	if ((fds[i] = open(NULLDEV,0)) < 0)
	    break;

    stat = (i < MINFILES ? E_FILENO : 0);	/* did we fail? */

    while (--i >= 0)                            /* release files */
	close(fds[i]);
    return(stat);
}
