/*++
/* NAME
/*      cico 1
/* SUMMARY
/*      uucp file transfer
/* PROJECT
/*      pc-mail
/* PACKAGE
/*      cico
/* SYNOPSIS
/*      cico -p password [-d debuglevel]
/* DESCRIPTION
/*      cico is a program that connects to a real unix host
/*      for exchange of spool files. It is a simplified
/*	version of the unix uucico (copy-in-copy-out) program.
/*
/*	Options:
/* .TP
/*	-p password
/*	The password that cico will use when logging in on the
/*	unix host.
/* .TP
/*	-d debuglevel
/*      Set the debugging level. It makes both the local cico
/*      and the remote uucico more verbose. Default debugging
/*	level is 0.
/* FILES
/*      cico manipulates various files in the spool directory.
/*	See path(5) for the implementation of the message data base.
/*
/*      LOGFILE         transaction logging
/*	s00000		communications parameters
/* SEE ALSO
/*      comm(5)		communications parameters
/*	status(5)	error returns
/* DIAGNOSTICS
/*      The program terminates with a non-zero exit status if there
/*      were problems. The error status codes can be translated
/*	to meaningful messages (see status(5)).
/*      More technical messages are written to the logfile.
/* BUGS
/*	cico only supports the functions needed for exchange of
/*	electronic mail. Every incoming data file is treated as
/*	if it were a mail message for the user of the pc.
/* AUTHOR(S)
/*      W.Z. Venema
/*      Eindhoven University of Technology
/*      Department of Mathematics and Computer Science
/*      Den Dolech 2, P.O. Box 513, 5600 MB Eindhoven, The Netherlands
/* CREATION DATE
/*      Sat Mar 28 19:58:06 GMT+1:00 1987
/* LAST MODIFICATION
/*	Wed Apr  6 00:18:29 MET 1988
/* VERSION/RELEASE
/*	1.6
/*--*/

#include <setjmp.h>
#include "defs.h"
#include "logs.h"
#include "params.h"
#include "comm.h"
#include "status.h"
#include "path.h"

public int *systrap;                            /* panic button */
public int dflag = 0;                           /* debug flag */
#ifdef	unix
    public int Debug = 0;			/* UUCP compatibility */
#endif

hidden void parse_args(),sanity();              /* forward declarations */

/* main program - parse command line options and pull the ropes */

main(argc,argv)
int argc;
char **argv;
{
    register int status;                        /* most recent error code */
    jmp_buf mainbuf;                            /* catch-all */

    parse_args(argc,argv);                      /* process cmd arguments */

    sanity();                                   /* check systems parameters */

    if (setjmp(systrap = mainbuf))              /* safety net in case of */
	exit(E_CONFUSED);                       /* too many long jumps */

    xopen();                                    /* init comm. line */
    if ((status = connect()) == 0               /* login on remote system */
    && (status = startproto()) == 0) {          /* start comm. protocol */
	status = switcher(MASTER);              /* use the protocol */
	endproto();                             /* terminate the protocol */
    }                                           /* (ignore errors) */
    disconnect();                               /* as it says */
    xclose();                                   /* close comm. line */

    exit(status);
    /* NOTREACHED */
}

/* parse_args - take care of command-line arguments */

hidden void parse_args(argc,argv)
int argc;
char **argv;
{
    while (--argc && *++argv && **argv == '-') {
	switch (*++*argv) {
	case 'p':
	    if (--argc == 0)
		usage("missing password argument");
	    password = *++argv;
	    break;
	case 'd':
	    if (--argc == 0)
		usage("missing debugging level argument");
	    sscanf(*++argv,"%d",&dflag);
#ifdef	unix
	    Debug = 
#endif
	    dflag = ((dflag < 0 ? 0 : dflag) > 10 ? 10 : dflag);
	    break;
	default:
	    usage(strcons("invalid option: -%s",*argv));
	    break;
	}
    }
    if (argc > 0)
	usage(strcons("unexpected argument: %s",*argv));
}

/* sanity - some preliminary work; mainly checks on sanity */

hidden void sanity()
{
    register int status;
    register Info *ip;

    if (status = pathinit())                            /* check environment */
	exit(status);                                   /* bad environment */

    if (status = open_log())                            /* check the logfile */
	exit(status);                                   /* cannot write */

    for (ip = comm = getparams(); ip->ident; ip++) {    /* check param. file */
	if (ip->strval == 0 || ip->strval[0] == '\0')
	    exit(E_BADSETUP);                           /* incomplete setup */
	debug(6)("%s %s\n",ip->ident,ip->strval ? ip->strval : "");
    }
    if (password == 0 || *password == 0) 
	usage("no password specified");                 /* no password */

    strcpy(rmthost,ip[P_HOST].strval);			/* remote host name */
}

/* usage - print error message and usage string */

usage(str)
char *str;
{
    fprintf(stderr,"%s\nusage: cico -p password [-d debuglevel]\n",str);
    exit(2);
}
