/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
static char *sccsid = "@(#)quit.c	1.3 (Ames) 10/17/89";
#endif not lint

#include "popd.h"
#include "rcv.h"
#include <sys/stat.h>
#include <sys/file.h>

extern char *sys_errlist[];
extern int errno;

/*
 * Rcv -- receive mail rationally.
 *
 * Termination processing.
 */

/*
 * Save all of the undetermined messages at the top of "mbox"
 * Save all untouched messages back in the system mailbox.
 * Remove the system mailbox, if none saved there.
 */

quit(argc, argv)
char **argv;
{
	/*
	 * If we are read only, we can't do anything,
	 * so just return quickly.
	 */

	if (readonly)
		return 0;
	return edstop();
}

/*
 * Update - like quit except doesn't quit.
 */
updt(argc, argv)
char **argv;
{
	int i;

	if (edstop()) {
		printf("- %s\r\n", sys_errlist[errno]);
		return (-1);
	}

	/* mimic helo() */
	if ((i = setfile(def_folder, 1)) < 0) {
		if (i == -1)
			printf("#0 %s: %s\r\n", def_folder, sys_errlist[errno]);
		else
			printf("#0 unknown error %d\r\n", i);
		return (-1);
	}
	printf("#%d messages in %s\r\n", msgCount, mailname);
	return 0;
}
