/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
static char *sccsid = "%W% (Ames) %G%";
#endif not lint

#include "popd.h"
#include "rcv.h"
#include <pwd.h>
#include <errno.h>

#ifdef LASTLOG
#include <sys/file.h>
#include <lastlog.h>
static char llfile[] = LASTLOG;
#endif

extern int	errno;
extern char	*sys_errlist[];
struct	passwd *pwd, *copy_pwd();
extern char *malloc();

fold(argc, argv)
char **argv;
{
	int slen;
	char *folder;

	if (!logged_on) {
		printf("- Login with HELO first.\r\n");
		return (-1);
	}
	if (state == WAIT_FOR_ACK) {
		printf("- expecting ACKS, ACKD, or NACK\r\n");
		return (-1);
	}
	if (argc == 1)
		folder = def_folder;
	else
		folder = argv[1];
	if (setfile(folder, 1) < 0) {
		printf("#0 %s: %s\r\n", folder, sys_errlist[errno]);
		return (-1);
	}
	printf("#%d messages in %s\r\n", msgCount, mailname);
	return 0;
}

helo(argc, argv)
char **argv;
{
	int i;

	if (state == WAIT_FOR_ACK) {
		printf("- expecting ACKS, ACKD, or NACK\r\n");
		return (-1);
	}
	if (argc < 3) {
		printf("- Invalid arguments\r\n");
		return (-1);
	}
	if (check_user(argv[1], argv[2])) {
		return (-1);
	}
	if ((i = setfile(def_folder, 1)) < 0) {
		if (i == -1)
			printf("#0 %s: %s\r\n", def_folder, sys_errlist[errno]);
		else
			printf("#0 unknown error %d\r\n", i);
		return (-1);
	}
	if (newMsgs)
		printf("#%d messages, %d new\r\n", msgCount, newMsgs);
	else
		printf("#%d messages in %s\r\n", msgCount, mailname);
	return 0;
}

#include <sys/stat.h>

char *crypt();
static char folder[PATHSIZE];
extern char *hisname;
char *biffname = ".popd";
static time_t bifftime;

/* check out login information */
check_user (user, passwrd)
char *user, *passwrd;
{
	static short tries=0;
	FILE *fp;
	struct stat statb;
#ifdef LASTLOG
	int lastfd;
	struct lastlog lastlog;
#endif
	
	pwd = getpwnam(user);
	if (pwd == NULL ||
	    strcmp(crypt(passwrd, pwd->pw_passwd), pwd->pw_passwd)) {
		if (++tries == 3)
		    syslog(LOG_NOTICE, "repeated login attempts: %s", user);
		printf("- Login incorrect.\r\n");
		if (tries > 3)
			cleanup(0);
		return (-1);
	}

	pwd = copy_pwd(pwd);
	if (pwd == NULL) {
		printf("- %s\r\n", sys_errlist[errno]);
		cleanup(0);
	}

	/* got valid user here, become him... */
#ifdef LASTLOG
	if ((lastfd = open(llfile, O_WRONLY)) >= 0) {
		bzero(&lastlog, sizeof lastlog);
		time(&lastlog.ll_time);
		strcpy(lastlog.ll_line, "POP");
		if (hisname)
			strncpy(lastlog.ll_host, hisname,
			    sizeof lastlog.ll_host);
		if (lseek(lastfd, (off_t)pwd->pw_uid * sizeof lastlog,
		    L_SET)  < 0)
			/* error */;
		else
			write(lastfd, &lastlog, sizeof lastlog);
		(void)close(lastfd);
	}
#endif
	
	setgid (pwd->pw_gid);
	initgroups(user, pwd->pw_gid);
	setuid (pwd->pw_uid);
	strcpy(homedir, pwd->pw_dir);
	(void)chdir(pwd->pw_dir);
	if (hisname && (fp = fopen(biffname, "w"))) {
		fprintf(fp, "%s\n", hisname);
		fclose(fp);
		if (stat(biffname, &statb) >= 0)
			bifftime = statb.st_mtime;
	}

#ifdef SYSV
	strcpy(folder, "/usr/mail/");
#else
	strcpy(folder, "/usr/spool/mail/");
#endif
	strcat(folder, pwd->pw_name);
	def_folder = folder;
	logged_on = 1;
	strcpy(username, user);
	return(0) ;
}

name(argc, argv)
char **argv;
{
	struct passwd *pw;

	if (!logged_on && argc < 2) {
		printf("- Invalid arguments\r\n");
		return (-1);
	}
	if (argc < 2)
		pw = pwd;
	else
		pw = getpwnam(argv[1]);
	if (pw == NULL) {
		printf("- Unknown user\r\n");
		return (-1);
	}
	printf("%s\r\n", pw->pw_gecos);
	return 0;
}

dofrom(argc, argv)
char **argv;
{
	unixfrom = 1;
	printf("+ Will show unix From lines.\r\n");
}

cleanup(i)
{
	struct stat statb;

	if (hisname && bifftime && stat(biffname, &statb) >= 0 &&
	    bifftime == statb.st_mtime)
		(void)unlink(biffname);
	exit(i);
}

struct passwd *
copy_pwd(pw)
struct passwd *pw;
{
	struct passwd *ret;
	char *cp;

	ret = (struct passwd *)malloc(sizeof (struct passwd));
	if (ret == NULL)
		return NULL;
	*ret = *pw;
#define COPY(field) if (pw->pw_/**/field) { \
		cp = malloc(strlen(pw->pw_/**/field)+1); \
		if (cp == NULL) return NULL; \
		strcpy(cp, pw->pw_/**/field); \
		ret->pw_/**/field = cp; }
	COPY(name)
	COPY(passwd)
	COPY(gecos)
	COPY(dir)
	COPY(shell)
	return ret;
}
