/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
static char *sccsid = "%W% (Ames) %G%";
#endif not lint

#include "popd.h"
#include "rcv.h"
#include <sys/stat.h>
#include <sys/file.h>
#include <errno.h>
#include <ctype.h>

extern int errno;
extern char	*sys_errlist[];

/*
 * Mail -- a mail program
 *
 * File I/O.
 */

/*
 * Set up the input pointers while copying the mail file into
 * /tmp.
 */

setptr(ibuf, new)
	FILE *ibuf;
{
	register int c;
	register char *cp, *cp2;
	register int count, l;
	long s;
	off_t offset;
	char linebuf[LINESIZE];
	char wbuf[LINESIZE];
	int maybe, flag, inhead;
	int tlines;
	struct message *this, **last;

	if (new) {
		msgCount = 0;
		newMsgs = 0;
		offset = 0;
		while (message) {
			this = message;
			message = this->m_next;
			free(this);
		}
		last = &message;
	} else {
		fseek(otf, 0L, 2);
		offset = ftell(ibuf);
		for (last = &message; *last; last = &(*last)->m_next)
			;
	}
	s = 0L;
	l = 0;
	maybe = 1;
	flag = MUSED|MNEW;
	this = NULL;
	if (ibuf == NULL)
		return 0;	/* no mail */
	for (;;) {
		if (fgets(linebuf, LINESIZE, ibuf) == NULL) {
			if (this) {
				if (new && (flag & MNEW))
					newMsgs++;
				this->m_flag = flag;
				this->m_size = s;
				this->m_lines = l;
				if (this->m_tsize == -1)
					this->m_tsize = s + l;;
			}
			flag = MUSED|MNEW;
			fclose(ibuf);
			return 0;
		}
		count = strlen(linebuf);
		fputs(linebuf, otf);
		cp = linebuf + (count - 1);
		if (*cp == '\n')
			*cp = 0;
		if (ferror(otf))
			return (-1);
		if (maybe && linebuf[0] == 'F' && ishead(linebuf)) {
			if (this) {
				if (new && (flag & MNEW))
					newMsgs++;
				this->m_flag = flag;
				this->m_size = s;
				this->m_lines = l;
				if (this->m_tsize == -1)
					this->m_tsize = s + l;
			}
			this = (struct message *)
			    malloc(sizeof (struct message));
			if (this == 0) {
				perror("malloc");
				return -1;
			}
			if (dot == 0)
				dot = this;
			*last = this;
			last = &this->m_next;
			this->m_next = 0;
			msgCount++;
			this->m_num = msgCount;
			flag = MUSED|MNEW;
			inhead = 1;
			this->m_fromsize = count;
			this->m_block = blockof(offset);
			this->m_offset = offsetof(offset);
			this->m_tsize = -1;
			s = 0L;
			l = 0;
			tlines = 0;
		}
		if (inhead && linebuf[0] == 0 && this) {
			this->m_hsize = s;
			this->m_hlines = l;
			inhead = 0;
		}
		if (inhead && (cp = index(linebuf, ':'))) {
			*cp = 0;
			if (strcasecmp(linebuf, "status") == 0) {
				++cp;
				if (index(cp, 'R'))
					flag |= MREAD;
				if (index(cp, 'O'))
					flag &= ~MNEW;
			} else if (strcasecmp(linebuf, "x-lines") == 0) {
				++cp;
				while (isspace(*cp))
					cp++;
				tlines = atoi(cp) + 1;
			}
		}
		offset += count;
		s += (long) count;
		l++;
		if (!inhead && tlines && --tlines == 0)
			this->m_tsize = s + l;
		maybe = linebuf[0] == 0;
	}
}

/*
 * Drop the passed line onto the passed output buffer.
 * If a write error occurs, return -1, else the count of
 * characters written, including the newline.
 */

putline(obuf, linebuf)
	FILE *obuf;
	char *linebuf;
{
	register int c;

	c = strlen(linebuf);
	fputs(linebuf, obuf);
	putc('\n', obuf);
	if (ferror(obuf))
		return(-1);
	return(c+1);
}

/*
 * Read up a line from the specified input into the line
 * buffer.  Return the number of characters read.  Do not
 * include the newline at the end.
 */

readline(ibuf, linebuf)
	FILE *ibuf;
	char *linebuf;
{
	register int n;

	clearerr(ibuf);
	if (fgets(linebuf, LINESIZE, ibuf) == NULL)
		return(0);
	n = strlen(linebuf);
	if (n >= 1 && linebuf[n-1] == '\n')
		linebuf[n-1] = '\0';
	return(n);
}

/*
 * Return a file buffer all ready to read up the
 * passed message pointer.
 */

FILE *
setinput(mp)
	register struct message *mp;
{
	off_t off;

	fflush(otf);
	off = mp->m_block;
	off <<= 9;
	off += mp->m_offset;
	if (fseek(itf, off, 0) == -1) {
		perror("fseek");
		cleanup(1);
	}
	return(itf);
}

/*
 * Delete a file, but only if the file is a plain file.
 */

remove(name)
	char name[];
{
	struct stat statb;
	extern int errno;

	if (stat(name, &statb) < 0)
		return(-1);
	if ((statb.st_mode & S_IFMT) != S_IFREG) {
		errno = EISDIR;
		return(-1);
	}
	return(unlink(name));
}

/*
 * Open a temp file by creating, closing, unlinking, and
 * reopening.  Return the open file descriptor.
 */

opentemp(file)
	char file[];
{
	register int f;

	if ((f = creat(file, 0600)) < 0) {
		perror(file);
		return(-1);
	}
	close(f);
	if ((f = open(file, 2)) < 0) {
		perror(file);
		remove(file);
		return(-1);
	}
	remove(file);
	return(f);
}

/*
 * Determine the size of the file possessed by
 * the passed buffer.
 */

off_t
fsize(iob)
	FILE *iob;
{
	register int f;
	struct stat sbuf;

	f = fileno(iob);
	if (fstat(f, &sbuf) < 0)
		return(0);
	return(sbuf.st_size);
}

/*
 * Take a file name, possibly with shell meta characters
 * in it and expand it by using "sh -c echo filename"
 * Return the file name as a dynamic string.
 */

char *
expand(name)
	char name[];
{
	char xname[BUFSIZ];
	char cmdbuf[BUFSIZ];
	register int pid, l, rc;
	register char *cp, *Shell;
	int s, pivec[2], (*sigint)();
	struct stat sbuf;

	if (!anyof(name, "~{[*?$`'\"\\"))
		return(name);
	if (pipe(pivec) < 0) {
		perror("pipe");
		return(name);
	}
	sprintf(cmdbuf, "echo %s", name);
	if ((pid = vfork()) == 0) {
		sigchild();
		Shell = "/bin/sh";
		close(pivec[0]);
		close(1);
		dup(pivec[1]);
		close(pivec[1]);
		close(2);
		execl(Shell, Shell, "-c", cmdbuf, 0);
		_exit(1);
	}
	if (pid == -1) {
		perror("fork");
		close(pivec[0]);
		close(pivec[1]);
		return(NOSTR);
	}
	close(pivec[1]);
	l = read(pivec[0], xname, BUFSIZ);
	close(pivec[0]);
	while (wait(&s) != pid);
		;
	s &= 0377;
	if (s != 0 && s != SIGPIPE) {
		fprintf(stderr, "\"Echo\" failed\n");
		goto err;
	}
	if (l < 0) {
		perror("read");
		goto err;
	}
	if (l == 0) {
		fprintf(stderr, "\"%s\": No match\n", name);
		goto err;
	}
	if (l == BUFSIZ) {
		fprintf(stderr, "Buffer overflow expanding \"%s\"\n", name);
		goto err;
	}
	xname[l] = 0;
	for (cp = &xname[l-1]; *cp == '\n' && cp > xname; cp--)
		;
	*++cp = '\0';
	if (any(' ', xname) && stat(xname, &sbuf) < 0) {
		fprintf(stderr, "\"%s\": Ambiguous\n", name);
		goto err;
	}
	return(savestr(xname));

err:
	return(NOSTR);
}

/*
 * A nicer version of Fdopen, which allows us to fclose
 * without losing the open file.
 */

FILE *
Fdopen(fildes, mode)
	char *mode;
{
	register int f;
	FILE *fdopen();

	f = dup(fildes);
	if (f < 0) {
		perror("dup");
		return(NULL);
	}
	return(fdopen(f, mode));
}

/*
 * Set up editing on the given file name.
 * If isedit is true, we are considered to be editing the file,
 * otherwise we are reading our mail which has signficance for
 * mbox and so forth.
 */

setfile(name, isedit)
	char *name;
{
	FILE *ibuf;
	int i;
	struct stat stb;
	static int shudclob;
	extern char tempMesg[];

	if ((ibuf = fopen(name, "r")) == NULL)
		goto nomail;

	if (fstat(fileno(ibuf), &stb) < 0) {
		fclose(ibuf);
		return (-1);
	}

	switch (stb.st_mode & S_IFMT) {
	case S_IFDIR:
		fclose(ibuf);
		errno = EISDIR;
		return (-1);

	case S_IFREG:
		break;

	default:
		fclose(ibuf);
		errno = EINVAL;
		return (-1);
	}

	/* Release the old file. */
	if (shudclob)
		edstop();

	/*
	 * Copy the messages into /tmp
	 * and set pointers.
	 */

	readonly = 0;
	if ((i = open(name, 1)) < 0)
		readonly++;
	else
		close(i);
nomail:
	if (shudclob) {
		fclose(itf);
		fclose(otf);
	}
	shudclob = 1;
	if (name != mailname)
		strcpy(mailname, name);
	if (ibuf)
		mailsize = fsize(ibuf);
	else
		mailsize = 0;
	if ((otf = fopen(tempMesg, "w")) == NULL) {
		printf("- %s: %s\r\n", tempMesg, sys_errlist[errno]);
		cleanup(1);
	}
	if ((itf = fopen(tempMesg, "r")) == NULL) {
		printf("- %s: %s\r\n", tempMesg, sys_errlist[errno]);
		cleanup(1);
	}
	remove(tempMesg);
	i = setptr(ibuf, 1);
	if (ibuf)
		fclose(ibuf);
	if (i < 0)
		return -2;
	return(0);
}

demail()
{
	if (remove(mailname) < 0)
		close(creat(mailname, 0666));
}

/*
 * Terminate an editing session by attempting to write out the user's
 * file from the temporary.  Save any new stuff appended to the file.
 */
edstop()
{
	register int gotcha, c;
	register struct message *mp;
	FILE *obuf, *ibuf=NULL, *fbuf;
	struct stat statb;
	char tempname[30], *id;
	int (*sigs[3])();

	if (readonly)
		return 0;
	holdsigs();
	if ((fbuf = fopen(mailname, "r")) == NULL) {
		if (message == NULL || msgCount == 0) {
			relsesigs();
			return 0;
		}
	}
	if (fbuf)
		flock(fileno(fbuf), LOCK_EX);
	for (mp = message, c = 0, gotcha = 0; mp; mp = mp->m_next) {
		if (mp->m_flag & MNEW) {
			mp->m_flag &= ~MNEW;
			mp->m_flag |= MSTATUS;
		}
		if (mp->m_flag & (MODIFY|MDELETED|MSTATUS))
			gotcha++;
		if ((mp->m_flag & MDELETED) == 0)
			c++;
	}
	if (!gotcha)
		goto done;
	if (fstat(fileno(fbuf), &statb) >= 0 && statb.st_size > mailsize) {
		strcpy(tempname, "/tmp/mboxXXXXXX");
		mktemp(tempname);
		if ((obuf = fopen(tempname, "w")) == NULL) {
			perror(tempname);
			relsesigs();
			return (-1);
		}
		fseek(fbuf, mailsize, 0);
		while ((c = getc(fbuf)) != EOF)
			putc(c, obuf);
		fclose(obuf);
		if ((ibuf = fopen(tempname, "r")) == NULL) {
			perror(tempname);
			remove(tempname);
			relsesigs();
			return (-1);
		}
		remove(tempname);
	}
	if (fbuf == NULL && c == 0)
		goto done;
	if ((obuf = fopen(mailname, "r+")) == NULL) {
		relsesigs();
		return (-1);
	}
	c = 0;
	for (mp = message; mp; mp = mp->m_next) {
		if ((mp->m_flag & MDELETED) != 0)
			continue;
		c++;
		if (type_mail(mp, obuf) < 0) {
			perror(mailname);
			relsesigs();
			return (-1);
		}
	}
	gotcha = (c == 0 && ibuf == NULL);
	if (ibuf != NULL) {
		while ((c = getc(ibuf)) != EOF)
			putc(c, obuf);
		fclose(ibuf);
	}
	fflush(obuf);
	if (ferror(obuf)) {
		perror(mailname);
		relsesigs();
		return (-1);
	}
	trunc(obuf);
	fclose(obuf);
	fclose(fbuf);
	if (gotcha)
		demail();

done:
	relsesigs();
	return 0;
}

static int sigdepth = 0;		/* depth of holdsigs() */
static int omask = 0;
/*
 * Hold signals SIGHUP - SIGQUIT.
 */
holdsigs()
{
	register int i;

	if (sigdepth++ == 0)
		omask = sigblock(sigmask(SIGHUP)|sigmask(SIGINT)|sigmask(SIGQUIT));
}

/*
 * Release signals SIGHUP - SIGQUIT
 */
relsesigs()
{
	register int i;

	if (--sigdepth == 0)
		sigsetmask(omask);
}

newmail()
{
	FILE *ibuf;
	int	size;

	if ((ibuf = fopen(mailname, "r")) == NULL)
		return(-1);
	size = fsize(ibuf);
	if (size <= mailsize) {
		fclose(ibuf);
		return 0;
	}
	fseek(ibuf, mailsize, 0);
	mailsize = size;
	setptr(ibuf, 0);
}
