/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	%W% (Ames) %G%
 */

#ifdef SYSV
#include <sys/types.h>
#endif
#include <sys/param.h>		/* includes <sys/types.h> */
#include <signal.h>
#include <stdio.h>
#include <sgtty.h>
#ifdef SYSV
#define NOALLOCA
#include <string.h>
#include "fakesyslog.h"
#else
#include <syslog.h>
#endif

#undef isalpha
#undef isdigit

#ifdef sun
#ifndef NOALLOCA
#define NOALLOCA
#endif
#endif

/*
 * Mail -- a mail program
 *
 * Commands are:
 *	t <message list>		print out these messages
 *	r <message list>		reply to messages
 *	m <user list>			mail to users (analogous to send)
 *	e <message list>		edit messages
 *	c [directory]			chdir to dir or home if none
 *	x				exit quickly
 *	w <message list> file		save messages in file
 *	q				quit, save remaining stuff in mbox
 *	d <message list>		delete messages
 *	u <message list>		undelete messages
 *	h				print message headers
 *
 * Author: Kurt Shoens (UCB) March 25, 1978
 */


#define	PATHSIZE	1024		/* Size of pathnames throughout */
#define	LINESIZE	BUFSIZ		/* max readable line width */
#define	NOSTR		((char *) 0)	/* Null string pointer */
#define	equal(a, b)	(strcmp(a,b)==0)/* A nice function to string compare */

struct message {
	struct	message *m_next;	/* pointer to next message */
	int	m_num;			/* this message number */
	short	m_flag;			/* flags, see below */
	short	m_block;		/* block number of this message */
	short	m_offset;		/* offset in block of message */
	long	m_size;			/* Bytes in the message */
	long	m_hsize;		/* Bytes in header */
	long	m_tsize;		/* Bytes in text, from X-lines */
	short	m_lines;		/* Lines in the message */
	short	m_hlines;		/* Lines in header */
	short	m_fromsize;		/* Bytes in From line */
};

/*
 * flag bits.
 */

#define	MUSED		(1<<0)		/* entry is used, but this bit isn't */
#define	MDELETED	(1<<1)		/* entry has been deleted */
#define	MSAVED		(1<<2)		/* entry has been saved */
#define	MTOUCH		(1<<3)		/* entry has been noticed */
#define	MPRESERVE	(1<<4)		/* keep entry in sys mailbox */
#define	MMARK		(1<<5)		/* message is marked! */
#define	MODIFY		(1<<6)		/* message has been modified */
#define	MNEW		(1<<7)		/* message has never been seen */
#define	MREAD		(1<<8)		/* message has been read sometime. */
#define	MSTATUS		(1<<9)		/* message status has changed */
#define	MBOX		(1<<10)		/* Send this to mbox, regardless */

/*
 * Oft-used mask values
 */

#define	MMNORM		(MDELETED|MSAVED)/* Look at both save and delete bits */
#define	MMNDEL		MDELETED	/* Look only at deleted bit */

/*
 * Structure used to return a break down of a head
 * line (hats off to Bill Joy!)
 */

struct headline {
	char	*l_from;	/* The name of the sender */
	char	*l_tty;		/* His tty string (if any) */
	char	*l_date;	/* The entire date string */
};

/*
 * VM/UNIX has a vfork system call which is faster than forking.  If we
 * don't have it, fork(2) will do . . .
 */

#ifndef VMUNIX
#define	vfork()	fork()
#endif
#ifndef	SIGRETRO
#define	sigchild()
#endif

/*
 * 4.2bsd signal interface help...
 */
#ifdef VMUNIX
#define	sigset(s, a)	signal(s, a)
#define	sigsys(s, a)	signal(s, a)
#endif

/*
 * Truncate a file to the last character written. This is
 * useful just before closing an old file that was opened
 * for read/write.
 */
#define trunc(stream)	ftruncate(fileno(stream), (long) ftell(stream))

/*
 * Forward declarations of routine types to keep lint and cc happy.
 */

FILE	*Fdopen();
FILE	*popen();
FILE	*setinput();
char	*calloc();
char	*copy();
char	*copyin();
char	*expand();
char	*gets();
char	*hfield();
char	*index();
char	*name1();
char	*nextword();
char	*getenv();
char	*hcontents();
char	*rindex();
char	*rpair();
char	*salloc();
char	*savestr();
char	*skin();
char	*snarf();
char	*strcat();
char	*strcpy();
off_t	fsize();
#ifndef VMUNIX
int	(*sigset())();
#endif
int	icequal();
char	*alloca();
struct message	*find_mesg();

/* States, set by state variable */
#define	WAIT_FOR_ACK	1		/* Waiting for an ack */
#define RETR_HEAD	2		/* Waiting to retr the head */
#define RETR_BODY	3		/* Waiting to retr the body */
