/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
static char *sccsid = "%W% (Ames) %G%";
#endif not lint

#include "popd.h"
#include "rcv.h"
#include <sys/stat.h>
#include <errno.h>

extern errno;
extern char *sys_errlist[];

head(argc, argv)
char **argv;
{
	return read_head(argc, argv, 1);
}

read_msg(argc, argv)
char **argv;
{
	return read_head(argc, argv, 0);
}

read_head(argc, argv, ishead)
char **argv;
{
	int mesg;	/* message number */

	if (!logged_on) {
		printf("- Logon with HELO first\r\n");
		return (-1);
	}
	if (state == WAIT_FOR_ACK) {
		printf("- waiting for ACKS, ACKD, or NACK\r\n");
		return (-1);
	}
	if (argc > 1) {
		mesg = atoi(argv[1]);
		if (mesg > msgCount)
			newmail();	/* might have new mail */
		if (mesg <= 0 || mesg > msgCount) {
			printf("- Invalid message number.\r\n");
			return (-1);
		}
		dot = find_mesg(mesg);
	}
	if (dot == NULL || dot->m_flag & MDELETED)
		printf("=0 no messages\r\n");
	else if (ishead) {
		printf("=%d lines:%d chars:%d number:%d\r\n",
		    dot->m_hsize + dot->m_hlines -
		    (unixfrom ? 0 : (dot->m_fromsize + 1)),
		    dot->m_lines + (unixfrom ? 1 : 0),
		    dot->m_tsize -
		    (unixfrom ? 0 : (dot->m_fromsize + 1)),
		    dot->m_num);
		state = RETR_HEAD;
	} else {
		printf("=%d characters in message %d\r\n",
		    dot->m_size + dot->m_lines -
		    (unixfrom ? 0 : (dot->m_fromsize + 1)),
		    dot->m_num);
		state = RETR_BODY;
	}
	return 0;
}

/*
 * Go to next message.
 */

acks(argc, argv)
char **argv;
{
	if (!logged_on) {
		printf("- Logon with HELO first\r\n");
		return (-1);
	}
	if (state != WAIT_FOR_ACK) {
		printf("- RETR messages first.\r\n");
		return (-1);
	}
	if ((dot->m_flag & MREAD) == 0)
		dot->m_flag |= MREAD|MSTATUS;
	return next_msg();
}

/*
 * Delete messages.
 */

ackd(argc, argv)
char **argv;
{
	int msgvec[2];

	if (!logged_on) {
		printf("- Logon with HELO first\r\n");
		return (-1);
	}
	if (argc != 1) {
		puts("- Invalid number of arguments.\r");
		return -1;
	}
	if (state != WAIT_FOR_ACK) {
		printf("- RETR messages first.\r\n");
		return (-1);
	}
	msgvec[0] = dot->m_num;
	msgvec[1] = 0;
	(void) delm(msgvec);
	return next_msg();	/* Go to next message. */
}

dele(argc, argv)
char **argv;
{
	register i;
	int buf[2];
	register *msgvec = buf;

	if (!logged_on) {
		puts("- Logon with HELO first\r");
		return (-1);
	}
	if (argc > 1) {
		register i;

#ifdef NOALLOCA
		msgvec = (int *)malloc(argc * sizeof (int));
		if (msgvec == 0) {
			fputs(stdout, "- malloc failed\r\n");
			syslog(LOG_ERR, "malloc: %m");
			cleanup(1);
		}
#else
		msgvec = (int *)alloca(argc * sizeof (int));
#endif
		argv++; argc--;
		for (i = 0; i < argc; i++) {
			msgvec[i] = atoi(argv[i]);
			if (msgvec[i] == 0) {
				printf("- Invalid argument.\r\n");
#ifdef NOALLOCA
				free(msgvec);
#endif
				return (-1);
			}
			if (msgvec[i] <= 0 || msgvec[i] > msgCount) {
				printf("- %d: invalid message number\r\n",
				    msgvec[i]);
#ifdef NOALLOCA
				free(msgvec);
#endif
				return -1;
			}
		}
		msgvec[i] = 0;
	} else {
		if (msgCount == 0) {
			puts("- no messages\r");
			return -1;
		}
		msgvec[0] = dot->m_num;
		msgvec[1] = 0;
	}
	if (delm(msgvec)) {
		puts("- message(s) not deleted\r");
#ifdef NOALLOCA
		if (msgvec != buf)
			free(msgvec);
#endif
		return -1;
	} else {
		puts("+ message(s) deleted\r");
#ifdef NOALLOCA
		if (msgvec != buf)
			free(msgvec);
#endif
		return 0;
	}
}

/*
 * Set dot to next message.
 */
next_msg()
{

	state = 0;
	do
		dot = dot->m_next;
	while (dot && dot->m_flag & MDELETED);
	if (dot == NULL) {
		printf("=0 no more messages\r\n");
		return 0;
	}
	return read_head(0, (char **)NULL, 0);
}

nack(argc, argv)
char **argv;
{
	if (!logged_on) {
		printf("- Logon with HELO first\r\n");
		return (-1);
	}
	if (state != WAIT_FOR_ACK) {
		printf("- not expecting NACK\r\n");
		return (-1);
	}
	/* This is a NACK, but we did give them the message, so
	 * that status is now READ. */
	if ((dot->m_flag & MREAD) == 0)
		dot->m_flag |= MREAD|MSTATUS;
	if (dot->m_flag & MDELETED)	/* Last message. */
		printf("=0\r\n");
	else
		printf("=%d charcters in message %d\r\n",
		    dot->m_size + dot->m_lines -
		    (unixfrom ? 0 : (dot->m_fromsize + 1)),
		    dot->m_num);
	state = RETR_BODY;	/* Try it again. */
	return 0;
}

/*
 * Delete the indicated messages.
 * Leave dot alone.
 * Internal interface.  Assumes all messages in msgvec are valid.
 */

delm(msgvec)
	int *msgvec;
{
	register struct message *mp;
	register *ip, mesg;

	for (ip = msgvec; *ip != NULL; ip++) {
		mesg = *ip;
		mp = find_mesg(mesg);
		if (mp == NULL)
			continue;
		mp->m_flag |= MDELETED|MTOUCH;
		mp->m_flag &= ~(MPRESERVE|MSAVED|MBOX);
	}

	return(0);
}

undel(argc, argv)
char **argv;
{
	register i;
	int buf[2];
	register *msgvec = buf;

	if (!logged_on) {
		puts("- Logon with HELO first\r");
		return (-1);
	}
	if (argc > 1) {
		register i;

#ifdef NOALLOCA
		msgvec = (int *)malloc(argc * sizeof (int));
		if (msgvec == 0) {
			fputs(stdout, "- malloc failed\r\n");
			syslog(LOG_ERR, "malloc: %m");
			cleanup(1);
		}
#else
		msgvec = (int *)alloca(argc * sizeof (int));
#endif
		argv++; argc--;
		for (i = 0; i < argc; i++) {
			msgvec[i] = atoi(argv[i]);
			if (msgvec[i] == 0) {
				printf("- Invalid argument.\r\n");
#ifdef NOALLOCA
				free(msgvec);
#endif
				return (-1);
			}
			if (msgvec[i] <= 0 || msgvec[i] > msgCount) {
				printf("- %d: invalid message number\r\n",
				    msgvec[i]);
#ifdef NOALLOCA
				free(msgvec);
#endif
				return -1;
			}
		}
		msgvec[i] = 0;
	} else {
		if (msgCount == 0) {
			puts("- no messages\r");
			return -1;
		}
		msgvec[0] = dot->m_num;
		msgvec[1] = 0;
	}
	if (undelete(msgvec)) {
		puts("- message(s) not recovered\r");
#ifdef NOALLOCA
		if (msgvec != buf)
			free(msgvec);
#endif
		return -1;
	} else {
		puts("+ message(s) recovered\r");
#ifdef NOALLOCA
		if (msgvec != buf)
			free(msgvec);
#endif
		return 0;
	}
}

/*
 * Undelete the indicated messages.
 */

undelete(msgvec)
	int *msgvec;
{
	register struct message *mp;
	register *ip;

	for (ip = msgvec; *ip; ip++) {
		mp = find_mesg(*ip);
		if (mp == NULL)
			continue;
		dot = mp;
		mp->m_flag &= ~MDELETED;
	}
	return 0;
}

#include <sys/types.h>
#include <sys/socket.h>

pass(argc, argv)
char **argv;
{
	char buf[BUFSIZ];
	int n, pid, fds[2];
	char *cp;

	if (argc != 3) {
		fputs(stdout, "Usage: PASS oldpass newpass\r\n");
		return;
	}
	if (!logged_on) {
		fputs(stdout, "Must log in first.\r\n");
		return;
	}
	if (socketpair(AF_UNIX, SOCK_STREAM, 0, fds) < 0) {
		printf("- socketpair: %s\r\n", sys_errlist[errno]);
		return;
	}
	pid = vfork();
	if (pid < 0) {
		close(fds[0]);
		close(fds[1]);
		printf("- fork: %s\r\n", sys_errlist[errno]);
		return;
	}
	if (pid == 0) {
		close(fds[1]);
		dup2(fds[0], 0);
		dup2(fds[0], 1);
		dup2(fds[0], 2);
		execlp("passwd", "passwd", username, 0);
		perror("passwd");
		_exit(1);
	}
	close(fds[0]);
	if (checkstr(fds[1], "Old"))
		goto out;
	write(fds[1], argv[1], strlen(argv[1]));
	write(fds[1], "\n", 1);
	if (checkstr(fds[1], "New"))
		goto out;
	write(fds[1], argv[2], strlen(argv[2]));
	write(fds[1], "\n", 1);
	if (checkstr(fds[1], "Retype"))
		goto out;
	write(fds[1], argv[2], strlen(argv[2]));
	write(fds[1], "\n", 1);
	printf("+ Password changed.\r\n");
out:
	close(fds[1]);
	while ((n = wait(0)) != -1 && n != pid)
		;
}

checkstr(fd, str)
char *str;
{
	char buf[BUFSIZ];
	char *b = buf, *cp;
	int n;

	sleep(1);
	n = read(fd, buf, sizeof buf - 1);
	if (n < 0) {
		printf("- read: %s\r\n", sys_errlist[errno]);
		return 1;
	}
	if (n == 0) {
		printf("- failed\r\n");
		return 1;
	}
	buf[n] = '\0';
	while (*b == '\n')
		b++;
	if(strncmp(b, str, strlen(str))) {
		if (cp = index(b, '\n'))
			*cp = 0;
		printf("- %s\r\n", b);
		return 1;
	}
	return 0;
}

struct message *
find_mesg(num)
register num;
{
	register struct message *mp;

	for (mp = message; mp; mp = mp->m_next)
		if (mp->m_num == num)
			break;
	return mp;
}
