/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1980 Regents of the University of California.\n\
 All rights reserved.\n";
#endif not lint

#ifndef lint
static char osccsid[] = "@(#)comsat.c	5.4 (Berkeley) 9/17/85";
static char sccsid[] = "%W% (Ames) %G%";
#endif not lint

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/file.h>

#include <netinet/in.h>

#include <stdio.h>
#include <errno.h>
#include <netdb.h>

#include <pwd.h>

/*
 * comsat
 */
int	debug = 0;
#define	dprintf	if (debug) printf

struct	sockaddr_in sin = { AF_INET };
extern	errno;

char 	*malloc(), *realloc();
char	*index();
char	*getline();
char	*getenv();

main(argc, argv)
	int argc;
	char *argv[];
{
	char *name;
	register struct passwd *pw;
	FILE *fp, *fi;
	char buf[BUFSIZ];
	char headbuf[1024];
	char junk[4];
	char *from=NULL, *to=NULL, *subject=NULL;
	register char *cp;
	char *ehb;
	int s;
	int status=0;

	if (argc >= 2)
		name = argv[1];
	else
		name = getenv("USER");
	if (!name) {
		fprintf(stderr, "Usage: comsat user\n");
		exit(1);
	}

	pw = getpwnam(name);
	if (pw == NULL) {
		fprintf(stderr, "%s: no such user.\n", name);
		return 1;
	}
	strcpy(buf, pw->pw_dir);
	cp = buf + strlen(buf);
	strcpy(cp, "/.popd");
	fp = fopen(buf, "r");
	if (fp == NULL) {
		strcpy(cp, "/.pc");
		fp = fopen(buf, "r");
		if (fp == NULL)
			return 1;
	}

	s = socket(AF_INET, SOCK_DGRAM, 0);
	if (s < 0) {
		perror("socket");
		return 1;
	}

	fi = stdin;

	while (fgets(buf, sizeof buf, fi) != NULL) {
		if (buf[0] == '\n')
			break;
		if (strncmp(buf, "From:", 5) == 0) {
			from = getline(buf, fi);
		} else if (strncmp(buf, "To:", 3) == 0) {
			to = getline(buf, fi);
		} else if (strncmp(buf, "Subject:", 8) == 0) {
			subject = getline(buf, fi);
		}
	}
	if (from == NULL)
		from = "";
	if (to == NULL)
		to = "";
	if (subject == NULL)
		subject = "";
	cp = headbuf;
	while (*name && cp < &headbuf[sizeof headbuf])
		*cp++ = *name++;
	*cp++ = '\0';
	while (*from && cp < &headbuf[sizeof headbuf])
		*cp++ = *from++;
	*cp++ = '\0';
	while (*subject && cp < &headbuf[sizeof headbuf])
		*cp++ = *subject++;
	*cp++ = '\0';
	while (*to && cp < &headbuf[sizeof headbuf])
		*cp++ = *to++;
	*cp++ = '\0';
	ehb = cp;

	while (fgets(buf, sizeof buf, fp)) {
		if (cp = index(buf, '\n'));
			*cp = '\0';
		if (buf[0] == '\0')
			continue;
		if (send_udp(s, buf, headbuf, ehb-headbuf) == 0)
			status++;
	}
	close(s);
	return status;
}

char *
getline(line, fp)
char *line;
FILE *fp;
{
	register char *cp, *cp2;
	int c, size, i;
	char buf[BUFSIZ];

	if (cp = index(line, '\n'))
		*cp = '\0';
	if (cp = index(line, ':'))
		cp++;
	while (*cp == ' ' || *cp == '\t')
		cp++;
	size = strlen(cp) + 1;
	cp2 = malloc(size);
	if (cp2 == NULL)
		return NULL;
	strcpy(cp2, cp);
	while ((c = getc(fp)) == ' ' || c == '\t') {
		ungetc(c, fp);
		fgets(buf, sizeof buf, fp);
		if (cp = index(buf, '\n'))
			*cp = '\0';
		i = strlen(buf);
		cp2 = realloc(cp2, size + i);
		if (cp2 == NULL)
			return NULL;
		strcpy(cp2+size-1, buf);
		size += i;
	}
	ungetc(c, fp);
	return cp2;
}

send_udp(s, name, buf, len)
char *name, *buf;
{
	struct in_addr addr;
	struct sockaddr_in sa;
	struct hostent *hp;
	static struct servent *pop = NULL;

	if (name[0] >= '0' && name[0] <= '9') {
		addr.s_addr = inet_addr(name);
	} else {
		hp = gethostbyname(name);
		if (hp == NULL) {
			return 1;
		}
		bcopy(hp->h_addr, &addr, hp->h_length);
	}

	if (pop == NULL) {
		pop = getservbyname("pop", "udp");
		if (pop == NULL) {
			fputs("Can't find \"pop/udp\"\n", stderr);
			exit(1);
		}
	}
	sa.sin_family = AF_INET;
	sa.sin_port = pop->s_port;
	sa.sin_addr = addr;
	(void) sendto(s, buf, len, 0, &sa, sizeof sa);
}
