/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */
/*
 * A module in the Steve Schoch biff system.  This module writes
 * a message to the user's tty, given the mail header on standard
 * input.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1980 Regents of the University of California.\n\
 All rights reserved.\n";
#endif not lint

#ifndef lint
static char osccsid[] = "@(#)comsat.c	5.4 (Berkeley) 9/17/85";
static char sccsid[] = "%W% (Ames) %G%";
#endif not lint

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/file.h>

#include <stdio.h>
#include <utmp.h>
#include <signal.h>
#include <errno.h>
#ifdef SYSV
#include <sys/termio.h>
#else
#include <sgtty.h>
#include <syslog.h>
#endif

#include <pwd.h>
#include <ctype.h>

/*
 * comsat
 */
int	debug = 0;
#define	dprintf	if (debug) printf

extern	errno;

char	hostname[32];
struct	utmp *utmp = NULL;
int	nutmp;
char 	*malloc();
char	*getenv();

main(argc, argv)
	int argc;
	char *argv[];
{
	char *user;

	if (argc >= 2)
		user = argv[1];
	else
		user = getenv("USER");
	if (!user) {
		fprintf(stderr, "Usage: comsat user\n");
		exit(1);
	}
	gethostname(hostname, sizeof (hostname));
	utmp_init();
	signal(SIGTTOU, SIG_IGN);
	return mailfor(user);
}

utmp_init()
{
	struct stat statbf;
	int uf;
	unsigned utmpsize;

	if ((uf = open("/etc/utmp",0)) < 0) {
#ifdef LOG_ERR
		syslog(LOG_ERR, "/etc/utmp: %m");
#endif
		exit(1);
	}
	fstat(uf, &statbf);
	utmpsize = statbf.st_size + 10 * sizeof(struct utmp);
	utmp = (struct utmp *)malloc(utmpsize);
	if (! utmp) {
		dprintf("malloc failed\n");
		exit(1);
	}
	nutmp = read(uf,utmp,statbf.st_size) / sizeof(struct utmp);
	(void) close(uf);
}

mailfor(name)
	char *name;
{
	register struct utmp *utp = &utmp[nutmp];
	int offset;
	int status=0;

	offset = lseek(0, 0, L_INCR);
	while (--utp >= utmp)
		if (!strncmp(utp->ut_name, name, sizeof(utmp[0].ut_name)))
			status += notify(utp, offset);
	return !status;
}

char	*cr;

notify(utp, offset)
	register struct utmp *utp;
{
	FILE *tp;
#ifdef SYSV
	struct termio termio;
#else
	struct sgttyb gttybuf;
#endif
	char tty[20], name[sizeof (utmp[0].ut_name) + 1];
	struct stat stb;
	int pid;

	strcpy(tty, "/dev/");
	strncat(tty, utp->ut_line, sizeof(utp->ut_line));
	if (stat(tty, &stb) < 0 || (stb.st_mode & 0100) == 0) {
		return 0;
	}
	pid = fork();
#ifdef LOG_ERR
	if (pid < 0)
		syslog(LOG_ERR, "fork: %m");
#endif
	if (pid)
		return 1;
	close(1); close(2);
	/* The following to make stdio happy */
	(void) open("/", O_RDONLY, 0);
	(void) dup(1);
	strncpy(name, utp->ut_name, sizeof (utp->ut_name));
	signal(SIGALRM, SIG_DFL);
	alarm(30);

	if ((tp = fopen(tty,"w")) == 0) {
#ifdef LOG_ERR
		syslog(LOG_ERR, "%s: %m", tty);
#endif
		exit(-1);
	}
#ifdef SYSV
	ioctl(fileno(tp), TCGETA, &termio);
	cr = (termio.c_oflag&ONLCR) && (termio.c_oflag&OPOST) ? "" : "\r";
#else
	ioctl(fileno(tp), TIOCGETP, &gttybuf);
	cr = (gttybuf.sg_flags&CRMOD) && !(gttybuf.sg_flags&RAW) ? "" : "\r";
#endif
	name[sizeof (name) - 1] = '\0';
	fprintf(tp,"%s\n\007New mail for %s@%s\007 has arrived:%s\n",
	    cr, name, hostname, cr);
	fprintf(tp,"----%s\n", cr);
	jkfprintf(tp, name, offset);
	exit(0);
}

jkfprintf(tp, name, offset)
	register FILE *tp;
{
	register FILE *fi;
	register int linecnt, charcnt;
	char line[BUFSIZ];
	int inheader;

	fi = stdin;
	lseek(0, offset, L_SET);
	/* 
	 * Print the first 7 lines or 560 characters of the new mail
	 * (whichever comes first).  Skip header crap other than
	 * From, Subject, To, and Date.
	 */
	linecnt = 7;
	charcnt = 560;
	inheader = 1;
	while (fgets(line, sizeof (line), fi) != NULL) {
		register char *cp;
		char *index();
		int cnt;

		if (linecnt <= 0 || charcnt <= 0) {  
			fprintf(tp,"...more...%s\n", cr);
			return;
		}
		if (strncmp(line, "From ", 5) == 0)
			continue;
		if (inheader && (line[0] == ' ' || line[0] == '\t'))
			continue;
		cp = index(line, ':');
		if (cp == 0 || (index(line, ' ') && index(line, ' ') < cp))
			inheader = 0;
		else
			cnt = cp - line;
		if (inheader &&
		    strncmp(line, "Date", cnt) &&
		    strncmp(line, "From", cnt) &&
		    strncmp(line, "Subject", cnt) &&
		    strncmp(line, "To", cnt))
			continue;
		cp = index(line, '\n');
		if (cp)
			*cp = '\0';
		for (cp = line; *cp ; cp++) {
			*cp &= 0177;
			if (!isprint(*cp)) {
				putc('^', tp);
				*cp |= 0x40;
				if (*cp == 0177)
					*cp = '?';
			}
			putc(*cp, tp);
		}
		fprintf(tp,"%s\n", cr);
		linecnt--, charcnt -= strlen(line);
	}
	fprintf(tp,"-----%s\n", cr);
}
