/*
 
 *  sock.c --
 
 *      Socket interface for PC NFS file server.  This module provides
 
 *      one level of abstraction above the socket libraries and socket driver
 
 *      functions perculiar to different PC Ethernet cards.
 
 *	Note:  this version for the PC-NFS Programmers Toolkit only.
 
 *
 
 *  Author:
 
 *	See-Mong Tan, 6/23/88
 
 *  Hacked on by:
 
 *	Geoff Arnold, 11/18/88
 
 */
 

 
#include "common.h"
 
#include <netdb.h>
 
#include <sys\ioctl.h>
 

 
unsigned int old_avl = 0;
 
unsigned int new_avl;
 

 
static struct {
 
    int rcv_pkt;
 
    int rcv_buff;
 
} setpopts;
 
static int need_to_set_pparm = 1;
 

 
extern int errno;
 

 
/*
 
 *  int sock_create(int type, int protocol, struct sockaddr_in *addr) --
 
 *      Creates a socket of type using protocol, bound to address *addr on the
 
 *      local PC.  Returns the socket descriptor or -1 if an error
 
 *      occurred.
 
 */
 
int sock_create(type, protocol, addr)
 
	int type, protocol;
 
	struct sockaddr_in *addr;
 
{
 
	int socknum;
 
	int constant_one = 1;
 

 
	if(need_to_set_pparm) {
 
	    setpopts.rcv_buff = 8192;
 
	    setpopts.rcv_pkt = 0; /* use the default */
 
	    setpparm(IPPROTO_UDP, &setpopts);
 
	    need_to_set_pparm = 0;
 
	}
 
	socknum = socket(AF_INET, type, protocol);
 
	if(socknum < 0)
 
	    return socknum;
 
	if(bind(socknum, (struct sockaddr *) addr,
 
	    sizeof(struct sockaddr_in)) < 0) {
 
		close(socknum);
 
		return -1;
 
	    }
 
	ioctl(socknum, FIONBIO, &constant_one);
 
	return socknum;
 
}
 

 
/*
 
 *  void sock_close(int sock) --
 
 *      Closes the socket descriptor sock.
 
 */
 
void sock_close(sock)
 
	int sock;
 
{
 
	(void) close(sock);
 
}
 

 
static struct timeval poll = {0,0};
 
/*
 
 *  int sock_select(int *rfds, int *wfds) --
 
 *      Returns the number of descriptors readable corresponding to
 
 *      the bit masks in *rfds, or writable in *wfds.
 
 *      *rfds and *wfds are changed to reflect the readable sockets.
 
 */
 
int sock_select(rfds, wfds)
 
	long *rfds, *wfds;
 
{
 
	return select(32, rfds, wfds, (long *)0, &poll);
 
}
 

 
/*
 
 *  int sock_recv(int sock, char *buf, int bufsiz, struct sockaddr_in *from) --
 
 *      Recevies message from socket and puts it into buffer.  The from address
 
 *      is placed in *from.  Returns the size of the message.
 
 */
 
int sock_recv(sock, buf, bufsiz, from)
 
	int sock;
 
	char *buf;
 
	int bufsiz;
 
	struct sockaddr_in *from;
 
{
 
	int addrlen = sizeof(struct sockaddr_in);
 

 
	new_avl = _memavl();
 
	if(new_avl != old_avl)
 
	       printf("free space %8u -> %8u\n", old_avl, new_avl);
 
	old_avl = new_avl;
 

 
	return recvfrom(sock, buf, bufsiz, 0, from, &addrlen);
 
}
 
	
 
/*
 
 *  int sock_send(int sock, struct sockaddr_in *addr, char *msg, int len) --
 
 *      Transmits a message msg using sock to host at *addr of length len.
 
 *      Assumed to be a UDP socket.  Returns the number of bytes sent, or -1
 
 *      if an error occurred.
 
 */
 
 extern int errno;
 
int sock_send(sock, addr, msg, len)
 
	int sock;
 
	struct sockaddr_in *addr;
 
	char *msg;
 
	int len;
 
{
 
	int addrlen = sizeof(struct sockaddr_in);
 
	int res;
 

 
	res = sendto(sock, msg, len, 0, (struct sockaddr *) addr, addrlen);
 

 
	return(res);
 
}
 

 
/*
 
 *  int sock_getsockaddr(int sock, struct sockaddr_in *addr) --]
 
 *      Returns socket address in *addr.  Returns -1 if an error
 
 *      occurred.
 
 */
 
int sock_getsockaddr(sock, addr)
 
	int sock;
 
	struct sockaddr_in *addr;
 
{
 
	int addrlen = sizeof(struct sockaddr_in);
 
	return getsockname(sock, addr, &addrlen);
 
}
 

 
/*
 
 *  char *sock_gethostbyaddr(struct sockaddr_in addr) --
 
 *      Returns a character pointer to the hostname
 
 */
 
char *sock_gethostbyaddr(addr)
 
	struct sockaddr_in addr;
 
{
 
	extern struct hostent *gethostbyaddr();
 
	struct hostent *h;
 
	h = gethostbyaddr(addr, sizeof(struct sockaddr_in), AF_INET);
 
	return (h == NULL ? NULL : h->h_name);
 
}
 

 
/*
 
 *  long sock_gethostbyname(char *name) --
 
 *      Returns host IP address given host name.  Returns -1 for error.
 
 */
 
long sock_gethostbyname(name)
 
	char *name;
 
{
 
	extern struct hostent *gethostbyname();
 
	struct hostent *h;
 

 
	h = gethostbyname(name);
 
	return(h == NULL ? NULL : (long) h->h_addr);
 
}
 

 
