/*
 
 *  dtime.c --
 
 *      Converts dos to unix time, ie. # of seconds since Jan 1, 1970.
 
 *
 
 *  Author: See-Mong Tan
 
 */
 

 
#include "common.h"
 
#ifdef DEBUG
 
#include <fcntl.h>
 
#include <sys/stat.h>
 
#include <io.h>
 

 
extern int errno;
 
#endif
 

 
/*
 
 *  bool_t dtime_init() --
 
 *      Initialize the time module.  Should be called before any other
 
 *	routine in this module.  Returns TRUE if no error occurs.
 
 */
 
bool_t dtime_init()
 
{
 
	tzset();		/* set global time variables */
 

 
	return TRUE;
 
}
 

 
/* cumulative count of the days in a month */
 
static long dayspermonth[] = {
 
 	0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365,
 
};
 

 
/*
 
 * long unixtime(unsigned time, unsigned date) --
 
 *      Converts DOS style time and date to UNIX style time, ie. # of
 
 *	seconds since midnight, Dec 31, 1969.
 
 */
 
long unixtime(time, date)
 
	unsigned time, date;
 
{
 
	long t = 0;
 
	long sec, min, hour, day, month, year;
 
	
 
	
 
	sec = (long) ((time & 0x1f) << 1);
 
	min = (long) ((time >> 5) & 0x3f);
 
	hour = (long) ((time >> 11) & 0x1f);
 
	t = sec + min * 60 + hour * 60 * 60;
 

 
	day = (long) (date & 0x1f);
 
	t += (day - 1) * 24 * 60 * 60;			/* day of month */
 
	/* calculate the month */
 
	month = (long) ((date >> 5) & 0xf);		/* month field */
 
	t += dayspermonth[(int) month - 1] * 24 * 60 * 60;
 

 
	/* calculate the year */
 
	year = (long) (((date >> 9) & 0x7f) + 1980);	/* year field */
 
	t += (year - 1970) * 365 * 24 * 60 * 60;
 

 
	/* now add the number of leap days since 1970 including this */
 
	t += (long) ((year - 1968) >> 2) * 24 * 60 * 60;
 

 
	if (year % 4 == 0 && month < 3)			/* this year is leap */
 
		t -= (long) 24 * 60 * 60;		/* take way 29 feb */
 
#ifdef DEBUG
 
	(void) printf("ftime = %lx\n", t);
 
	(void) printf("ctime = %s\n", ctime(&t));
 
#endif		
 
	t -= timezone;		/* take away difference in secs from GMT */
 

 
	return t;
 
}
 

 
