;	@(#)select.inc.u	8.1	3/15/89
;************************************************************************
;************************************************************************
;***                                                                  ***
;***       Sun Microsystems Incorporated    P C - N F S   Source      ***
;***                                                                  ***
;***                                                                  ***
;***       Copyright (c) 1986, 1987 by Sun Microsystems, Inc.         ***
;***                                                                  ***
;***               ***** All rights reserved. *****                   ***
;***                                                                  ***
;***       Source licensees should refer to their source license      ***
;***       agreement for the detailed terms and conditions cover-     ***
;***       ing the use of this code. Under no circumstances may       ***
;***       this notice be removed from the source code.               ***
;***                                                                  ***
;************************************************************************
;************************************************************************
;***                                                                  ***
;***       Module name: select.inc                                    ***
;***                                                                  ***
;***       Description: This file includes the structure definitions  ***
;***                    for the select table, a macro which will      ***
;***                    build it, and numerous macros for fiddling    ***
;***                    and diddling with select table fields.        ***
;***                                                                  ***
;************************************************************************
;************************************************************************

;/*
; * The following declarations define the layout of the
; * select table structure. They correspond exactly to the
; * C language definitions in select.h, and should not be
; * edited without making corresponding changes therein.
; */
;
; The following structure defines a select table entry,
; corresponding to a single Service Access Point

sel_entry	struc
sel_routine_off	dw	?		; dword ptr to ...
sel_routine_seg	dw	0		; ... receive upcall rtn
sel_addr_off	dw	?		; dword ptr to ...
sel_addr_seg	dw	0		; ... buffer
sel_busy	db	?		; 0 - free, 1 - busy
sel_ds		dw	0		; if non-0, data segment for upcall
sel_buffsize	dw	?		; size of buffer at sel_addr
sel_proto	db	?		; protocol (0 - free)
sel_localport	dw	?		; = dest port in packet
sel_rmtport	dw	?		; = remote port, or 0 (wildcard)
sel_rmt_addr_lo	dw	0		; low word of remote IP address, or 0
sel_rmt_addr_hi	dw	0		; high word of remote IP address, or 0
sel_updata	dw	0		; data supplied to upcall rtn  on stack??

sel_entry	ends
se_size		equ	size sel_entry
; The following structure defines the select table header

;
sel_hdr		struc
sel_max		db	16		; number of entries
sel_ethaddr	db	6 dup (0)	; our Ethernet address
sel_logtab_o	dw	0		; dword ptr to ...
sel_logtab_s	dw	0		; ... log table
sel_largest	dw	0		; MTU
sel_hdr		ends
sh_size		equ	size sel_hdr

;
;	The following macro will create a select table:
;
generate_select_table	macro
public		sel_table
sel_table	sel_hdr		<,,log_buffer>
sel_0_arp	sel_entry	<arp_rec_notify,,arp_rec_buf,,0,,256,-1,-1,-1>
sel_1_ipfrag	sel_entry	<ipfrag_rec_notify,,0,,1,,1532,-1,-1,-1>
sel_2_icmp	sel_entry	<icmp_rec_notify,,icmp_rec_buf,,0,,256,ip_subtype_icmp,0,0>
sel_3_nfs	sel_entry	<nfs_rec_notify,,0,,1,,1532,ip_subtype_udp,_NFS_CLIENT_PORT,0>
sel_4_lvd	sel_entry	<lvd_rec_notify,,lvd_rec_buf,,0,,256,ip_subtype_udp,DISCARD_PROTOCOL_PORT,0>
sel_5_dynamic	sel_entry	<0,,0,,1,,1532,0,0,0>
sel_6_dynamic	sel_entry	<0,,0,,1,,1532,0,0,0>
sel_7_dynamic	sel_entry	<0,,0,,1,,1532,0,0,0>
sel_8_dynamic	sel_entry	<0,,0,,1,,1532,0,0,0>
sel_9_dynamic	sel_entry	<0,,0,,1,,1532,0,0,0>
sel_10_dynamic	sel_entry	<0,,0,,1,,1532,0,0,0>
sel_11_dynamic	sel_entry	<0,,0,,1,,1532,0,0,0>
sel_12_dynamic	sel_entry	<0,,0,,1,,1532,0,0,0>
sel_13_othertcp	sel_entry	<0,,0,,1,,1532,ip_subtype_tcp,0,0>
ifdef obsolete
sel_14_otherudp	sel_entry	<udp_rec_notify,,udp_rec_buf,,0,,1532,ip_subtype_udp,0,0>
else
sel_14_otherudp	sel_entry	<0,,0,,1,,1532,0,0,0>
endif
sel_15_trash	sel_entry	<0,,0,,1,,1532,0,0,0> 
		endm
;
;	the actual select table is declared
;	in nfsinit.asm as

;
;	The following nifty equates define the select numbers more
;	conveniently (especialy for macros):

_SELECT_ARP	equ	0
_SEL_OFF_ARP	equ	sh_size + (_SELECT_ARP * se_size)
_SELECT_IPFRAG	equ	1
_SEL_OFF_IPFRAG	equ	sh_size + (_SELECT_IPFRAG * se_size)
_SELECT_ICMP	equ	2
_SEL_OFF_ICMP	equ	sh_size + (_SELECT_ICMP * se_size)
_SELECT_NFS	equ	3
_SEL_OFF_NFS	equ	sh_size + (_SELECT_NFS * se_size)
_SELECT_LVD	equ	4
_SEL_OFF_LVD	equ	sh_size + (_SELECT_LVD * se_size)
_SELECT_DYNAMIC	equ	5
_SEL_OFF_DYNAMIC	equ	sh_size + (_SELECT_DYNAMIC * se_size)
_SELECT_TCP	equ	13
_SEL_OFF_TCP	equ	sh_size + (_SELECT_TCP * se_size)
_SELECT_UDP	equ	14
_SEL_OFF_UDP	equ	sh_size + (_SELECT_UDP * se_size)
_SELECT_TRASH	equ	15
_SEL_OFF_TRASH	equ	sh_size + (_SELECT_TRASH * se_size)
;
;	The next couple of macros allow you to set the value of a
;	particular field in a given select entry:

smov_b	macro	snum,sentry,val
ifndef sel_table
extrn	sel_table : byte
endif
	mov	byte ptr (sel_table+sh_size+(&snum*se_size)).&sentry, &val
	endm	;smov_b

smov_b_cs	macro	snum,sentry,val
ifndef sel_table
extrn	sel_table : byte
endif
	mov	cs:byte ptr (sel_table+sh_size+(&snum*se_size)).&sentry, &val
	endm	;smov_b_cs

smov_w	macro	snum,sentry,val
ifndef sel_table
extrn	sel_table : byte
endif
	mov	word ptr (sel_table+sh_size+(&snum*se_size)).&sentry, &val
	endm	;smov_w

;
;	The obvious variant: compare field with value
;


scmp_b	macro	snum,sentry,val
ifndef sel_table
extrn	sel_table : byte
endif
	cmp	byte ptr (sel_table+sh_size+(&snum*se_size)).&sentry, &val
	endm	;scmp_b

scmp_b_cs	macro	snum,sentry,val
ifndef sel_table
extrn	sel_table : byte
endif
	cmp	cs:byte ptr (sel_table+sh_size+(&snum*se_size)).&sentry, &val
	endm	;scmp_b_cs

sget_w	macro	reg,snum,sentry
ifndef sel_table
extrn	sel_table : byte
endif
	mov	reg, word ptr (sel_table+sh_size+(&snum*se_size)).&sentry
	endm	;sget_w

sget_w_cs	macro	reg,snum,sentry
ifndef sel_table
extrn	sel_table : byte
endif
	mov	reg, cs:word ptr (sel_table+sh_size+(&snum*se_size)).&sentry
	endm	;sget_w_cs

;
;	A very common request: clear the buffer busy flag for a select entry
;
bufclear	macro	snum
	smov_b	snum,sel_busy,0
	endm	;bufclear

bufclear_cs	macro	snum
	smov_b_cs	snum,sel_busy,0
	endm	;bufclear_cs
;
;	Another common request: test the buffer busy flag 
;
buftest	macro	snum
	scmp_b	snum,sel_busy,0
	endm	;buftest

buftest_cs	macro	snum
	scmp_b_cs	snum,sel_busy,0
	endm	;buftest_cs



