;	@(#)protocol.inc.u	8.1	3/15/89
;************************************************************************
;************************************************************************
;***                                                                  ***
;***       Sun Microsystems Incorporated    P C - N F S   Source      ***
;***                                                                  ***
;***                                                                  ***
;***       Copyright (c) 1986, 1987 by Sun Microsystems, Inc.         ***
;***                                                                  ***
;***               ***** All rights reserved. *****                   ***
;***                                                                  ***
;***       Source licensees should refer to their source license      ***
;***       agreement for the detailed terms and conditions cover-     ***
;***       ing the use of this code. Under no circumstances may       ***
;***       this notice be removed from the source code.               ***
;***                                                                  ***
;************************************************************************
;************************************************************************
;***                                                                  ***
;***       Module name:  protocol.inc                                 ***
;***                                                                  ***
;***       Description:  Various IP packet offsets & fields           ***
;***                                                                  ***
;************************************************************************
;************************************************************************

;	@(#)protocol.inc.u	5.1	4/24/87
;
; Network packet types in network (i.e. byte-reversed) form - see led.asm
;
ARP_ETHER_TYPE		EQU 608H
REVARP_ETHER_TYPE	EQU 3580H
INTERNET_ETHER_TYPE	EQU 8H

ip_header_size	equ	20

;
;
;	This is not in network order
;
DISCARD_PROTOCOL_PORT	equ	9

;	packet offsets of interest
pkt_dest	equ 0			; destination address
pkt_type	equ 12			; type field (ARP or IP)
pkt_ver_ihl	equ 14			; start of IP header
pkt_ip_frag	equ 20			; 16 bit fragmentation info
pkt_ip_subtype	equ 23			; IP subprotocol (TCP, ICMP or UDP)
pkt_udp_dport	equ 36			; IP/UDP destination port
; actually it's pkt_ver_ihl + ihl*4 + 2
pkt_select	equ 42			; stream select field

; network dependent data
largest_packet	equ 1515


;
;	the following are the flag bits in the ip header
;
ip_flag_df	equ	04000h		; don't fragment
ip_flag_mf	equ	02000h		; more fragments
ip_flag_off	equ	01fffh		; offset field mask

;
; The following are just bytes in the IP header

ip_subtype_udp	equ	17	
ip_subtype_icmp	equ	1
ip_subtype_tcp	equ	6



; icmp specific definitions.
;

icmp_echo_reply		equ	000h
icmp_dest_unreach	equ	003h
icmp_source_quench	equ	004h
icmp_redirect		equ	005h
icmp_echo_message	equ	008h
icmp_time_exceeded	equ	00bh
icmp_param_problem	equ	00ch
icmp_timestamp		equ	00dh
icmp_timestamp_reply	equ	00eh
icmp_info_request	equ	00fh
icmp_info_reply		equ	010h
icmp_am_req		equ	011h		; AM1 - address mask request
icmp_am_resp		equ	012h		; AM2 - address mask reply

ether_icmp	struc
icmp_eth_dummy		db	14 dup(0)	      ; skip ethernet stuff
icmp_ip_dummy		db	ip_header_size dup(0) ; skip ip stuff
icmp_type		db	0
icmp_code		db	0
icmp_chksum		dw	0
icmp_ident		dw	0		; for AM1/AM2 - ignored
icmp_seq		dw	0		; ditto
icmp_amask		dd	0		; addr mask or orig.timestamp
icmp_rcv_tstamp		dd	0		; rcv timestamp
icmp_xmit_tstamp	dd	0
ether_icmp	ends

problem_icmp	struc
p_icmp_eth_dummy	db	14 dup(0)	      ; skip ethernet stuff
p_icmp_ip_dummy		db	ip_header_size dup(0) ; skip ip stuff
p_icmp_type		db	0
p_icmp_code		db	0
p_icmp_chksum		dw	0
p_icmp_gw_l		dw	0		; gateway for redirect
p_icmp_gw_h		dw	0
p_icmp_ip_hl_v		db	0		; IP header of packet
p_icmp_ip_tos		db	0
p_icmp_ip_len		dw	0
p_icmp_ip_id		dw	0
p_icmp_ip_offset	dw	0
p_icmp_ip_ttl		db	0
p_icmp_ip_p		db	0
p_icmp_ip_sum		dw	0
p_icmp_ip_src_l		dw	0		; src IP addr from hdr
p_icmp_ip_src_h		dw	0
p_icmp_ip_dest_l	dw	0		; dest IP addr from hdr
p_icmp_ip_dest_h	dw	0
; more stuff we don't care about
problem_icmp	ends
