/*  Copyright 1986 by Carnegie Mellon  */
/*  See permission and disclaimer notice in file "cmu-note.h"  */
#include	<cmu-note.h>
/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */
#include	<notice.h>

#include <stdio.h>
#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <netbuf.h>
#include "slip.h"
#include "sl.h"

/* Variables which form the interface between sl_write() and the interrupt
	handling code in sl_bout(). */

char PSEND = FALSE;		/* Global availability flag */
char DOSEND = FALSE;		/* do send the character */
static int plen = 0;		/* Data length */
static char *buffpsn;		/* Current buffer position */
static char pushf = 0;		/* Have a special character to send */
static char push = 0;		/* This is it */

/* Statistics counters */
unsigned slsnd = 0;		/* packets transmitted */
unsigned slbsnd = 0;		/* bytes transmitted */
unsigned slsesc = 0;		/* how many slip ESC's sent */
unsigned slnotx = 0;		/* # of tx interrupts w/nothing to do */
unsigned slbusy = 0;		/* # of attempts to send while busy */
unsigned sltmo = 0;		/* timeouts during packet send */

/* This routine is used at interrupt level and is called to handle outputing
	bytes to the Gateway. For efficiency's sake, the buffer that
	has the packet in it is passed to the routine which initiates the
	output by the Internet package. Also, to avoid a copy or munging on
	that packet, this routine does SLIP encoding on the fly. The local
	net header is assumed to have already been built.

	SL_BOUT() returns the character which is to be transmitted, or
	a 0xFFFF to indicate that there should be no character transmitted,
	since it is possibe for us to get a txmitter interrupt when we
	don't really want one.
 */
unsigned sl_bout()
{
	char wrchr;

	DOSEND = TRUE;

	if(pushf) {
		wrchr = push;
		pushf = FALSE;
		plen--;
	}
	else if(PSEND) {
		if(!plen) {
			wrchr = FRAME_END;
			PSEND = FALSE;
			slsnd++;
			return wrchr;
		}

		if(*buffpsn == FRAME_ESC) {
			wrchr = FRAME_ESC;
			pushf = TRUE;
			push  = TRANS_FRAME_ESC;
			slsesc++;
		}
		else if(*buffpsn == FRAME_END) {
			wrchr = FRAME_ESC;
			pushf = TRUE;
			push  = TRANS_FRAME_END;
			slsesc++;
		}
		else {
			wrchr = *buffpsn;
			plen--;
		}
		buffpsn++;
	}
	else {
		slnotx++;
		DOSEND = FALSE;
		slbsnd--;	/* Counter the increment below */
	}

	slbsnd++;
	return wrchr;
}


/* SL_WRITE(buffer, protocol) constructs the low-level header for the packet
	in buffer and then attempts to transmit it. Timeouts are checked
	on. If the attempt was successful, length is returned; otherwise 0.
 */

extern long cticks;

int sl_write(p, protocol, len)
	PACKET p;		/* packet buffer */
	unsigned protocol;	/* protocol = IP, chaos, etc. */
	unsigned len;		/* number of bytes in packet */
{
	long time;
	int retries;
	char *data;

	data = p->nb_prot;
#ifdef 	DEBUG
	if (NDEBUG & NETRACE) 
		printf("SLIP:  Sending packet in protocol %u, length %u\n",
				protocol, len);
#endif

	/* Wait for the output routines to become unbusy */
	if(PSEND) {
#ifdef	DEBUG
		if(NDEBUG & (NETERR|PROTERR|INFOMSG))
			printf("SL_WRITE: Serial Line was BUSY!!!\n");
#endif
		slbusy++;
	}

	plen = len+1;
	buffpsn = p->nb_prot;
	PSEND = TRUE;
	pushf = TRUE;		/* Send an extra frame end to make sure */
	push = FRAME_END;	/* 	receiver starts a new packet. */
	_wake_serial();
	time = cticks;
	while(PSEND)
		if(cticks - time > PTIMEOUT) {
#ifdef	DEBUG
			if(NDEBUG & (PROTERR|NETERR|TMO))
			     printf("SL_WRITE: ptimeout\n");
#endif
			sltmo++;
			PSEND = FALSE;
			return 0;
		}
	return 1;
}  /*  end of sl_write() */
